/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.detector.cache;

import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import java.util.LinkedHashMap;
import java.util.Map;

public class MessageAnalysisCache {
    private final long ttlMillis;
    private final Map<String, CachedEntry> cache;

    public MessageAnalysisCache(final int maxSize, long ttlMillis) {
        this.ttlMillis = ttlMillis;
        this.cache = new LinkedHashMap<String, CachedEntry>(maxSize + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, CachedEntry> eldest) {
                return this.size() > maxSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DetectionResult get(String key) {
        Map<String, CachedEntry> map = this.cache;
        synchronized (map) {
            CachedEntry entry = this.cache.get(key);
            if (entry != null && !entry.isExpired()) {
                return entry.result;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, DetectionResult result) {
        Map<String, CachedEntry> map = this.cache;
        synchronized (map) {
            this.cache.put(key, new CachedEntry(result, System.currentTimeMillis() + this.ttlMillis));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, CachedEntry> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    private static class CachedEntry {
        final DetectionResult result;
        final long expiryTime;

        CachedEntry(DetectionResult result, long expiryTime) {
            this.result = result;
            this.expiryTime = expiryTime;
        }

        boolean isExpired() {
            return System.currentTimeMillis() > this.expiryTime;
        }
    }
}

