/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.detector.language;

import com.github.kd_gaming1.packcore.scamshield.detector.pattern.AhoCorasickMatcher;
import java.util.List;

public class LanguagePattern {
    private List<String> phrases;
    private double weight;
    private String context;
    private List<String> examples;
    private transient AhoCorasickMatcher matcher;

    public List<String> getPhrases() {
        return this.phrases;
    }

    public double getWeight() {
        return this.weight;
    }

    public String getContext() {
        return this.context;
    }

    public List<String> getExamples() {
        return this.examples;
    }

    public boolean matches(String message) {
        this.ensureMatcherBuilt();
        return !this.matcher.findMatches(message).isEmpty();
    }

    public int countMatches(String message) {
        this.ensureMatcherBuilt();
        return this.matcher.findMatches(message).size();
    }

    private void ensureMatcherBuilt() {
        if (this.matcher == null) {
            this.matcher = new AhoCorasickMatcher();
            if (this.phrases != null) {
                for (String phrase : this.phrases) {
                    this.matcher.addPattern(phrase);
                }
            }
        }
    }
}

