/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.detector.language;

import com.github.kd_gaming1.packcore.scamshield.detector.language.LanguagePattern;
import java.util.ArrayList;
import java.util.List;

public class TacticDefinition {
    private String description;
    private int baseScore;
    private int combinationBonus;
    private List<LanguagePattern> patterns;

    public String getDescription() {
        return this.description;
    }

    public int getBaseScore() {
        return this.baseScore;
    }

    public int getCombinationBonus() {
        return this.combinationBonus;
    }

    public List<LanguagePattern> getPatterns() {
        return this.patterns;
    }

    public int analyze(String message) {
        int score;
        int matchingPatterns = 0;
        double totalWeight = 0.0;
        ArrayList<String> matchedPhrases = new ArrayList<String>();
        for (LanguagePattern pattern : this.patterns) {
            int matches = pattern.countMatches(message);
            if (matches <= 0) continue;
            ++matchingPatterns;
            totalWeight += pattern.getWeight();
            matchedPhrases.addAll(pattern.getPhrases());
        }
        if (matchingPatterns == 0) {
            return 0;
        }
        double lengthPenalty = this.calculateLengthPenalty(message.length(), matchingPatterns);
        if (matchingPatterns == 1) {
            score = (int)((double)this.baseScore * totalWeight * lengthPenalty);
            return Math.max(0, score);
        }
        score = this.baseScore;
        score += (matchingPatterns - 1) * this.combinationBonus;
        double avgWeight = totalWeight / (double)matchingPatterns;
        score = (int)((double)score * avgWeight * lengthPenalty);
        return Math.max(0, score);
    }

    private double calculateLengthPenalty(int messageLength, int tacticCount) {
        if (messageLength < 20) {
            return tacticCount >= 2 ? 1.5 : 1.0;
        }
        if (messageLength < 50) {
            return 1.0;
        }
        if (messageLength < 100) {
            return 0.9;
        }
        return tacticCount <= 2 ? 0.6 : 0.8;
    }
}

