/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.storage;

import com.github.kd_gaming1.packcore.scamshield.storage.DetectedScam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DetectionStats {
    private final int totalDetections;
    private final Map<String, Integer> categoryCounts;
    private final int uniqueSenders;
    private final long oldestTimestamp;
    private final long newestTimestamp;

    public DetectionStats(List<DetectedScam> detections) {
        this.totalDetections = detections.size();
        this.categoryCounts = new HashMap<String, Integer>();
        HashMap<String, Boolean> uniqueSenderMap = new HashMap<String, Boolean>();
        long oldest = Long.MAX_VALUE;
        long newest = Long.MIN_VALUE;
        for (DetectedScam detection : detections) {
            String category = detection.category();
            this.categoryCounts.merge(category, 1, Integer::sum);
            if (detection.sender() != null) {
                uniqueSenderMap.put(detection.sender(), true);
            }
            if (detection.timestamp() < oldest) {
                oldest = detection.timestamp();
            }
            if (detection.timestamp() <= newest) continue;
            newest = detection.timestamp();
        }
        this.uniqueSenders = uniqueSenderMap.size();
        this.oldestTimestamp = oldest == Long.MAX_VALUE ? 0L : oldest;
        this.newestTimestamp = newest == Long.MIN_VALUE ? 0L : newest;
    }

    public int getTotalDetections() {
        return this.totalDetections;
    }

    public Map<String, Integer> getCategoryCounts() {
        return this.categoryCounts;
    }

    public int getUniqueSenders() {
        return this.uniqueSenders;
    }

    public long getOldestTimestamp() {
        return this.oldestTimestamp;
    }

    public long getNewestTimestamp() {
        return this.newestTimestamp;
    }
}

