/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.tracker;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.scamshield.conversation.ConversationStage;
import com.github.kd_gaming1.packcore.scamshield.conversation.SequencePatternDetector;
import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class UserSuspicionTracker {
    private static final UserSuspicionTracker INSTANCE = new UserSuspicionTracker();
    public final Map<String, EnhancedConversationHistory> conversations = new ConcurrentHashMap<String, EnhancedConversationHistory>();
    private final ScheduledExecutorService cleanupExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "ScamShield-Cleanup");
        t.setDaemon(true);
        return t;
    });

    private UserSuspicionTracker() {
        this.cleanupExecutor.scheduleWithFixedDelay(this::cleanupOldConversations, 5L, 5L, TimeUnit.MINUTES);
    }

    public static UserSuspicionTracker getInstance() {
        return INSTANCE;
    }

    public int recordAndAnalyze(String sender, String message, int singleMessageScore, DetectionResult result) {
        if (sender == null || sender.isEmpty()) {
            return 0;
        }
        String senderKey = sender.toLowerCase();
        EnhancedConversationHistory history = this.conversations.computeIfAbsent(senderKey, k -> new EnhancedConversationHistory(sender));
        HashSet<String> currentTactics = new HashSet<String>(result.getTriggeredScamTypes());
        MessageRecord record = new MessageRecord(message, singleMessageScore, System.currentTimeMillis(), result, currentTactics);
        history.addMessage(record);
        return history.analyzeProgression();
    }

    private void cleanupOldConversations() {
        long cutoff = System.currentTimeMillis() - (long)PackCoreConfig.scamShieldConversationTimeoutMinutes * 60000L;
        this.conversations.entrySet().removeIf(entry -> ((EnhancedConversationHistory)entry.getValue()).getLastMessageTime() < cutoff);
    }

    public void shutdown() {
        this.cleanupExecutor.shutdown();
        try {
            if (!this.cleanupExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.cleanupExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.cleanupExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static class EnhancedConversationHistory {
        private final String sender;
        private final List<MessageRecord> messages = Collections.synchronizedList(new ArrayList());
        private volatile long lastMessageTime = 0L;
        private volatile ConversationStage currentStage = ConversationStage.INITIAL;
        private final List<String> tacticSequence = Collections.synchronizedList(new ArrayList());

        public EnhancedConversationHistory(String sender) {
            this.sender = sender;
        }

        public synchronized void addMessage(MessageRecord record) {
            this.messages.add(record);
            this.lastMessageTime = record.timestamp;
            for (String tactic : record.detectedTactics) {
                if (!this.tacticSequence.isEmpty() && this.tacticSequence.getLast().equals(tactic)) continue;
                this.tacticSequence.add(tactic);
            }
            this.updateConversationStage(record);
            while (this.messages.size() > PackCoreConfig.scamShieldMaxMessagesPerUser) {
                this.messages.remove(0);
            }
            while (this.tacticSequence.size() > 20) {
                this.tacticSequence.remove(0);
            }
        }

        private void updateConversationStage(MessageRecord record) {
            Set<String> tactics = record.detectedTactics;
            if (tactics.contains("credential_fishing") || tactics.contains("coop_command") || tactics.stream().anyMatch(t -> t.contains("credential"))) {
                this.currentStage = ConversationStage.EXPLOITATION;
            } else if (this.currentStage == ConversationStage.EXPLOITATION && (tactics.contains("urgency") || tactics.contains("scarcity"))) {
                this.currentStage = ConversationStage.PRESSURE;
            } else if (tactics.contains("discord_mention") || tactics.contains("visit_command") || tactics.contains("verification_request")) {
                if (this.currentStage.getLevel() < ConversationStage.TRANSITION.getLevel()) {
                    this.currentStage = ConversationStage.TRANSITION;
                }
            } else if ((tactics.contains("free_promise") || tactics.contains("quitting_claim") || tactics.contains("authority")) && this.currentStage.getLevel() < ConversationStage.SETUP.getLevel()) {
                this.currentStage = ConversationStage.SETUP;
            }
        }

        public synchronized int analyzeProgression() {
            if (this.messages.size() < 2) {
                return 0;
            }
            int bonus = 0;
            bonus += this.detectEscalation();
            bonus += this.detectContextShift();
            bonus += this.detectTacticStacking();
            bonus += this.detectSequencePatterns();
            bonus += this.applyStageMultiplier(bonus);
            return Math.min(bonus, PackCoreConfig.scamShieldMaxProgressionBonus);
        }

        private int detectEscalation() {
            if (this.messages.size() < 3) {
                return 0;
            }
            int consecutiveIncreases = 0;
            for (int i = 1; i < this.messages.size(); ++i) {
                if (this.messages.get((int)i).score > this.messages.get((int)(i - 1)).score) {
                    if (++consecutiveIncreases < 3) continue;
                    return 25;
                }
                consecutiveIncreases = 0;
            }
            return consecutiveIncreases >= 2 ? 10 : 0;
        }

        private int detectContextShift() {
            if (this.messages.size() < 4) {
                return 0;
            }
            for (int i = 1; i < this.messages.size(); ++i) {
                MessageRecord prev = this.messages.get(i - 1);
                MessageRecord curr = this.messages.get(i);
                if (curr.score - prev.score <= 50) continue;
                return 30;
            }
            int midpoint = this.messages.size() / 2;
            double firstHalfAvg = this.messages.subList(0, midpoint).stream().mapToInt(m -> m.score).average().orElse(0.0);
            double secondHalfAvg = this.messages.subList(midpoint, this.messages.size()).stream().mapToInt(m -> m.score).average().orElse(0.0);
            if (secondHalfAvg > firstHalfAvg * 2.5 && secondHalfAvg > 30.0) {
                return 25;
            }
            return 0;
        }

        private int detectTacticStacking() {
            HashSet<String> allTriggeredTypes = new HashSet<String>();
            for (MessageRecord record : this.messages) {
                if (record.detectedTactics == null) continue;
                allTriggeredTypes.addAll(record.detectedTactics);
            }
            if (allTriggeredTypes.size() >= 4) {
                return 40;
            }
            if (allTriggeredTypes.size() >= 3) {
                return 25;
            }
            if (allTriggeredTypes.size() >= 2) {
                return 15;
            }
            return 0;
        }

        private int detectSequencePatterns() {
            if (this.tacticSequence.size() < 3) {
                return 0;
            }
            List<SequencePatternDetector.DetectedPattern> patterns = SequencePatternDetector.analyzeSequence(this.tacticSequence);
            int totalBonus = 0;
            for (SequencePatternDetector.DetectedPattern pattern : patterns) {
                totalBonus += pattern.getBonus();
                PackCore.LOGGER.warn("[ScamShield] Sequence detected: '{}' from {} (+{})", new Object[]{pattern.getName(), this.sender, pattern.getBonus()});
            }
            return totalBonus;
        }

        private int applyStageMultiplier(int currentBonus) {
            if (this.currentStage == ConversationStage.INITIAL) {
                return 0;
            }
            double multiplier = this.currentStage.getDangerMultiplier();
            int stageBonus = (int)((double)currentBonus * (multiplier - 1.0));
            if (stageBonus > 0 && PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield] Stage multiplier ({}): +{} bonus", (Object)this.currentStage.getDisplayName(), (Object)stageBonus);
            }
            return stageBonus;
        }

        public long getLastMessageTime() {
            return this.lastMessageTime;
        }

        public ConversationStage getCurrentStage() {
            return this.currentStage;
        }

        public List<String> getTacticSequence() {
            return new ArrayList<String>(this.tacticSequence);
        }
    }

    public static class MessageRecord {
        final String message;
        final int score;
        final long timestamp;
        final DetectionResult detectionResult;
        final Set<String> detectedTactics;

        public MessageRecord(String message, int score, long timestamp, DetectionResult detectionResult, Set<String> detectedTactics) {
            this.message = message;
            this.score = score;
            this.timestamp = timestamp;
            this.detectionResult = detectionResult;
            this.detectedTactics = detectedTactics;
        }
    }
}

