/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.scamshield;

import com.github.kd_gaming1.packcore.ui.screen.components.ScreenUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.scamshield.ScamEducationScreen;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class ScamWarningScreen
extends BaseOwoScreen<FlowLayout> {
    private final ScamWarning warning;
    private final Runnable onDismiss;
    private int tickCount = 0;

    public ScamWarningScreen(ScamWarning warning, Runnable onDismiss) {
        this.warning = warning;
        this.onDismiss = onDismiss;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER).surface(Surface.VANILLA_TRANSLUCENT);
        FlowLayout content = this.createScrollableContent();
        rootComponent.child(ScreenUIComponents.createScrollContainer(content));
    }

    private FlowLayout createScrollableContent() {
        FlowLayout content = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content()).gap(16).padding(Insets.of((int)24));
        content.child((Component)this.createWarningHeader());
        content.child((Component)this.createThreatInfoPanel());
        content.child((Component)this.createPlayerInfoSection());
        content.child((Component)this.createDetectedMessageSection());
        content.child((Component)this.createActionButtonRow());
        content.child((Component)this.createProtectionTipsFooter());
        return content;
    }

    private Surface createCardSurface() {
        int borderColor = this.warning.confidenceLevel() >= 90 ? 0xFF4444 : -680437;
        return Surface.flat((int)-15066598).and(Surface.outline((int)borderColor));
    }

    private FlowLayout createWarningHeader() {
        FlowLayout header = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.bottom((int)8));
        header.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0")).color(Color.ofRgb((int)this.warning.getConfidenceColor())).shadow(true));
        header.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Scam Attempt Detected").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)0xFFFFFF)).shadow(true));
        FlowLayout confidenceBadge = this.createConfidenceBadge();
        header.child((Component)confidenceBadge);
        return header;
    }

    private FlowLayout createConfidenceBadge() {
        FlowLayout badge = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(6).surface(Surface.flat((int)-14013910).and(Surface.outline((int)this.warning.getConfidenceColor()))).padding(Insets.of((int)8));
        badge.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Confidence:")).color(Color.ofRgb((int)-5195576)));
        badge.child((Component)Components.label((class_2561)class_2561.method_43470((String)this.warning.getConfidenceText()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)this.warning.getConfidenceColor())));
        badge.child((Component)Components.label((class_2561)class_2561.method_43470((String)("(" + this.warning.confidenceLevel() + "%)"))).color(Color.ofRgb((int)-5195576)));
        return badge;
    }

    private FlowLayout createThreatInfoPanel() {
        ScamType type = this.warning.scamType();
        FlowLayout panel = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(10).surface(Surface.flat((int)-14018022).and(Surface.outline((int)0xFF4444))).padding(Insets.of((int)16));
        FlowLayout typeHeader = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).verticalAlignment(VerticalAlignment.CENTER);
        typeHeader.child((Component)Components.label((class_2561)class_2561.method_43470((String)type.getIcon())).color(Color.ofRgb((int)0xFF6666)));
        typeHeader.child((Component)Components.label((class_2561)class_2561.method_43470((String)type.getDisplayName()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)0xFFAAAA)));
        panel.child((Component)typeHeader);
        panel.child(Components.label((class_2561)class_2561.method_43470((String)type.getThreatDescription())).color(Color.ofRgb((int)0xFFCCCC)).horizontalSizing(Sizing.fill((int)96)));
        FlowLayout guidanceBox = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).surface(Surface.flat((int)-15062502).and(Surface.outline((int)0x44AA44))).padding(Insets.of((int)10)).margins(Insets.top((int)6));
        guidanceBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udca1")).color(Color.ofRgb((int)0x77DD77)));
        guidanceBox.child(Components.label((class_2561)class_2561.method_43470((String)type.getGuidanceText())).color(Color.ofRgb((int)0xAAFFAA)).horizontalSizing(Sizing.fill((int)90)));
        panel.child((Component)guidanceBox);
        return panel;
    }

    private FlowLayout createPlayerInfoSection() {
        FlowLayout section = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).surface(Surface.flat((int)-15066582).and(Surface.outline((int)0x4466AA))).padding(Insets.of((int)14));
        section.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Suspected Player").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)0xAABBFF)));
        FlowLayout playerDisplay = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(10).verticalAlignment(VerticalAlignment.CENTER);
        playerDisplay.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udc64")).color(Color.ofRgb((int)0x6699FF)));
        playerDisplay.child((Component)Components.label((class_2561)class_2561.method_43470((String)this.warning.playerName()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)0xFFFFFF)));
        section.child((Component)playerDisplay);
        section.child(Components.label((class_2561)class_2561.method_43470((String)"\u26a0 Avoid all transactions with this player until you verify their legitimacy.")).color(Color.ofRgb((int)0xFFAA66)).horizontalSizing(Sizing.fill((int)96)));
        return section;
    }

    private FlowLayout createDetectedMessageSection() {
        FlowLayout section = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).surface(Surface.flat((int)-14013926).and(Surface.outline((int)0xAA9944))).padding(Insets.of((int)14));
        section.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Suspicious Message").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)0xFFCC77)));
        String message = this.warning.detectedMessage();
        String displayMessage = message.length() > 200 ? message.substring(0, 197) + "..." : message;
        section.child(Components.label((class_2561)class_2561.method_43470((String)("\"" + displayMessage + "\"")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)))).color(Color.ofRgb((int)0xEEEEEE)).horizontalSizing(Sizing.fill((int)96)));
        return section;
    }

    private FlowLayout createActionButtonRow() {
        FlowLayout buttonRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(10).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.vertical((int)8));
        buttonRow.child((Component)ScreenUIComponents.createButton("\ud83d\udee1 Learn More", btn -> class_310.method_1551().method_1507((class_437)new ScamEducationScreen(null)), 140, 22));
        buttonRow.child((Component)ScreenUIComponents.createButton("\ud83d\udce2 Report", btn -> {
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.field_3944.method_45731("report " + this.warning.playerName() + " Scamming");
            }
            this.dismiss();
        }, 110, 22));
        buttonRow.child((Component)ScreenUIComponents.createButton("\u2713 Got It", btn -> this.dismiss(), 110, 22));
        return buttonRow;
    }

    private FlowLayout createProtectionTipsFooter() {
        String[] tips;
        FlowLayout footer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).surface(Surface.flat((int)-15062502).and(Surface.outline((int)0x44AA44))).padding(Insets.of((int)12)).margins(Insets.top((int)4));
        footer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udee1 Stay Safe").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)0x77DD77)));
        for (String tip : tips = new String[]{"\u2022 Never share your login credentials with anyone", "\u2022 Check Auction House and Bazaar prices before trading to verify fair value", "\u2022 Only use /coopadd with people you know personally", "\u2022 Report suspicious behavior to server staff"}) {
            footer.child((Component)Components.label((class_2561)class_2561.method_43470((String)tip)).color(Color.ofRgb((int)0xAAFFAA)));
        }
        return footer;
    }

    private void dismiss() {
        if (this.onDismiss != null) {
            this.onDismiss.run();
        }
        this.method_25419();
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25422() {
        return true;
    }

    public void method_25419() {
        if (this.onDismiss != null) {
            this.onDismiss.run();
        }
        super.method_25419();
    }

    public void method_25393() {
        super.method_25393();
        ++this.tickCount;
    }

    public record ScamWarning(String playerName, ScamType scamType, String detectedMessage, int confidenceLevel) {
        public String getConfidenceText() {
            if (this.confidenceLevel >= 95) {
                return "Extremely High";
            }
            if (this.confidenceLevel >= 90) {
                return "Very High";
            }
            if (this.confidenceLevel >= 80) {
                return "High";
            }
            if (this.confidenceLevel >= 70) {
                return "Medium";
            }
            if (this.confidenceLevel >= 50) {
                return "Moderate";
            }
            return "Low";
        }

        public int getConfidenceColor() {
            if (this.confidenceLevel >= 90) {
                return 0xFF3333;
            }
            if (this.confidenceLevel >= 70) {
                return 0xFF9933;
            }
            if (this.confidenceLevel >= 50) {
                return 0xFFCC33;
            }
            return -5195576;
        }
    }

    public static enum ScamType {
        PHISHING_LINK("Phishing Link Detected", "\ud83d\udd17", "This player is trying to steal your account credentials.", "Never click suspicious links or enter login info on unfamiliar sites."),
        PRICE_MANIPULATION("Price Manipulation", "\ud83d\udcb0", "This player may be manipulating item values for unfair trades.", "Always verify market prices before making large trades."),
        RANK_SELLING("Rank Selling Scam", "\ud83d\udc51", "This player is likely offering fake ranks or perks.", "Official ranks can only be purchased through legitimate channels."),
        COOP_SCAM("Co-op Access Theft", "\ud83c\udfdd\ufe0f", "This player may steal items or delete your island if given co-op access.", "Only add trusted friends to your island co-op."),
        BORROWING("Borrowing/Loaning Scam", "\ud83e\udd1d", "This player may not return borrowed items.", "Don't loan valuable items to players you don't know well."),
        FALSE_REWARDS("Fake Giveaway/Reward", "\ud83c\udf81", "This player is offering rewards that don't exist.", "Real giveaways don't require you to send items or login elsewhere."),
        CRAFTING("Crafting/Reforging Scam", "\ud83d\udd28", "This player may keep your items without completing the service.", "Only use crafters you personally know and trust. Check their API to verify they have the required recipes unlocked."),
        GENERAL("Suspicious Activity", "\u26a0\ufe0f", "Multiple suspicious patterns detected in this player's messages.", "Exercise caution when interacting with this player.");

        private final String displayName;
        private final String icon;
        private final String threatDescription;
        private final String guidanceText;

        private ScamType(String displayName, String icon, String threatDescription, String guidanceText) {
            this.displayName = displayName;
            this.icon = icon;
            this.threatDescription = threatDescription;
            this.guidanceText = guidanceText;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getThreatDescription() {
            return this.threatDescription;
        }

        public String getGuidanceText() {
            return this.guidanceText;
        }
    }
}

