/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.title;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.modpack.ModpackInfo;
import com.github.kd_gaming1.packcore.notification.UpdateNotifier;
import com.github.kd_gaming1.packcore.ui.help.guide.GuideListScreen;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.ConfigManagerScreen;
import com.github.kd_gaming1.packcore.ui.surface.effects.TextureSurfaces;
import com.github.kd_gaming1.packcore.ui.toast.PackCoreToast;
import com.github.kd_gaming1.packcore.util.update.UpdateResult;
import com.github.kd_gaming1.packcore.util.update.modrinth.UpdateCache;
import com.terraformersmc.modmenu.api.ModMenuApi;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.MarkdownProcessor;
import io.wispforest.lavendermd.compiler.OwoUICompiler;
import io.wispforest.lavendermd.feature.BasicFormattingFeature;
import io.wispforest.lavendermd.feature.BlockQuoteFeature;
import io.wispforest.lavendermd.feature.ColorFeature;
import io.wispforest.lavendermd.feature.ImageFeature;
import io.wispforest.lavendermd.feature.LinkFeature;
import io.wispforest.lavendermd.feature.ListFeature;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextureComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_429;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_526;
import net.minecraft.class_639;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;

public class SBEStyledTitleScreen
extends BaseOwoScreen<FlowLayout> {
    private final class_2960 backgroundTexture = class_2960.method_60655((String)"packcore", (String)"textures/gui/title/main_menu_background.png");
    private static final ModpackInfo info = PackCore.getModpackInfo();
    private static long lastToastTime = 0L;
    private static final long TOAST_COOLDOWN_MS = 300000L;
    private final boolean updateNotificationEnabled = info != null && PackCoreConfig.showUpdateNotificationsOnTitleScreen && PackCoreConfig.enableUpdateNotifications;
    private boolean updateAvailable;
    private String currentVersion;
    private String newVersion;
    private String changelog;
    private String modrinthName;
    private boolean showChangelog = false;
    private FlowLayout mainButtonLayout;
    private FlowLayout changelogLayout;
    private static final MarkdownProcessor<ParentComponent> MARKDOWN_PROCESSOR = new MarkdownProcessor(OwoUICompiler::new, new MarkdownFeature[]{new BasicFormattingFeature(), new ColorFeature(), new LinkFeature(), new ListFeature(), new BlockQuoteFeature(), new ImageFeature()});
    private static final Map<String, ParentComponent> COMPONENT_CACHE = new ConcurrentHashMap<String, ParentComponent>();

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(TextureSurfaces.stretched(this.backgroundTexture, 1920, 1082));
        rootComponent.child((Component)this.createMainButtonAndTitle()).horizontalAlignment(HorizontalAlignment.CENTER);
        rootComponent.child((Component)this.createSocialButtons().positioning(Positioning.relative((int)0, (int)100)));
        rootComponent.child((Component)this.createSeeWhatIsNewButtons().positioning(Positioning.relative((int)100, (int)0)));
        rootComponent.child((Component)this.createModpackButtons().positioning(Positioning.relative((int)100, (int)100)));
        this.changelogLayout = this.createChangelogPanel();
    }

    public void method_25426() {
        long currentTime;
        UpdateResult result = this.checkForUpdates();
        if (result.isSuccess() && result.isUpdateAvailable() && this.updateNotificationEnabled && (currentTime = System.currentTimeMillis()) - lastToastTime > 300000L && UpdateNotifier.shouldShowMainMenuToast(result.getVersionNumber())) {
            PackCoreToast.showUpdateAvailable(this.currentVersion, this.newVersion, this.modrinthName);
            lastToastTime = currentTime;
        }
        if (!result.isSuccess()) {
            PackCore.LOGGER.warn("Update check failed: {}", (Object)result.getErrorMessage());
        }
        super.method_25426();
    }

    private FlowLayout createMainButtonAndTitle() {
        FlowLayout buttonAndTitle = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fixed((int)320), (Sizing)Sizing.fill((int)100)).gap(4).padding(Insets.of((int)4)).margins(Insets.of((int)4, (int)4, (int)4, (int)4));
        TextureComponent title = (TextureComponent)Components.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/title/title.png"), (int)0, (int)0, (int)1476, (int)157, (int)1476, (int)157).margins(Insets.top((int)8)).horizontalSizing(Sizing.fixed((int)312)).verticalSizing(Sizing.fixed((int)34));
        this.mainButtonLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.of((int)8)).margins(Insets.top((int)12));
        ButtonComponent joinHypixel = this.createButton("Join Hypixel", this::joinHypixel);
        ButtonComponent openSingleplayer = this.createButton("SINGLEPLAYER", this::openSingleplayer);
        ButtonComponent openMultiplayer = this.createButton("Multiplayer", this::openMultiplayer);
        ButtonComponent openMods = this.createButton("MODS", this::openMods);
        ButtonComponent openOptions = this.createButton("OPTIONS", this::openOptions);
        this.mainButtonLayout.child((Component)joinHypixel).child((Component)openSingleplayer).child((Component)openMultiplayer).child((Component)openMods).child((Component)openOptions).child((Component)this.createButton("QUIT", button -> class_310.method_1551().method_1592()));
        buttonAndTitle.child((Component)title);
        buttonAndTitle.child((Component)this.mainButtonLayout);
        return buttonAndTitle;
    }

    private ButtonComponent createButton(String text, class_4185.class_4241 action) {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)text).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte"))), arg_0 -> ((class_4185.class_4241)action).onPress(arg_0)).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/blank_button.png"), (int)0, (int)0, (int)200, (int)66)).horizontalSizing(Sizing.fixed((int)200)).verticalSizing(Sizing.fixed((int)22));
    }

    private ButtonComponent createIconButton(String texture, String tooltip, Runnable action) {
        return (ButtonComponent)Components.button((class_2561)class_2561.method_43473(), button -> action.run()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)texture), (int)0, (int)0, (int)22, (int)22)).horizontalSizing(Sizing.fixed((int)22)).verticalSizing(Sizing.fixed((int)22)).tooltip((class_2561)class_2561.method_43470((String)tooltip));
    }

    private FlowLayout createSocialButtons() {
        FlowLayout buttonLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(6).horizontalAlignment(HorizontalAlignment.LEFT).padding(Insets.of((int)4));
        buttonLayout.child((Component)this.createIconButton("textures/gui/menu/discord_icon.png", "Join our Discord server", () -> class_156.method_668().method_670(info.getDiscord()))).child((Component)this.createIconButton("textures/gui/menu/modrinth_icon.png", "Visit the modrinth page", () -> class_156.method_668().method_670(info.getWebsite()))).child((Component)this.createIconButton("textures/gui/menu/github_icon.png", "Report an issue", () -> class_156.method_668().method_670(info.getIssueTracker()))).child((Component)this.createVersionInfo());
        return buttonLayout;
    }

    private FlowLayout createVersionInfo() {
        FlowLayout mainLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(4).horizontalAlignment(HorizontalAlignment.LEFT);
        LabelComponent versionLabel = Components.label((class_2561)class_2561.method_43470((String)("Pack Version: " + this.currentVersion)).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(Color.ofArgb((int)-16777216));
        mainLayout.child((Component)versionLabel);
        if (this.updateAvailable) {
            LabelComponent updateAvailableLabel = Components.label((class_2561)class_2561.method_43470((String)("Update Available: " + this.newVersion)).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(Color.ofArgb((int)-16777216));
            mainLayout.child((Component)updateAvailableLabel);
        }
        return mainLayout;
    }

    private FlowLayout createSeeWhatIsNewButtons() {
        FlowLayout buttonLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(6).horizontalAlignment(HorizontalAlignment.RIGHT).padding(Insets.of((int)4));
        buttonLayout.child((Component)this.createIconButton("textures/gui/menu/update_icon.png", "See what's new", this::toggleChangelog));
        return buttonLayout;
    }

    private FlowLayout createModpackButtons() {
        FlowLayout buttonLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).gap(6).horizontalAlignment(HorizontalAlignment.RIGHT).padding(Insets.of((int)4));
        buttonLayout.child((Component)this.createIconButton("textures/gui/menu/settings_icon.png", "Modpack Settings import/export your config", () -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new ConfigManagerScreen());
        })).child((Component)this.createIconButton("textures/gui/menu/guide_icon.png", "See Guides on how to use the modpack", () -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new GuideListScreen());
        }));
        return buttonLayout;
    }

    private FlowLayout createChangelogPanel() {
        FlowLayout mainLayout = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)65), (Sizing)Sizing.fill((int)75)).gap(4).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.of((int)4)).surface(TextureSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/info_box.png"), 1142, 934)).margins(Insets.of((int)4, (int)4, (int)4, (int)4)).positioning(Positioning.relative((int)50, (int)75));
        FlowLayout changelogInfo = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(2).padding(Insets.of((int)6, (int)0, (int)8, (int)8)).horizontalAlignment(HorizontalAlignment.CENTER);
        String changeLogInfoText = this.currentVersion.equals(this.newVersion) ? "You are up to date! See change log for current version below:" : (SBEStyledTitleScreen.compareVersions(this.currentVersion, this.newVersion) < 0 ? "A new version is available! See what's new below:" : "You are using a newer or unknown version.");
        LabelComponent changelogLabel = Components.label((class_2561)class_2561.method_43470((String)changeLogInfoText).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).shadow(false);
        FlowLayout divider = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.fill((int)8)).surface(TextureSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/divider.png"), 2401, 96));
        changelogInfo.child((Component)changelogLabel);
        changelogInfo.child((Component)divider);
        mainLayout.child((Component)changelogInfo);
        String changelogContent = this.changelog != null ? this.changelog : "No changelog available.";
        ParentComponent markdownComponent = COMPONENT_CACHE.computeIfAbsent(changelogContent, arg_0 -> MARKDOWN_PROCESSOR.process(arg_0));
        markdownComponent.horizontalSizing(Sizing.fill((int)98));
        markdownComponent.padding(Insets.of((int)0, (int)4, (int)4, (int)4));
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)98), (Sizing)Sizing.expand(), (Component)((FlowLayout)markdownComponent));
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scrollContainer.margins(Insets.bottom((int)10));
        mainLayout.child((Component)scrollContainer);
        FlowLayout buttonSection = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER).padding(Insets.of((int)8));
        ButtonComponent helpButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"\ud83d\udcda Open Update Guide"), button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new GuideListScreen((class_437)this));
            this.toggleChangelog();
        }).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)180, (int)60)).horizontalSizing(Sizing.fixed((int)180)).verticalSizing(Sizing.fixed((int)20));
        buttonSection.child((Component)helpButton);
        mainLayout.child((Component)buttonSection);
        return mainLayout;
    }

    private void toggleChangelog() {
        boolean bl = this.showChangelog = !this.showChangelog;
        if (this.showChangelog) {
            this.mainButtonLayout.remove();
            ((FlowLayout)this.uiAdapter.rootComponent).child((Component)this.changelogLayout);
        } else {
            this.changelogLayout.remove();
            FlowLayout buttonAndTitle = (FlowLayout)((FlowLayout)this.uiAdapter.rootComponent).children().getFirst();
            buttonAndTitle.child((Component)this.mainButtonLayout);
        }
    }

    private void joinHypixel(class_4185 button) {
        class_310 client = class_310.method_1551();
        class_642 serverInfo = new class_642("Hypixel", PackCoreConfig.serverAddressForQuickJoinButton, class_642.class_8678.field_45611);
        class_412.method_36877((class_437)this, (class_310)client, (class_639)class_639.method_2950((String)PackCoreConfig.serverAddressForQuickJoinButton), (class_642)serverInfo, (boolean)false, null);
    }

    private void openSingleplayer(class_4185 button) {
        class_310.method_1551().method_1507((class_437)new class_526((class_437)this));
    }

    private void openMultiplayer(class_4185 button) {
        class_310.method_1551().method_1507((class_437)new class_500((class_437)this));
    }

    private void openMods(class_4185 button) {
        class_310 client = class_310.method_1551();
        class_437 current = client.field_1755;
        try {
            class_437 modsScreen = ModMenuApi.createModsScreen((class_437)current);
            client.method_1507(modsScreen);
        }
        catch (Throwable t) {
            PackCore.LOGGER.error("Failed to open Mod Menu screen", t);
            PackCoreToast.showError("Mod Menu Error", "Could not open Mod Menu");
        }
    }

    private void openOptions(class_4185 button) {
        class_310 client = class_310.method_1551();
        client.method_1507((class_437)new class_429((class_437)this, client.field_1690));
    }

    public UpdateResult checkForUpdates() {
        UpdateCache updateManager = PackCore.getUpdateManager();
        ModpackInfo info = PackCore.getModpackInfo();
        if (updateManager == null || info == null) {
            PackCore.LOGGER.error("Update system not initialized properly");
            return UpdateResult.error("Update system not initialized properly");
        }
        if (info.isConfigurationValid()) {
            this.updateAvailable = false;
            this.currentVersion = "";
            this.newVersion = "";
            this.changelog = "";
            this.modrinthName = "";
            PackCore.LOGGER.warn("Skipping update check - configuration not properly set up: {}", (Object)info.getValidationError());
            return UpdateResult.error("Configuration not properly set up: " + info.getValidationError());
        }
        UpdateResult result = updateManager.checkForUpdates(info);
        if (!result.isSuccess()) {
            PackCore.LOGGER.error("Update check failed: {}", (Object)result.getErrorMessage());
            return result;
        }
        this.updateAvailable = result.isUpdateAvailable();
        this.currentVersion = info.getVersion();
        this.newVersion = result.getVersionNumber();
        this.changelog = result.getChangelog();
        result.getModrinthUrl();
        this.modrinthName = info.getName();
        return result;
    }

    public static int compareVersions(String v1, String v2) {
        String[] parts1 = v1.replaceAll("[^0-9.]", "").split("\\.");
        String[] parts2 = v2.replaceAll("[^0-9.]", "").split("\\.");
        int maxLength = Math.max(parts1.length, parts2.length);
        for (int i = 0; i < maxLength; ++i) {
            int p2;
            int p1 = i < parts1.length ? Integer.parseInt(parts1[i]) : 0;
            int n = p2 = i < parts2.length ? Integer.parseInt(parts2[i]) : 0;
            if (p1 == p2) continue;
            return p1 - p2;
        }
        return 0;
    }
}

