/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.wizard.pages;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.config.apply.WizardOptionApplyService;
import com.github.kd_gaming1.packcore.ui.screen.components.WizardUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.title.SBEStyledTitleScreen;
import com.github.kd_gaming1.packcore.ui.screen.wizard.BaseWizardPage;
import com.github.kd_gaming1.packcore.util.wizard.WizardDataStore;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ApplyConfigurationWizard
extends BaseWizardPage {
    private boolean configurationApplied = false;
    private final WizardDataStore dataStore;
    private LabelComponent statusLabel;
    private ButtonComponent applyButton;
    private FlowLayout progressContainer;
    private FlowLayout warningBanner;
    private final Map<String, LabelComponent> stepLabels = new LinkedHashMap<String, LabelComponent>();

    public ApplyConfigurationWizard() {
        super(new BaseWizardPage.WizardPageInfo((class_2561)class_2561.method_43470((String)"Apply Configuration"), 6, 6), class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"));
        this.dataStore = WizardDataStore.getInstance();
    }

    @Override
    protected void buildContent(FlowLayout contentContainer) {
        contentContainer.gap(4);
        contentContainer.child((Component)this.createHeader());
        contentContainer.child((Component)this.createConfigurationSummary());
        this.warningBanner = this.createWarningBanner();
        contentContainer.child((Component)this.warningBanner);
        contentContainer.child((Component)this.createProgressSection());
        contentContainer.child((Component)this.createStatusSection());
        contentContainer.child((Component)this.createActionButtons());
        this.initializeUIState();
    }

    @Override
    protected void buildContentRight(FlowLayout contentContainerRight) {
        contentContainerRight.child((Component)this.createHelpSection());
    }

    private FlowLayout createHeader() {
        return Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).child(Components.label((class_2561)class_2561.method_43470((String)"\u2728 Ready to Apply Your Settings!").method_10862(class_2583.field_24360.method_36139(-18355).method_10982(Boolean.valueOf(true)))).horizontalSizing(Sizing.fill((int)98)).margins(Insets.of((int)2))).child(Components.label((class_2561)class_2561.method_43470((String)"Review your choices below. When you're ready, click 'Apply Settings' to activate everything.").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)))).color(Color.ofRgb((int)-5195576)).horizontalSizing(Sizing.fill((int)98)).margins(Insets.of((int)2)));
    }

    private FlowLayout createConfigurationSummary() {
        FlowLayout summary = WizardUIComponents.createInfoCard("\ud83d\udccb What You've Selected:", null, 553637632, -18355);
        String optimization = this.dataStore.getOptimizationProfile();
        summary.child((Component)WizardUIComponents.createSummaryItem("\ud83d\ude80 Performance Level:", optimization.isEmpty() ? "Default (no changes)" : optimization));
        String tabDesign = this.dataStore.getTabDesign();
        summary.child((Component)WizardUIComponents.createSummaryItem("\ud83d\uddbc Tab Menu Style:", tabDesign.isEmpty() ? "Default (no changes)" : tabDesign));
        String itemBackground = this.dataStore.getItemBackground();
        summary.child((Component)WizardUIComponents.createSummaryItem("\ud83c\udfa8 Item Background Style:", itemBackground.isEmpty() ? "Default (no changes)" : itemBackground));
        List<String> resourcePacks = this.dataStore.getResourcePacksOrdered();
        if (!resourcePacks.isEmpty()) {
            summary.child((Component)WizardUIComponents.createSummaryItem("\ud83d\udce6 Resource Packs (loading order):", ""));
            for (int i = 0; i < resourcePacks.size(); ++i) {
                summary.child((Component)Components.label((class_2561)class_2561.method_43470((String)("  " + (i + 1) + ". " + resourcePacks.get(i)))).color(Color.ofRgb((int)-5195576)).margins(Insets.left((int)16)));
            }
        } else {
            summary.child((Component)WizardUIComponents.createSummaryItem("\ud83d\udce6 Resource Packs:", "None selected"));
        }
        return summary;
    }

    private FlowLayout createWarningBanner() {
        FlowLayout banner = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(4).surface(Surface.flat((int)822053888).and(Surface.outline((int)-23296))).padding(Insets.of((int)8)).margins(Insets.vertical((int)4));
        banner.positioning(Positioning.absolute((int)0, (int)-1000));
        return banner;
    }

    private void showWarningBanner() {
        class_310.method_1551().execute(() -> {
            this.warningBanner.clearChildren();
            this.warningBanner.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 HypixelPlus Requires Special Setup").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)16753920)));
            this.warningBanner.child(Components.label((class_2561)class_2561.method_43470((String)"HypixelPlus needs the JVM argument -Xss4M to work properly. Please add -Xss4M to your launcher's JVM arguments and restart the game.")).color(Color.ofRgb((int)-1)).horizontalSizing(Sizing.fill((int)95)));
            this.warningBanner.positioning(Positioning.layout());
        });
    }

    private void hideWarningBanner() {
        class_310.method_1551().execute(() -> this.warningBanner.positioning(Positioning.absolute((int)0, (int)-1000)));
    }

    private FlowLayout createProgressSection() {
        this.progressContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(3).surface(Surface.flat((int)0x20000000).and(Surface.outline((int)0x40FFFFFF))).padding(Insets.of((int)6));
        this.progressContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2699 Applying Your Settings:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-18355)));
        this.initializeProgressSteps();
        if (!this.dataStore.isConfigurationApplying()) {
            this.progressContainer.positioning(Positioning.absolute((int)0, (int)-1000));
        }
        return this.progressContainer;
    }

    private void initializeProgressSteps() {
        this.stepLabels.clear();
        if (!this.dataStore.getOptimizationProfile().isEmpty()) {
            this.addProgressStep("performance", "Performance Settings");
        }
        if (!this.dataStore.getResourcePacksOrdered().isEmpty()) {
            this.addProgressStep("resourcepacks", "Resource Packs");
        }
        if (!this.dataStore.getTabDesign().isEmpty()) {
            this.addProgressStep("tabdesign", "Tab Menu Style");
        }
        if (!this.dataStore.getItemBackground().isEmpty()) {
            this.addProgressStep("itembackground", "Item Background Style");
        }
        if (!this.dataStore.getAdditionalSettings().isEmpty()) {
            this.addProgressStep("additional", "Extra Settings");
        }
    }

    private void addProgressStep(String key, String name) {
        LabelComponent stepLabel = WizardUIComponents.createProgressStepLabel(name, WizardUIComponents.ProgressStatus.PENDING);
        this.stepLabels.put(key, stepLabel);
        this.progressContainer.child((Component)stepLabel);
    }

    private void updateProgressStep(String stepKey, String status, String errorMessage) {
        class_310.method_1551().execute(() -> {
            LabelComponent stepLabel = this.stepLabels.get(stepKey);
            if (stepLabel != null) {
                String stepName = this.getStepName(stepKey);
                WizardUIComponents.ProgressStatus progressStatus = switch (status) {
                    case "success" -> WizardUIComponents.ProgressStatus.SUCCESS;
                    case "error" -> WizardUIComponents.ProgressStatus.ERROR;
                    case "running" -> WizardUIComponents.ProgressStatus.RUNNING;
                    default -> WizardUIComponents.ProgressStatus.PENDING;
                };
                String displayText = this.getStatusIcon(progressStatus) + " " + stepName;
                if (progressStatus == WizardUIComponents.ProgressStatus.ERROR && errorMessage != null) {
                    displayText = displayText + " - " + errorMessage;
                }
                class_124 color = this.getStatusColor(progressStatus);
                stepLabel.text((class_2561)class_2561.method_43470((String)displayText).method_10862(class_2583.field_24360.method_10977(color)));
            }
        });
    }

    private String getStepName(String key) {
        return switch (key) {
            case "performance" -> "Performance Settings";
            case "resourcepacks" -> "Resource Packs";
            case "tabdesign" -> "Tab Menu Style";
            case "itembackground" -> "Item Background Style";
            case "additional" -> "Extra Settings";
            default -> "Unknown Step";
        };
    }

    private String getStatusIcon(WizardUIComponents.ProgressStatus status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case WizardUIComponents.ProgressStatus.SUCCESS -> "\u2705";
            case WizardUIComponents.ProgressStatus.ERROR -> "\u274c";
            case WizardUIComponents.ProgressStatus.RUNNING -> "\u23f3";
            case WizardUIComponents.ProgressStatus.PENDING -> "\u23f8";
        };
    }

    private class_124 getStatusColor(WizardUIComponents.ProgressStatus status) {
        return switch (status) {
            default -> throw new MatchException(null, null);
            case WizardUIComponents.ProgressStatus.SUCCESS -> class_124.field_1060;
            case WizardUIComponents.ProgressStatus.ERROR -> class_124.field_1061;
            case WizardUIComponents.ProgressStatus.RUNNING -> class_124.field_1054;
            case WizardUIComponents.ProgressStatus.PENDING -> class_124.field_1080;
        };
    }

    private FlowLayout createStatusSection() {
        FlowLayout statusContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).margins(Insets.vertical((int)8));
        this.statusLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udc49 Ready to begin! Click 'Apply Settings' when you're ready.").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)))).color(Color.ofRgb((int)-5195576)).horizontalSizing(Sizing.fill((int)98)).margins(Insets.of((int)2));
        statusContainer.child((Component)this.statusLabel);
        return statusContainer;
    }

    private FlowLayout createActionButtons() {
        FlowLayout buttonContainer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.top((int)16)).positioning(Positioning.relative((int)50, (int)100));
        this.applyButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Apply Settings"), this::onApplyPressed).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)130, (int)66)).horizontalSizing(Sizing.fixed((int)130)).verticalSizing(Sizing.fixed((int)22));
        buttonContainer.child((Component)this.applyButton);
        return buttonContainer;
    }

    private FlowLayout createHelpSection() {
        String[] steps;
        FlowLayout help = WizardUIComponents.createInfoCard("\u2139 What Happens Next?", null, 0x20000000, -18355);
        for (String step : steps = new String[]{"1. Performance settings will be adjusted", "2. Tab menu style will be configured", "3. Item background style will be applied", "4. Resource packs will be enabled in order"}) {
            help.child(Components.label((class_2561)class_2561.method_43470((String)step)).color(Color.ofRgb((int)-1)).horizontalSizing(Sizing.fill((int)95)));
        }
        help.child(Components.label((class_2561)class_2561.method_43470((String)"\ud83d\udca1 Tip: Each step shows a progress indicator. If something fails, you'll see exactly what went wrong!").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)))).color(Color.ofRgb((int)-5195576)).horizontalSizing(Sizing.fill((int)95)).margins(Insets.of((int)6, (int)2, (int)2, (int)2)));
        return help;
    }

    private void initializeUIState() {
        if (this.dataStore.isConfigurationApplying()) {
            this.progressContainer.positioning(Positioning.layout());
            this.updateApplyButtonState(true, "Applying Settings...");
            this.updateStatusLabel("\u23f3 Please wait while we apply your settings...", class_124.field_1054);
            this.updatePrimaryButtonState(false);
        } else if (this.dataStore.isConfigurationApplied()) {
            String result = this.dataStore.getConfigurationResult();
            if ("success".equals(result)) {
                this.onConfigurationApplied();
            } else if ("failed".equals(result)) {
                this.onConfigurationFailed(null, new RuntimeException(this.dataStore.getConfigurationErrorMessage()));
            }
            this.updatePrimaryButtonState(this.dataStore.isConfigurationApplied());
        } else {
            this.updatePrimaryButtonState(false);
        }
    }

    private void onApplyPressed(ButtonComponent button) {
        if (this.dataStore.isConfigurationApplying() || this.dataStore.isConfigurationApplied()) {
            return;
        }
        PackCore.LOGGER.info("Starting configuration application process");
        this.hideWarningBanner();
        this.dataStore.setConfigurationApplying(true);
        this.dataStore.setConfigurationApplied(false);
        this.dataStore.setConfigurationResult("", "");
        this.progressContainer.positioning(Positioning.layout());
        this.updateApplyButtonState(true, "Applying...");
        this.updateStatusLabel("\u23f3 Please wait while we apply your settings. This may take a moment...", class_124.field_1054);
        WizardOptionApplyService.applyAllConfigurationsWithProgress(this::updateProgressStep).whenComplete((result, throwable) -> class_310.method_1551().execute(() -> {
            this.dataStore.setConfigurationApplying(false);
            if (result.overallSuccess() && throwable == null) {
                this.dataStore.setConfigurationApplied(true);
                this.dataStore.setConfigurationResult("success", "");
                this.onConfigurationApplied();
            } else {
                this.dataStore.setConfigurationApplied(false);
                StringBuilder failureMessage = new StringBuilder();
                if (!result.failedSteps().isEmpty()) {
                    for (Map.Entry<String, String> failure : result.failedSteps().entrySet()) {
                        failureMessage.append("\u274c ").append(failure.getKey()).append(":\n   ").append(failure.getValue()).append("\n\n");
                    }
                } else if (throwable != null) {
                    failureMessage.append(throwable.getMessage() != null ? throwable.getMessage() : "An unexpected error occurred");
                }
                this.dataStore.setConfigurationResult("failed", failureMessage.toString());
                this.onConfigurationFailed((WizardOptionApplyService.ConfigurationResult)result, (Throwable)throwable);
            }
        }));
    }

    private void updateApplyButtonState(boolean isApplying, String message) {
        if (this.applyButton != null) {
            this.applyButton.method_25355((class_2561)class_2561.method_43470((String)message));
            this.applyButton.field_22763 = !isApplying;
        }
    }

    private void updateStatusLabel(String message, class_124 color) {
        if (this.statusLabel != null) {
            this.statusLabel.text((class_2561)class_2561.method_43470((String)message).method_10862(class_2583.field_24360.method_10977(color))).horizontalSizing(Sizing.fill((int)100));
        }
    }

    private void onConfigurationApplied() {
        PackCore.LOGGER.info("Wizard configuration applied successfully!");
        this.updateApplyButtonState(true, "\u2705 All Done!");
        this.updateStatusLabel("\u2705 Success! All your settings have been applied. Click 'Continue' to start playing!", class_124.field_1060);
        this.updatePrimaryButtonState(true);
        this.configurationApplied = true;
        PackCoreConfig.haveShownWelcomeWizard = true;
        PackCoreConfig.write((String)"packcore");
    }

    private void onConfigurationFailed(WizardOptionApplyService.ConfigurationResult result, Throwable throwable) {
        boolean hasResourcePackFailure;
        PackCore.LOGGER.error("Failed to apply wizard configuration", throwable);
        if (result != null && !result.failedSteps().isEmpty() && (hasResourcePackFailure = result.failedSteps().keySet().stream().anyMatch(key -> key.contains("Resource Pack"))) && this.dataStore.getResourcePacksOrdered().stream().anyMatch(pack -> pack.equalsIgnoreCase("HypixelPlus"))) {
            this.showWarningBanner();
        }
        this.updateApplyButtonState(false, "\ud83d\udd04 Retry Settings");
        this.updateStatusLabel("\u26a0 Some settings couldn't be applied. See details above. Click 'Retry Settings' or 'Finish' to continue.", class_124.field_1061);
        this.updatePrimaryButtonState(true);
        this.dataStore.setConfigurationApplied(false);
        this.dataStore.setConfigurationApplying(false);
    }

    private void showSkipConfirmation() {
        FlowLayout dialog = WizardUIComponents.createInfoCard("\u26a0 Skip Configuration?", "You haven't applied your configuration yet. If you skip now, none of your selected settings will be saved.", -1072031206, -680437);
        dialog.positioning(Positioning.relative((int)50, (int)50));
        FlowLayout buttons = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(10).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.top((int)8));
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Go Back"), btn -> this.getRootComponent().removeChild((Component)this.getRootComponent().children().getLast())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).horizontalSizing(Sizing.fixed((int)100)).verticalSizing(Sizing.fixed((int)20)));
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Skip Anyway"), btn -> this.proceedWithSkip()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)120, (int)60)).horizontalSizing(Sizing.fixed((int)120)).verticalSizing(Sizing.fixed((int)20)));
        dialog.child((Component)buttons);
        OverlayContainer overlay = Containers.overlay((Component)dialog);
        overlay.closeOnClick(true);
        overlay.surface(Surface.flat((int)Integer.MIN_VALUE));
        overlay.zIndex(10);
        this.getRootComponent().child((Component)overlay);
    }

    private void proceedWithSkip() {
        PackCoreConfig.haveShownWelcomeWizard = true;
        PackCoreConfig.write((String)"packcore");
        assert (this.field_22787 != null);
        this.field_22787.method_1507((class_437)new SBEStyledTitleScreen());
    }

    private void rebuildMenu() {
        class_310.method_1551().execute(() -> {
            StackLayout root = this.getRootComponent();
            root.clearChildren();
            this.build(root);
        });
    }

    @Override
    protected void onContinuePressed() {
        if (this.dataStore.isConfigurationApplying()) {
            this.updateStatusLabel("\u23f3 Please wait - we're still applying your settings...", class_124.field_1054);
            return;
        }
        if (!this.dataStore.isConfigurationApplied() && !"failed".equals(this.dataStore.getConfigurationResult())) {
            this.updateStatusLabel("\u26a0 Please apply your settings first, or click 'Skip' to configure manually later.", class_124.field_1065);
            return;
        }
        assert (this.field_22787 != null);
        this.field_22787.method_1507((class_437)new SBEStyledTitleScreen());
    }

    @Override
    protected void onSkipPressed() {
        if (this.dataStore.isConfigurationApplying()) {
            this.updateStatusLabel("\u23f3 Please wait - we're still applying your settings. You can skip once it finishes.", class_124.field_1054);
            return;
        }
        if (!this.dataStore.isConfigurationApplied() && !"failed".equals(this.dataStore.getConfigurationResult())) {
            this.showSkipConfirmation();
            return;
        }
        this.proceedWithSkip();
    }

    @Override
    protected boolean isLastPage() {
        return true;
    }

    @Override
    protected boolean shouldShowStatusInfo() {
        return false;
    }

    @Override
    protected boolean shouldShowRightPanel() {
        return true;
    }

    @Override
    protected int getContentColumnWidthPercent() {
        return super.getContentColumnWidthPercent();
    }

    @Override
    protected int getContentColumnWidthRightPercent() {
        return 38;
    }

    @Override
    protected boolean isSkippable() {
        return !this.configurationApplied;
    }
}

