/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.wizard.pages;

import com.github.kd_gaming1.packcore.ui.screen.components.WizardUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.wizard.BaseWizardPage;
import com.github.kd_gaming1.packcore.ui.screen.wizard.WizardNavigator;
import com.github.kd_gaming1.packcore.util.markdown.MarkdownService;
import com.github.kd_gaming1.packcore.util.wizard.WizardDataStore;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class ResourcePacksWizardPage
extends BaseWizardPage {
    private static final String FALLBACK_CONTENT = "# Resource Packs\n\nChoose your Resource Pack! This is the default Resource Pack content.\n\nFind and edit this content in `rundir/packcore/wizard_markdown_content/resource_packs.md`\n";
    private static final List<PackOption> AVAILABLE_PACKS = List.of(new PackOption("HypixelPlus", "\u2b50", "Hypixel Plus", "Clean vanilla-style pack for Hypixel. Updates items and icons for clarity.", true), new PackOption("FurfSkyOverlay", "\ud83c\udfad", "FurfSky Overlay", "Popular choice. Retextures items only, keeping vanilla GUI.", false), new PackOption("FurfSkyFull", "\ud83c\udf1f", "FurfSky Full", "Complete makeover. Items + GUI + menus in unique style.", false), new PackOption("SkyBlockDarkUI", "\ud83c\udf19", "SkyBlock Dark UI", "Sleek dark theme for menus and mod interfaces. Modern aesthetic.", false), new PackOption("SkyBlockDarkmode", "\ud83c\udf11", "SkyBlock Dark mode", "Sleek dark theme for The End island and The Mist", false), new PackOption("", "\ud83d\udcda", "Sophie's Hypixel Enchants", "Custom textures for all Enchantment Books throughout the whole of Skyblock.", false), new PackOption("Defrosted", "\u2744", "Defrosted", "Frosty blue 16x pack. Minimalist look with cool aesthetic.", false), new PackOption("Looshy", "\u2728", "Looshy", "Smooth vanilla-like 16x. Refined textures, fresh and polished.", false));
    private final String markdownContent;
    private final WizardDataStore dataStore;
    private final Set<String> selectedResourcePacks = new LinkedHashSet<String>();
    private FlowLayout rightPanel;

    public ResourcePacksWizardPage() {
        super(new BaseWizardPage.WizardPageInfo((class_2561)class_2561.method_43470((String)"Resource Packs"), 4, 6), class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"));
        MarkdownService markdownService = new MarkdownService();
        this.markdownContent = markdownService.getOrDefault("resource_packs.md", FALLBACK_CONTENT);
        this.dataStore = WizardDataStore.getInstance();
        this.selectedResourcePacks.addAll(this.dataStore.getResourcePacksOrdered());
    }

    @Override
    protected void buildContent(FlowLayout contentContainer) {
        contentContainer.child((Component)WizardUIComponents.createHeader("Choose resource packs for", null));
        contentContainer.child(WizardUIComponents.createMarkdownScroll(this.markdownContent));
    }

    @Override
    protected void buildContentRight(FlowLayout contentContainerRight) {
        this.rightPanel = contentContainerRight;
        this.rightPanel.child((Component)this.createSelectionHeader());
        this.rightPanel.child(this.createPackOptions());
    }

    private FlowLayout createSelectionHeader() {
        int count;
        FlowLayout header = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).margins(Insets.of((int)8, (int)0, (int)8, (int)8));
        header.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\ud83c\udfa8 Resource Packs").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-1)));
        LabelComponent headerTitle = this.selectedResourcePacks.isEmpty() ? (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"Select packs below (optional)")).color(Color.ofRgb((int)-18355)).horizontalSizing(Sizing.fill((int)100)) : (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)("\u2713 " + count + " pack" + ((count = this.selectedResourcePacks.size()) == 1 ? "" : "s") + " selected")).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-15681151)).horizontalSizing(Sizing.fill((int)100));
        header.child((Component)headerTitle);
        if (!this.selectedResourcePacks.isEmpty()) {
            header.child((Component)this.createLoadingOrderPreview());
        }
        return header;
    }

    private FlowLayout createLoadingOrderPreview() {
        FlowLayout orderSection = WizardUIComponents.createInfoCard("\ud83d\udccb Loading Order (Top = Priority)", null, 541757666, -11890462);
        int index = 1;
        for (String packKey : this.selectedResourcePacks) {
            FlowLayout orderItem = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).verticalAlignment(VerticalAlignment.CENTER);
            FlowLayout badge = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fixed((int)20), (Sizing)Sizing.fixed((int)20)).surface(Surface.flat((int)-11890462)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
            badge.child((Component)Components.label((class_2561)class_2561.method_43470((String)String.valueOf(index))).color(Color.ofRgb((int)-1)));
            orderItem.child((Component)badge);
            orderItem.child(Components.label((class_2561)class_2561.method_43470((String)packKey)).color(Color.ofRgb((int)-5195576)).horizontalSizing(Sizing.expand()));
            orderSection.child((Component)orderItem);
            ++index;
        }
        return orderSection;
    }

    private ScrollContainer<FlowLayout> createPackOptions() {
        FlowLayout packsLayout = Containers.verticalFlow((Sizing)Sizing.fill((int)96), (Sizing)Sizing.content()).gap(6);
        for (PackOption pack : AVAILABLE_PACKS) {
            packsLayout.child((Component)this.createPackOption(pack));
        }
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)packsLayout);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scrollContainer.scrollbarThiccness(6);
        scrollContainer.surface(Surface.flat((int)0x40000000).and(Surface.outline((int)0x30FFFFFF)));
        scrollContainer.padding(Insets.of((int)6));
        scrollContainer.margins(Insets.bottom((int)4));
        return scrollContainer;
    }

    private FlowLayout createPackOption(PackOption pack) {
        boolean isSelected = this.selectedResourcePacks.contains(pack.key);
        FlowLayout card = WizardUIComponents.createSelectionCard(isSelected, c -> this.togglePack(pack.key));
        card.cursorStyle(CursorStyle.HAND);
        FlowLayout header = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(8).verticalAlignment(VerticalAlignment.CENTER);
        header.child((Component)Components.label((class_2561)class_2561.method_43470((String)pack.icon)).color(Color.ofRgb((int)-18355)));
        header.child(Components.label((class_2561)class_2561.method_43470((String)pack.title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-1)).horizontalSizing(Sizing.expand()));
        if (pack.requiresJVM) {
            FlowLayout warningBadge = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).surface(Surface.flat((int)-528993009).and(Surface.outline((int)-680437))).padding(Insets.of((int)2));
            warningBadge.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 JVM")).color(Color.ofRgb((int)-680437)));
            header.child((Component)warningBadge);
        }
        card.child((Component)header);
        LabelComponent desc = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)pack.description)).color(Color.ofRgb((int)-5195576)).horizontalSizing(Sizing.fill((int)100));
        card.child((Component)desc);
        if (pack.requiresJVM && isSelected) {
            FlowLayout jvmWarning = WizardUIComponents.createInfoCard("\u26a0 Requires JVM Argument", "Add -Xss4M to launcher settings. Exit wizard, add argument, restart game.", 552967691, -680437);
            jvmWarning.margins(Insets.top((int)6));
            card.child((Component)jvmWarning);
        }
        return card;
    }

    private void togglePack(String packKey) {
        if (this.selectedResourcePacks.contains(packKey)) {
            this.selectedResourcePacks.remove(packKey);
        } else {
            this.selectedResourcePacks.add(packKey);
        }
        this.dataStore.setResourcePacksOrdered(new ArrayList<String>(this.selectedResourcePacks));
        this.rebuildRightPanel();
    }

    private void rebuildRightPanel() {
        this.rightPanel.clearChildren();
        this.rightPanel.child((Component)this.createSelectionHeader());
        this.rightPanel.child(this.createPackOptions());
    }

    @Override
    protected void onContinuePressed() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(WizardNavigator.createWizardPage(5));
    }

    @Override
    protected int getContentColumnWidthPercent() {
        return 55;
    }

    @Override
    protected boolean shouldShowStatusInfo() {
        return false;
    }

    @Override
    protected boolean shouldShowRightPanel() {
        return true;
    }

    private record PackOption(String key, String icon, String title, String description, boolean requiresJVM) {
    }
}

