/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.config.IrisConfig;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrisIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");

    public static boolean setShaderPack(String shaderPackPrefix) {
        try {
            String foundPack = IrisIntegration.findShaderPack(shaderPackPrefix);
            if (foundPack == null) {
                LOGGER.warn("No shader pack found starting with: {}", (Object)shaderPackPrefix);
                return false;
            }
            IrisConfig irisConfig = Iris.getIrisConfig();
            irisConfig.setShadersEnabled(true);
            irisConfig.setShaderPackName(foundPack);
            LOGGER.info("Setting shader pack in method setShaderPack to: {}", (Object)foundPack);
            irisConfig.save();
            Thread.sleep(200L);
            CompletableFuture reloadFuture = new CompletableFuture();
            class_310.method_1551().execute(() -> {
                try {
                    LOGGER.info("Reloading Iris with shader pack: {}", (Object)foundPack);
                    Iris.reload();
                    reloadFuture.complete(true);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to reload Iris", (Throwable)e);
                    reloadFuture.complete(false);
                }
            });
            return (Boolean)reloadFuture.get(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.error("Failed to set shader pack", (Throwable)e);
            return false;
        }
    }

    public static boolean disableShaders() {
        try {
            return IrisIntegration.configureAndReload(null, false);
        }
        catch (Exception e) {
            LOGGER.error("Failed to disable shaders", (Throwable)e);
            return false;
        }
    }

    private static boolean configureAndReload(String shaderPack, boolean enabled) throws Exception {
        IrisConfig irisConfig = Iris.getIrisConfig();
        irisConfig.setShadersEnabled(enabled);
        if (enabled && shaderPack != null) {
            irisConfig.setShaderPackName(shaderPack);
            LOGGER.info("Setting shader pack in method configureAndReload to: {}", (Object)shaderPack);
        } else {
            LOGGER.info("Disabling Iris shaders");
        }
        irisConfig.save();
        Thread.sleep(enabled ? 200L : 100L);
        CompletableFuture reloadFuture = new CompletableFuture();
        class_310.method_1551().execute(() -> {
            try {
                LOGGER.info("Reloading Iris with shaders {}", (Object)(enabled ? "enabled" : "disabled"));
                Iris.reload();
                reloadFuture.complete(true);
            }
            catch (Exception e) {
                LOGGER.error("Failed to reload Iris", (Throwable)e);
                reloadFuture.complete(false);
            }
        });
        return (Boolean)reloadFuture.get(30L, TimeUnit.SECONDS);
    }

    private static String findShaderPack(String prefix) {
        String string;
        block9: {
            Path shaderPacksDir = class_310.method_1551().field_1697.toPath().resolve("shaderpacks");
            if (!Files.exists(shaderPacksDir, new LinkOption[0])) {
                LOGGER.warn("Shaderpacks directory does not exist: {}", (Object)shaderPacksDir);
                return null;
            }
            Stream<Path> paths = Files.list(shaderPacksDir);
            try {
                string = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).filter(name -> name.toLowerCase().startsWith(prefix.toLowerCase()) && name.toLowerCase().endsWith(".zip")).findFirst().orElse(null);
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to search for shader pack with prefix: {}", (Object)prefix, (Object)e);
                    return null;
                }
            }
            paths.close();
        }
        return string;
    }
}

