/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.help.guide.util;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.gui.help.guide.util.GuideInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;

public class GuideUtil {
    private static final String GUIDES_FOLDER = "packcore/guides";
    private static final ConcurrentHashMap<String, GuideInfo> GUIDE_CACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> CONTENT_CACHE = new ConcurrentHashMap();

    public static Path getGuidesDirectory() {
        return FabricLoader.getInstance().getGameDir().resolve(GUIDES_FOLDER);
    }

    public static List<GuideInfo> loadAvailableGuides() {
        ArrayList<GuideInfo> guides = new ArrayList<GuideInfo>();
        Path guidesDir = GuideUtil.getGuidesDirectory();
        if (!Files.exists(guidesDir, new LinkOption[0])) {
            PackCore.LOGGER.warn("Guides directory doesn't exist: {}", (Object)guidesDir);
            return guides;
        }
        try (Stream<Path> files = Files.list(guidesDir);){
            files.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".md")).forEach(path -> {
                try {
                    GuideInfo guide = GuideUtil.loadGuideInfo(path);
                    if (guide != null) {
                        guides.add(guide);
                        GUIDE_CACHE.put(path.getFileName().toString(), guide);
                    }
                }
                catch (IOException e) {
                    PackCore.LOGGER.error("Failed to load guide: {}", path, (Object)e);
                }
            });
        }
        catch (IOException e) {
            PackCore.LOGGER.error("Failed to read guides directory: {}", (Object)guidesDir, (Object)e);
        }
        return guides;
    }

    private static GuideInfo loadGuideInfo(Path filePath) throws IOException {
        List<String> lines = Files.readAllLines(filePath);
        if (lines.isEmpty()) {
            return null;
        }
        String title = lines.get(0).replaceFirst("^#+\\s*", "").trim();
        if (title.isEmpty()) {
            title = filePath.getFileName().toString().replace(".md", "");
        }
        StringBuilder previewBuilder = new StringBuilder();
        int currentLine = 0;
        int maxLines = 3;
        for (int i = 1; i < lines.size() && currentLine < maxLines; ++i) {
            String cleanLine;
            String line = lines.get(i).trim();
            if (line.isEmpty() || line.startsWith("#") || (cleanLine = line.replaceAll("^[>\\-\\*\\+]\\s*", "").replaceAll("\\*\\*(.*?)\\*\\*", "$1").replaceAll("\\*(.*?)\\*", "$1").replaceAll("\\[([^\\]]+)\\]\\([^\\)]+\\)", "$1").replaceAll("`([^`]+)`", "$1")).isEmpty()) continue;
            if (currentLine > 0) {
                previewBuilder.append(" ");
            }
            previewBuilder.append(cleanLine);
            ++currentLine;
        }
        Object preview = previewBuilder.toString();
        if (((String)preview).length() > 200) {
            int lastSpace = ((String)preview).lastIndexOf(32, 197);
            preview = lastSpace > 150 ? ((String)preview).substring(0, lastSpace) + "..." : ((String)preview).substring(0, 197) + "...";
        } else if (currentLine == maxLines && !((String)preview).endsWith("...")) {
            preview = (String)preview + "...";
        }
        return new GuideInfo(title, (String)preview, filePath);
    }

    public static String loadGuideContent(GuideInfo guide) {
        String fileName = guide.getFilePath().getFileName().toString();
        String cachedContent = CONTENT_CACHE.get(fileName);
        if (cachedContent != null) {
            guide.setFullContent(cachedContent);
            return cachedContent;
        }
        try {
            String content = Files.readString(guide.getFilePath());
            CONTENT_CACHE.put(fileName, content);
            guide.setFullContent(content);
            return content;
        }
        catch (IOException e) {
            PackCore.LOGGER.error("Failed to load guide content: {}", (Object)guide.getFilePath(), (Object)e);
            return "# Error\n\nFailed to load guide content.";
        }
    }

    public static void clearCache() {
        GUIDE_CACHE.clear();
        CONTENT_CACHE.clear();
    }

    public static void ensureGuidesDirectory() {
        Path guidesDir = GuideUtil.getGuidesDirectory();
        try {
            Files.createDirectories(guidesDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            PackCore.LOGGER.error("Failed to create guides directory: {}", (Object)guidesDir, (Object)e);
        }
    }
}

