/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util;

import com.github.kd_gaming1.packcore.util.ConfigFileOperations;
import com.github.kd_gaming1.packcore.util.ConfigFileUtils;
import com.github.kd_gaming1.packcore.util.copysystem.UnzipFiles;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfigApplicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoConfigApplicator.class);

    public static boolean applyBestMatchingConfig(Path gameDir) {
        LOGGER.info("Starting automatic config application...");
        Dimension screenSize = AutoConfigApplicator.detectResolution();
        if (screenSize == null) {
            LOGGER.error("Failed to detect screen resolution");
            return false;
        }
        LOGGER.info("Detected screen resolution: {}x{}", (Object)screenSize.width, (Object)screenSize.height);
        List<ConfigFileUtils.ConfigFile> allConfigs = ConfigFileUtils.getAllConfigs();
        if (allConfigs.isEmpty()) {
            LOGGER.warn("No configs available for automatic application");
            return false;
        }
        LOGGER.info("Found {} available configs", (Object)allConfigs.size());
        ConfigFileUtils.ConfigFile bestMatch = AutoConfigApplicator.findBestMatch(screenSize, allConfigs);
        if (bestMatch == null) {
            LOGGER.error("Could not find suitable config to apply");
            return false;
        }
        LOGGER.info("Selected config: {} ({})", (Object)bestMatch.getDisplayName(), (Object)(bestMatch.isOfficial() ? "Official" : "Custom"));
        return AutoConfigApplicator.applyConfigDirect(bestMatch, gameDir);
    }

    private static boolean applyConfigDirect(ConfigFileUtils.ConfigFile config, Path gameDir) {
        LOGGER.info("Applying config: {}", (Object)config.getDisplayName());
        try {
            Path backup = ConfigFileOperations.createBackup(gameDir);
            if (backup != null) {
                LOGGER.info("Backup created at: {}", (Object)backup);
                ConfigFileOperations.cleanOldBackups(gameDir, 5);
            }
            UnzipFiles unzipper = new UnzipFiles();
            unzipper.unzip(config.getPath().toString(), gameDir.toString(), (bytesProcessed, totalBytes, percentage) -> {
                if (percentage % 25 == 0) {
                    LOGGER.info("Extraction progress: {}%", (Object)percentage);
                }
            });
            ConfigFileUtils.saveCurrentConfig(config.getMetadata());
            LOGGER.info("Config applied successfully: {}", (Object)config.getDisplayName());
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to apply config", (Throwable)e);
            return false;
        }
    }

    private static Dimension detectResolution() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            LOGGER.debug("Screen dimensions: {}x{}", (Object)screenSize.width, (Object)screenSize.height);
            return screenSize;
        }
        catch (Exception e) {
            LOGGER.error("Failed to detect resolution", (Throwable)e);
            return null;
        }
    }

    private static ConfigFileUtils.ConfigFile findBestMatch(Dimension detectedResolution, List<ConfigFileUtils.ConfigFile> configs) {
        LOGGER.info("Available configs:");
        for (ConfigFileUtils.ConfigFile config : configs) {
            String targetRes = config.getMetadata().getTargetResolution();
            Dimension configRes = AutoConfigApplicator.parseResolution(targetRes);
            double distance = AutoConfigApplicator.calculateDistance(detectedResolution, configRes);
            LOGGER.info("  - {} | Resolution: {} | Official: {} | Distance: {}", new Object[]{config.getDisplayName(), targetRes, config.isOfficial(), configRes != null ? String.format("%.0f", distance) : "N/A"});
        }
        ConfigFileUtils.ConfigFile selected = configs.stream().min(AutoConfigApplicator.createConfigComparator(detectedResolution)).orElse(null);
        if (selected != null) {
            Dimension selectedRes = AutoConfigApplicator.parseResolution(selected.getMetadata().getTargetResolution());
            double distance = AutoConfigApplicator.calculateDistance(detectedResolution, selectedRes);
            LOGGER.info("Best match selected: {} (distance: {:.0f} pixels)", (Object)selected.getDisplayName(), (Object)distance);
        }
        return selected;
    }

    private static Comparator<ConfigFileUtils.ConfigFile> createConfigComparator(Dimension targetResolution) {
        return Comparator.comparing(c -> !c.isOfficial()).thenComparing(c -> {
            Dimension configRes = AutoConfigApplicator.parseResolution(c.getMetadata().getTargetResolution());
            return AutoConfigApplicator.calculateDistance(targetResolution, configRes);
        }).thenComparing(c -> c.getDisplayName());
    }

    private static double calculateDistance(Dimension target, Dimension candidate) {
        if (target == null || candidate == null) {
            return Double.MAX_VALUE;
        }
        double widthDiff = target.width - candidate.width;
        double heightDiff = target.height - candidate.height;
        return Math.sqrt(widthDiff * widthDiff + heightDiff * heightDiff);
    }

    private static Dimension parseResolution(String resolution) {
        if (resolution == null || resolution.trim().isEmpty()) {
            return null;
        }
        String cleaned = resolution.trim().toLowerCase();
        if ((cleaned = cleaned.replace('\u00d7', 'x')).matches("\\d+\\s*x\\s*\\d+")) {
            String[] parts = cleaned.split("x");
            try {
                int width = Integer.parseInt(parts[0].trim());
                int height = Integer.parseInt(parts[1].trim());
                return new Dimension(width, height);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Could not parse resolution numbers: {}", (Object)resolution);
                return null;
            }
        }
        LOGGER.warn("Resolution format not recognized: {}", (Object)resolution);
        return null;
    }
}

