/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util;

import com.github.kd_gaming1.packcore.util.BackupManager;
import com.github.kd_gaming1.packcore.util.ConfigFileUtils;
import com.github.kd_gaming1.packcore.util.ConfigMetadata;
import com.github.kd_gaming1.packcore.util.copysystem.UnzipFiles;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigApplicationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigApplicationManager.class);
    private static final String PENDING_CONFIG_FILE = "packcore_pending_config.json";
    private static final Gson GSON = new Gson();

    public static void scheduleConfigApplication(ConfigFileUtils.ConfigFile config) {
        try {
            Path gameDir = FabricLoader.getInstance().getGameDir();
            Path pendingFile = gameDir.resolve(PENDING_CONFIG_FILE);
            PendingConfig pending = new PendingConfig(config.getPath().toString(), config.getDisplayName(), config.getMetadata());
            String json = GSON.toJson((Object)pending);
            Files.writeString(pendingFile, (CharSequence)json, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            LOGGER.info("Scheduled config for application: {}", (Object)config.getDisplayName());
            class_310.method_1551().method_1592();
        }
        catch (IOException e) {
            LOGGER.error("Failed to schedule config application", (Throwable)e);
            throw new RuntimeException("Failed to prepare config application", e);
        }
    }

    public static boolean checkAndApplyPendingConfig(Path gameDir) {
        Path pendingFile = gameDir.resolve(PENDING_CONFIG_FILE);
        if (!Files.exists(pendingFile, new LinkOption[0])) {
            return false;
        }
        try {
            boolean success;
            String json = Files.readString(pendingFile, StandardCharsets.UTF_8);
            PendingConfig pending = (PendingConfig)GSON.fromJson(json, PendingConfig.class);
            if (pending == null || pending.configPath == null) {
                LOGGER.warn("Invalid pending config file");
                Files.deleteIfExists(pendingFile);
                return false;
            }
            LOGGER.info("Found pending config: {}", (Object)pending.configName);
            Path backup = BackupManager.createAutoBackup();
            if (backup != null) {
                LOGGER.info("Created auto-backup before applying config: {}", (Object)backup);
            }
            if (success = ConfigApplicationManager.applyConfig(Path.of(pending.configPath, new String[0]), gameDir)) {
                ConfigFileUtils.saveCurrentConfig(pending.metadata);
                LOGGER.info("Successfully applied config: {}", (Object)pending.configName);
            } else {
                LOGGER.error("Failed to apply config: {}", (Object)pending.configName);
            }
            Files.deleteIfExists(pendingFile);
            return success;
        }
        catch (Exception e) {
            LOGGER.error("Error processing pending config", (Throwable)e);
            try {
                Files.deleteIfExists(pendingFile);
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to clean up pending file", (Throwable)ex);
            }
            return false;
        }
    }

    private static boolean applyConfig(Path configZipPath, Path gameDir) {
        try {
            if (!Files.exists(configZipPath, new LinkOption[0])) {
                LOGGER.error("Config file not found: {}", (Object)configZipPath);
                return false;
            }
            UnzipFiles unzipper = new UnzipFiles();
            unzipper.unzip(configZipPath.toString(), gameDir.toString(), (bytesProcessed, totalBytes, percentage) -> {
                if (percentage % 25 == 0) {
                    LOGGER.info("Extraction progress: {}%", (Object)percentage);
                }
            });
            LOGGER.info("Config extraction completed");
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to extract config", (Throwable)e);
            return false;
        }
    }

    private static class PendingConfig {
        String configPath;
        String configName;
        ConfigMetadata metadata;

        PendingConfig(String configPath, String configName, ConfigMetadata metadata) {
            this.configPath = configPath;
            this.configName = configName;
            this.metadata = metadata;
        }
    }
}

