/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.copysystem;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnzipFiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnzipFiles.class);

    public void unzip(String zipFilePath, String destDir, ProgressCallback progressCallback) throws IOException {
        long totalSize = this.calculateTotalSize(zipFilePath);
        long processedBytes = 0L;
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        byte[] buffer = new byte[8192];
        try (FileInputStream fis = new FileInputStream(zipFilePath);
             ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                String fileName = ze.getName();
                File newFile = new File(destDir + File.separator + fileName);
                if (ze.isDirectory()) {
                    LOGGER.info("Creating directory {}", (Object)newFile.getAbsolutePath());
                    newFile.mkdirs();
                } else {
                    LOGGER.info("Unzipping to {}", (Object)newFile.getAbsolutePath());
                    File parent = newFile.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                            processedBytes += (long)len;
                            if (progressCallback == null || totalSize <= 0L) continue;
                            int percentage = (int)(processedBytes * 100L / totalSize);
                            progressCallback.onProgress(processedBytes, totalSize, percentage);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to unzip files", (Throwable)e);
            throw e;
        }
    }

    private long calculateTotalSize(String zipFilePath) {
        long totalSize = 0L;
        try (FileInputStream fis = new FileInputStream(zipFilePath);
             ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.getSize() > 0L) {
                    totalSize += ze.getSize();
                }
                zis.closeEntry();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to calculate total size", (Throwable)e);
        }
        return totalSize;
    }

    public static interface ProgressCallback {
        public void onProgress(long var1, long var3, int var5);
    }
}

