/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.command.scamshield;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.scamshield.debug.ScamShieldDebugger;
import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

public class ScamShieldTestCommands {
    public static LiteralArgumentBuilder<FabricClientCommandSource> registerTest() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"test").then(ClientCommandManager.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ScamShieldTestCommands::testMessage));
    }

    public static LiteralArgumentBuilder<FabricClientCommandSource> registerDebug() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"debug").executes(ScamShieldTestCommands::runDebugTests);
    }

    private static int testMessage(CommandContext<FabricClientCommandSource> context) {
        String message = StringArgumentType.getString(context, (String)"message");
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7e[ScamShield] \u00a77Testing message..."));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        try {
            DetectionResult result = PackCore.getScamDetector().analyze(message, "TestUser");
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77Message: \u00a7f" + message)));
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            if (result.isTriggered()) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7l\u26a0 SCAM DETECTED"));
                source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77Category: \u00a7e" + result.getPrimaryCategory().getDisplayName())));
            } else {
                source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7a\u2713 No scam detected"));
            }
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77Score Breakdown:"));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  Total: \u00a7f" + result.getTotalScore())));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  ScamType: \u00a7f" + result.getScamTypeScore())));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  Progression: \u00a7f" + result.getProgressionScore())));
            if (!result.getScamTypeContributions().isEmpty()) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)""));
                source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77Detected Patterns:"));
                result.getScamTypeContributions().forEach((type, score) -> source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  \u2022 \u00a7e" + type + "\u00a77: \u00a7f" + score + " points"))));
            }
            source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
            return 1;
        }
        catch (Exception e) {
            source.sendError((class_2561)class_2561.method_43470((String)("\u00a7c[ScamShield] Error: " + e.getMessage())));
            PackCore.LOGGER.error("[ScamShield] Test command error", (Throwable)e);
            return 0;
        }
    }

    private static int runDebugTests(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7e[ScamShield] \u00a77Running debug test suite..."));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77This will take about 30 seconds..."));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77Check console/logs for detailed output!"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)""));
        new Thread(() -> {
            try {
                ScamShieldDebugger debugger = new ScamShieldDebugger();
                ScamShieldDebugger.DebugReport report = debugger.runTests();
                source.sendFeedback((class_2561)class_2561.method_43470((String)""));
                source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
                source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7e[Debug Test Summary]"));
                source.sendFeedback((class_2561)class_2561.method_43470((String)""));
                source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77Total Tests: \u00a7f" + report.getTotalTests())));
                source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7a\u2713 Passed: \u00a7f" + report.getPassedTests())));
                source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7c\u2717 Failed: \u00a7f" + report.getFailedTests())));
                source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77Pass Rate: \u00a7f" + report.getPassRate() + "%")));
                if (report.getPassRate() >= 90) {
                    source.sendFeedback((class_2561)class_2561.method_43470((String)""));
                    source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7a\u00a7l\u2713 EXCELLENT PERFORMANCE!"));
                } else if (report.getPassRate() >= 75) {
                    source.sendFeedback((class_2561)class_2561.method_43470((String)""));
                    source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7e\u26a0 GOOD - Some improvements needed"));
                } else {
                    source.sendFeedback((class_2561)class_2561.method_43470((String)""));
                    source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7c\u2717 NEEDS IMPROVEMENT"));
                    source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77Check console for failed tests"));
                }
                source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
            }
            catch (Exception e) {
                source.sendError((class_2561)class_2561.method_43470((String)("\u00a7c[ScamShield] Debug test failed: " + e.getMessage())));
                PackCore.LOGGER.error("[ScamShield] Debug test error", (Throwable)e);
            }
        }, "ScamShield-Debug").start();
        return 1;
    }
}

