/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.notification;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.modpack.ModpackInfo;
import com.github.kd_gaming1.packcore.ui.toast.PackCoreToast;
import com.github.kd_gaming1.packcore.util.update.UpdateResult;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class UpdateNotifier {
    private static final long MAIN_MENU_TOAST_COOLDOWN_MS = 300000L;
    private static final Set<String> shownVersionsThisSession = new HashSet<String>();
    private static long lastMainMenuToastTime = 0L;
    private static boolean hasShownInGameNotificationThisSession = false;

    public static boolean shouldShowMainMenuToast(String newVersion) {
        long now = System.currentTimeMillis();
        return !shownVersionsThisSession.contains(newVersion) && now - lastMainMenuToastTime > 300000L;
    }

    public static void showMainMenuToast(String currentVersion, String newVersion, String modpackName) {
        PackCoreToast.showUpdateAvailable(currentVersion, newVersion, modpackName);
        shownVersionsThisSession.add(newVersion);
        lastMainMenuToastTime = System.currentTimeMillis();
    }

    private static void checkAndShowInGameNotification() {
        ModpackInfo info = PackCore.getModpackInfo();
        if (info == null || !PackCoreConfig.enableUpdateNotifications) {
            return;
        }
        UpdateResult result = PackCore.getUpdateManager().checkForUpdates(info);
        if (result.isSuccess() && result.isUpdateAvailable()) {
            UpdateNotifier.showInGameChatMessage(info.getVersion(), result.getVersionNumber(), result.getModrinthUrl(), info.getName());
            hasShownInGameNotificationThisSession = true;
        }
    }

    private static void showInGameChatMessage(String currentVersion, String newVersion, String modrinthUrl, String modpackName) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        try {
            URI uri = URI.create(modrinthUrl);
            class_2558.class_10608 clickEvent = new class_2558.class_10608(uri);
            class_5250 updateMessage = class_2561.method_43470((String)("[" + modpackName + "] ")).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)"Update available! ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(currentVersion + " \u2192 " + newVersion + " ")).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"[Click to view]").method_27695(new class_124[]{class_124.field_1075, class_124.field_1073}).method_27694(arg_0 -> UpdateNotifier.lambda$showInGameChatMessage$1((class_2558)clickEvent, arg_0)));
            player.method_7353((class_2561)updateMessage, false);
        }
        catch (IllegalArgumentException e) {
            PackCore.LOGGER.error("Invalid Modrinth URL: {}", (Object)modrinthUrl, (Object)e);
        }
    }

    private static /* synthetic */ class_2583 lambda$showInGameChatMessage$1(class_2558 clickEvent, class_2583 style) {
        return style.method_10958(clickEvent);
    }

    static {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (!hasShownInGameNotificationThisSession) {
                UpdateNotifier.checkAndShowInGameNotification();
            }
        });
    }
}

