/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.detector;

import com.github.kd_gaming1.packcore.scamshield.conversation.ConversationStage;
import com.github.kd_gaming1.packcore.scamshield.detector.ConfidenceLevel;
import com.github.kd_gaming1.packcore.scamshield.detector.ScamCategory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DetectionResult {
    public static final DetectionResult SAFE = new DetectionResult(false, 0, 0, Map.of(), List.of(), "", "", ConfidenceLevel.LOW);
    private final boolean triggered;
    private final int scamTypeScore;
    private final int progressionScore;
    private final Map<String, Integer> scamTypeContributions;
    private final List<String> triggeredScamTypes;
    private final String originalMessage;
    private final String sender;
    private final long timestamp;
    private final ConfidenceLevel confidenceLevel;

    private DetectionResult(boolean triggered, int scamTypeScore, int progressionScore, Map<String, Integer> scamTypeContributions, List<String> triggeredScamTypes, String originalMessage, String sender, ConfidenceLevel confidenceLevel) {
        this.triggered = triggered;
        this.scamTypeScore = scamTypeScore;
        this.progressionScore = progressionScore;
        this.scamTypeContributions = Map.copyOf(scamTypeContributions);
        this.triggeredScamTypes = List.copyOf(triggeredScamTypes);
        this.originalMessage = originalMessage == null ? "" : originalMessage;
        this.sender = sender == null ? "" : sender;
        this.timestamp = System.currentTimeMillis();
        this.confidenceLevel = confidenceLevel;
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public int getTotalScore() {
        return this.scamTypeScore + this.progressionScore;
    }

    public int getScamTypeScore() {
        return this.scamTypeScore;
    }

    public int getProgressionScore() {
        return this.progressionScore;
    }

    public Map<String, Integer> getScamTypeContributions() {
        return this.scamTypeContributions;
    }

    public List<String> getTriggeredScamTypes() {
        return this.triggeredScamTypes;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    public String getSender() {
        return this.sender;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ConfidenceLevel getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public ScamCategory getPrimaryCategory() {
        return this.triggeredScamTypes.isEmpty() ? ScamCategory.CUSTOM : ScamCategory.fromScamTypeId(this.triggeredScamTypes.getFirst());
    }

    public String toString() {
        return String.format("DetectionResult{triggered=%s, total=%d (type=%d, prog=%d), confidence=%s, types=%s, sender=%s}", new Object[]{this.triggered, this.getTotalScore(), this.scamTypeScore, this.progressionScore, this.confidenceLevel, this.triggeredScamTypes, this.sender});
    }

    public static class Builder {
        private int scamTypeScore = 0;
        private int progressionScore = 0;
        private final Map<String, Integer> scamTypeContributions = new HashMap<String, Integer>();
        private final List<String> triggeredScamTypes = new ArrayList<String>();
        private final String originalMessage;
        private final String sender;
        private final int threshold;
        private ConversationStage stage = ConversationStage.INITIAL;

        public Builder(String originalMessage, String sender, int threshold) {
            this.originalMessage = originalMessage;
            this.sender = sender;
            this.threshold = threshold;
        }

        public void addScamTypeContribution(String scamTypeId, int score) {
            this.scamTypeScore += score;
            this.scamTypeContributions.merge(scamTypeId, score, Integer::sum);
            if (score > 0 && !this.triggeredScamTypes.contains(scamTypeId)) {
                this.triggeredScamTypes.add(scamTypeId);
            }
        }

        public void addProgressionBonus(int score) {
            this.progressionScore += score;
        }

        public void setConversationStage(ConversationStage stage) {
            this.stage = stage;
        }

        public DetectionResult build() {
            int adjustedThreshold = this.threshold;
            switch (this.stage) {
                case EXPLOITATION: {
                    adjustedThreshold = (int)((double)this.threshold * 0.7);
                    break;
                }
                case PRESSURE: {
                    adjustedThreshold = (int)((double)this.threshold * 0.6);
                    break;
                }
                case TRANSITION: {
                    adjustedThreshold = (int)((double)this.threshold * 0.85);
                }
            }
            int totalScore = this.scamTypeScore + this.progressionScore;
            boolean triggered = totalScore >= adjustedThreshold;
            ConfidenceLevel confidence = ConfidenceLevel.fromScore(totalScore);
            return new DetectionResult(triggered, this.scamTypeScore, this.progressionScore, this.scamTypeContributions, this.triggeredScamTypes, this.originalMessage, this.sender, confidence);
        }

        public void applyMultiplier(double multiplier) {
            if (multiplier >= 1.0) {
                return;
            }
            this.scamTypeScore = (int)((double)this.scamTypeScore * multiplier);
            for (Map.Entry<String, Integer> entry : this.scamTypeContributions.entrySet()) {
                int originalScore = entry.getValue();
                int adjustedScore = (int)((double)originalScore * multiplier);
                this.scamTypeContributions.put(entry.getKey(), adjustedScore);
            }
        }

        public int getCurrentTotalScore() {
            return this.scamTypeScore + this.progressionScore;
        }

        public String getOriginalMessage() {
            return this.originalMessage;
        }

        public String getSender() {
            return this.sender;
        }
    }
}

