/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.detector.language;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.scamshield.detector.language.TacticDefinition;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class LanguageDatabase {
    private static final Gson GSON = new GsonBuilder().create();
    private static final String LANGUAGE_FILE = "phishing-language.json";
    private final Path languageFile;
    private Map<String, TacticDefinition> tactics = new HashMap<String, TacticDefinition>();
    private String version = "unknown";

    public LanguageDatabase() {
        Path gameDir = FabricLoader.getInstance().getGameDir();
        this.languageFile = gameDir.resolve("packcore/scamshield/phishing-language.json");
        this.initializeFile();
        this.load();
    }

    private void initializeFile() {
        try {
            Files.createDirectories(this.languageFile.getParent(), new FileAttribute[0]);
            if (Files.exists(this.languageFile, new LinkOption[0])) {
                PackCore.LOGGER.info("[ScamShield] Language database found at: {}", (Object)this.languageFile);
                return;
            }
            String resourcePath = "/assets/packcore/scamshield/phishing-language.json";
            try (InputStream in = this.getClass().getResourceAsStream(resourcePath);){
                if (in == null) {
                    PackCore.LOGGER.error("[ScamShield] Default language file not found in resources: {}", (Object)resourcePath);
                    this.createEmptyFile();
                    return;
                }
                Files.copy(in, this.languageFile, new CopyOption[0]);
                PackCore.LOGGER.info("[ScamShield] Created language database from defaults");
            }
        }
        catch (IOException e) {
            PackCore.LOGGER.error("[ScamShield] Failed to initialize language file", (Throwable)e);
            this.createEmptyFile();
        }
    }

    private void createEmptyFile() {
        try {
            String emptyJson = "{\"version\":\"1.0.0\",\"tactics\":{}}";
            Files.writeString(this.languageFile, (CharSequence)emptyJson, StandardCharsets.UTF_8, new OpenOption[0]);
            PackCore.LOGGER.warn("[ScamShield] Created empty language database");
        }
        catch (IOException e) {
            PackCore.LOGGER.error("[ScamShield] Failed to create empty language file", (Throwable)e);
        }
    }

    public void load() {
        try {
            if (!Files.exists(this.languageFile, new LinkOption[0])) {
                PackCore.LOGGER.warn("[ScamShield] Language file not found: {}", (Object)this.languageFile);
                return;
            }
            String json = Files.readString(this.languageFile, StandardCharsets.UTF_8);
            JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
            if (root.has("version")) {
                this.version = root.get("version").getAsString();
            }
            if (root.has("tactics")) {
                JsonObject tacticsObj = root.getAsJsonObject("tactics");
                this.tactics.clear();
                for (String tacticId : tacticsObj.keySet()) {
                    TacticDefinition tactic = (TacticDefinition)GSON.fromJson(tacticsObj.get(tacticId), TacticDefinition.class);
                    this.tactics.put(tacticId, tactic);
                }
            }
            PackCore.LOGGER.info("[ScamShield] Loaded language database v{} with {} tactics", (Object)this.version, (Object)this.tactics.size());
        }
        catch (IOException e) {
            PackCore.LOGGER.error("[ScamShield] Failed to load language database", (Throwable)e);
        }
        catch (Exception e) {
            PackCore.LOGGER.error("[ScamShield] Failed to parse language database", (Throwable)e);
        }
    }

    public Map<String, TacticDefinition> getTactics() {
        return new HashMap<String, TacticDefinition>(this.tactics);
    }

    public TacticDefinition getTactic(String tacticId) {
        return this.tactics.get(tacticId);
    }

    public void reload() {
        PackCore.LOGGER.info("[ScamShield] Reloading language database...");
        this.load();
    }

    public String getVersion() {
        return this.version;
    }

    public Path getLanguageFile() {
        return this.languageFile;
    }
}

