/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.detector.types;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.scamshield.context.ConversationContext;
import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import com.github.kd_gaming1.packcore.scamshield.detector.pattern.AhoCorasickMatcher;
import com.github.kd_gaming1.packcore.scamshield.detector.types.ScamType;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class JsonBasedScamType
implements ScamType {
    private static final Gson GSON = new GsonBuilder().create();
    private final String configFileName;
    private boolean enabled = true;
    private String id;
    private String displayName;
    private String description;
    private int baseScore;
    private Map<String, PatternGroup> patternGroups = new HashMap<String, PatternGroup>();
    private List<CombinationRule> combinationRules = new ArrayList<CombinationRule>();

    public JsonBasedScamType(String configFileName) {
        this.configFileName = configFileName;
        this.loadFromFile();
    }

    private void loadFromFile() {
        try {
            Path configFile = this.getConfigPath();
            this.ensureFileExists(configFile);
            String json = Files.readString(configFile, StandardCharsets.UTF_8);
            this.parseConfig(json);
            if (this.id == null || this.id.isEmpty()) {
                throw new IllegalStateException("ScamType config missing required 'id' field");
            }
            if (this.displayName == null || this.displayName.isEmpty()) {
                throw new IllegalStateException("ScamType config missing required 'name' field");
            }
            PackCore.LOGGER.info("[ScamShield] Loaded JSON-based ScamType: {} ({} pattern groups)", (Object)this.displayName, (Object)this.patternGroups.size());
        }
        catch (IOException e) {
            PackCore.LOGGER.error("[ScamShield] Failed to read ScamType config file: {}", (Object)this.configFileName, (Object)e);
            this.initializeAsSafeDefaults();
        }
        catch (JsonSyntaxException e) {
            PackCore.LOGGER.error("[ScamShield] Invalid JSON in ScamType config: {}", (Object)this.configFileName, (Object)e);
            this.initializeAsSafeDefaults();
        }
        catch (Exception e) {
            PackCore.LOGGER.error("[ScamShield] Unexpected error loading ScamType: {}", (Object)this.configFileName, (Object)e);
            this.initializeAsSafeDefaults();
        }
    }

    private void initializeAsSafeDefaults() {
        this.id = "disabled_" + this.configFileName;
        this.displayName = "Disabled: " + this.configFileName;
        this.description = "Failed to load configuration";
        this.baseScore = 0;
        this.enabled = false;
        this.patternGroups = new HashMap<String, PatternGroup>();
        this.combinationRules = new ArrayList<CombinationRule>();
        PackCore.LOGGER.warn("[ScamShield] ScamType '{}' has been disabled due to configuration errors", (Object)this.configFileName);
    }

    private void parseConfig(String json) {
        JsonObject root = (JsonObject)GSON.fromJson(json, JsonObject.class);
        this.id = root.get("id").getAsString();
        this.displayName = root.get("name").getAsString();
        this.description = root.has("description") ? root.get("description").getAsString() : "";
        int n = this.baseScore = root.has("base_score") ? root.get("base_score").getAsInt() : 0;
        if (root.has("pattern_groups")) {
            JsonObject groups = root.getAsJsonObject("pattern_groups");
            for (String groupName : groups.keySet()) {
                PatternGroup group = (PatternGroup)GSON.fromJson(groups.get(groupName), PatternGroup.class);
                this.patternGroups.put(groupName, group);
            }
        }
        if (root.has("combination_rules")) {
            CombinationRule[] rules = (CombinationRule[])GSON.fromJson(root.get("combination_rules"), CombinationRule[].class);
            this.combinationRules = new ArrayList<CombinationRule>(Arrays.asList(rules));
        }
    }

    private void ensureFileExists(Path configFile) throws IOException {
        if (Files.exists(configFile, new LinkOption[0])) {
            return;
        }
        Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
        String resourcePath = "/assets/packcore/scamshield/" + this.configFileName;
        try (InputStream in = this.getClass().getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new IOException("Resource not found: " + resourcePath);
            }
            Files.copy(in, configFile, new CopyOption[0]);
            PackCore.LOGGER.info("[ScamShield] Created config file from defaults: {}", (Object)this.configFileName);
        }
    }

    private Path getConfigPath() {
        return FabricLoader.getInstance().getGameDir().resolve("packcore/scamshield/" + this.configFileName);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void analyze(String message, String rawMessage, String sender, ConversationContext context, DetectionResult.Builder result) {
        if (!this.enabled || this.patternGroups.isEmpty()) {
            return;
        }
        HashSet<String> matchedGroups = new HashSet<String>();
        HashMap<String, Integer> groupMatchCounts = new HashMap<String, Integer>();
        int totalScore = 0;
        for (Map.Entry<String, PatternGroup> entry : this.patternGroups.entrySet()) {
            String groupName = entry.getKey();
            PatternGroup group = entry.getValue();
            int matchCount = group.countMatches(message);
            if (matchCount <= 0) continue;
            matchedGroups.add(groupName);
            groupMatchCounts.put(groupName, matchCount);
            int groupScore = group.score;
            if (matchCount > 1) {
                double multiplier = 1.0 + (1.0 - Math.pow(0.5, matchCount - 1));
                multiplier = Math.min(multiplier, 2.0);
                groupScore = (int)((double)groupScore * multiplier);
            }
            totalScore += groupScore;
            if (!PackCoreConfig.enableScamShieldDebugging) continue;
            PackCore.LOGGER.info("[ScamShield]   Pattern group '{}' matched {} times: +{} points", new Object[]{groupName, matchCount, groupScore});
        }
        if (matchedGroups.isEmpty()) {
            return;
        }
        for (CombinationRule rule : this.combinationRules) {
            if (!matchedGroups.containsAll(rule.requires)) continue;
            totalScore += rule.bonus;
            if (!PackCoreConfig.enableScamShieldDebugging) continue;
            PackCore.LOGGER.info("[ScamShield]   Combination rule triggered: {} = +{} bonus", rule.requires, (Object)rule.bonus);
        }
        if (totalScore > 0) {
            double contextMultiplier = context.getSensitivityMultiplier(this.getId());
            totalScore = (int)((double)totalScore * contextMultiplier);
            result.addScamTypeContribution(this.getId(), totalScore);
            if (PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield] {} detected: +{} points (groups: {}, context: {}x)", new Object[]{this.displayName, totalScore, matchedGroups, contextMultiplier});
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void reload() {
        PackCore.LOGGER.info("[ScamShield] Reloading {}", (Object)this.displayName);
        this.loadFromFile();
    }

    private static class PatternGroup {
        private String description;
        private int score;
        private List<String> phrases;
        private transient AhoCorasickMatcher matcher;

        private PatternGroup() {
        }

        public boolean matches(String message) {
            this.ensureMatcherBuilt();
            return !this.matcher.findMatches(message).isEmpty();
        }

        public int countMatches(String message) {
            this.ensureMatcherBuilt();
            return this.matcher.findMatches(message).size();
        }

        private void ensureMatcherBuilt() {
            if (this.matcher == null) {
                this.matcher = new AhoCorasickMatcher();
                if (this.phrases != null) {
                    for (String phrase : this.phrases) {
                        this.matcher.addPattern(phrase);
                    }
                }
            }
        }
    }

    private static class CombinationRule {
        private String description;
        private List<String> requires;
        private int bonus;

        private CombinationRule() {
        }
    }
}

