/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.configmanager;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.imports.ConfigImportService;
import com.github.kd_gaming1.packcore.config.model.ConfigMetadata;
import com.github.kd_gaming1.packcore.ui.screen.base.BasePackCoreScreen;
import com.github.kd_gaming1.packcore.ui.screen.components.ScreenUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.ConfigManagerScreen;
import com.github.kd_gaming1.packcore.ui.screen.configmanager.ExportConfigScreen;
import com.github.kd_gaming1.packcore.ui.theme.UITheme;
import com.github.kd_gaming1.packcore.util.task.ProgressListener;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ImportConfigScreen
extends BasePackCoreScreen {
    private Path selectedFile = null;
    private ConfigMetadata previewMetadata = null;
    private LabelComponent selectedFileLabel;
    private LabelComponent statusLabel;
    private FlowLayout previewContainer;
    private CheckboxComponent applyImmediatelyCheckbox;
    private ButtonComponent importButton;
    private FlowLayout progressPanel;

    public ImportConfigScreen() {
        super((class_437)new ConfigManagerScreen());
    }

    @Override
    protected Component createTitleLabel() {
        return Components.label((class_2561)class_2561.method_43470((String)("Import Configuration - " + PackCore.getModpackInfo().getName())).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(UITheme.color(-1));
    }

    @Override
    protected FlowLayout createMainContent() {
        FlowLayout mainContent = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(8);
        mainContent.child((Component)this.createSidebar());
        mainContent.child((Component)this.createPreviewPanel());
        return mainContent;
    }

    private FlowLayout createSidebar() {
        FlowLayout sidebar = ScreenUIComponents.createSidebar(35);
        FlowLayout scrollContent = Containers.verticalFlow((Sizing)Sizing.fill((int)96), (Sizing)Sizing.content()).gap(8);
        scrollContent.child(this.createInstructions());
        scrollContent.child((Component)this.createFileSelectionSection());
        scrollContent.child((Component)this.createStatusSection());
        scrollContent.child((Component)this.createImportOptionsSection());
        sidebar.child(ScreenUIComponents.createScrollContainer(scrollContent));
        return sidebar;
    }

    private Component createInstructions() {
        FlowLayout container = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).padding(Insets.of((int)8));
        container.child(Components.label((class_2561)class_2561.method_43470((String)"Select a configuration ZIP file to import into your modpack.")).color(UITheme.color(-1)).horizontalSizing(Sizing.fill((int)100)));
        return container;
    }

    private FlowLayout createFileSelectionSection() {
        FlowLayout section = ScreenUIComponents.createSection("Select File", 0);
        section.horizontalAlignment(HorizontalAlignment.CENTER);
        section.child((Component)ScreenUIComponents.createButton("Browse Files", btn -> this.selectConfigFile(), 120, 21));
        this.selectedFileLabel = Components.label((class_2561)class_2561.method_43470((String)"No file selected")).color(UITheme.color(-5195576));
        section.child((Component)this.selectedFileLabel);
        return section;
    }

    private FlowLayout createStatusSection() {
        FlowLayout section = ScreenUIComponents.createSection("Status", 0);
        this.statusLabel = Components.label((class_2561)class_2561.method_43470((String)"Ready")).color(UITheme.color(-5195576));
        section.child((Component)this.statusLabel);
        this.progressPanel = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        section.child((Component)this.progressPanel);
        return section;
    }

    private FlowLayout createImportOptionsSection() {
        FlowLayout section = ScreenUIComponents.createSection("Import Options", 0);
        this.applyImmediatelyCheckbox = Components.checkbox((class_2561)class_2561.method_43470((String)"Apply Immediately"));
        this.applyImmediatelyCheckbox.checked(false);
        this.applyImmediatelyCheckbox.tooltip((class_2561)class_2561.method_43470((String)"If checked, the game will restart and apply this configuration"));
        section.child((Component)this.applyImmediatelyCheckbox);
        this.importButton = ScreenUIComponents.createButton("Import", btn -> this.handleImportClick());
        this.importButton.active(false);
        section.child((Component)this.importButton);
        return section;
    }

    private FlowLayout createPreviewPanel() {
        this.previewContainer = ScreenUIComponents.createInfoPanel(65);
        this.showEmptyPreview();
        return this.previewContainer;
    }

    private void showEmptyPreview() {
        this.previewContainer.clearChildren();
        this.previewContainer.horizontalAlignment(HorizontalAlignment.CENTER);
        this.previewContainer.verticalAlignment(VerticalAlignment.CENTER);
        this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Configuration Preview").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Select a file to preview its contents")).color(UITheme.color(-5195576)));
    }

    private void selectConfigFile() {
        this.updateStatus("Opening file browser...", -5195576);
        ((CompletableFuture)ConfigImportService.selectConfigFile().thenAccept(path -> class_310.method_1551().execute(() -> {
            if (path != null) {
                this.selectedFile = path;
                this.selectedFileLabel.text((class_2561)class_2561.method_43470((String)path.getFileName().toString()));
                this.selectedFileLabel.color(UITheme.color(-1));
                this.previewFile();
            } else {
                this.updateStatus("Selection cancelled", -5195576);
            }
        }))).exceptionally(throwable -> {
            class_310.method_1551().execute(() -> this.updateStatus("Error: " + throwable.getMessage(), -1096636));
            return null;
        });
    }

    private void previewFile() {
        if (this.selectedFile == null) {
            return;
        }
        this.updateStatus("Reading metadata...", -5195576);
        this.previewMetadata = ConfigImportService.previewConfig(this.selectedFile);
        if (this.previewMetadata != null) {
            this.showPreview();
            this.importButton.active(true);
            this.updateStatus("Ready to import", -15681151);
        } else {
            this.updateStatus("Could not read file", -1096636);
            this.importButton.active(false);
        }
    }

    private void showPreview() {
        if (this.previewMetadata == null) {
            return;
        }
        this.previewContainer.clearChildren();
        this.previewContainer.horizontalAlignment(HorizontalAlignment.LEFT);
        this.previewContainer.verticalAlignment(VerticalAlignment.TOP);
        this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)this.previewMetadata.getName()).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        FlowLayout infoBox = ScreenUIComponents.createInfoBox();
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Version:", this.previewMetadata.getVersion()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Author:", this.previewMetadata.getAuthor()));
        infoBox.child((Component)ScreenUIComponents.createInfoRow("Resolution:", this.previewMetadata.getTargetResolution()));
        if (this.previewMetadata.getCreatedDate() != null) {
            infoBox.child((Component)ScreenUIComponents.createInfoRow("Created:", ScreenUIComponents.formatTimestamp(this.previewMetadata.getCreatedDate())));
        }
        this.previewContainer.child((Component)infoBox);
        if (this.previewMetadata.getDescription() != null && !this.previewMetadata.getDescription().isEmpty()) {
            this.previewContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Description:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
            this.previewContainer.child(Components.label((class_2561)class_2561.method_43470((String)this.previewMetadata.getDescription())).color(UITheme.color(-1)).sizing(Sizing.fill((int)95), Sizing.content()));
        }
        if (this.previewMetadata.getMods() != null && !this.previewMetadata.getMods().isEmpty()) {
            this.previewContainer.child(this.createModsList(this.previewMetadata.getMods()));
        }
    }

    private Component createModsList(List<String> mods) {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        container.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Included Mods:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-18355)));
        FlowLayout modsContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(2).surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811))).padding(Insets.of((int)8));
        int displayCount = Math.min(10, mods.size());
        for (int i = 0; i < displayCount; ++i) {
            modsContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("\u2022 " + mods.get(i)))).color(UITheme.color(-1)));
        }
        if (mods.size() > displayCount) {
            modsContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)("... and " + (mods.size() - displayCount) + " more"))).color(UITheme.color(-5195576)));
        }
        container.child(ScreenUIComponents.createScrollContainer(modsContainer).sizing(Sizing.fill((int)100), Sizing.fixed((int)150)));
        return container;
    }

    private void handleImportClick() {
        if (this.selectedFile == null || this.previewMetadata == null) {
            return;
        }
        if (this.applyImmediatelyCheckbox.method_20372()) {
            this.showRestartWarningDialog();
        } else {
            this.performImport();
        }
    }

    private void showRestartWarningDialog() {
        FlowLayout dialog = ScreenUIComponents.createWarningDialog("Restart Required", null, 500);
        dialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Configuration: " + this.previewMetadata.getName())).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-1)));
        FlowLayout warningBox = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4).surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-680437))).padding(Insets.of((int)12));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"This will:")).color(UITheme.color(-1)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Import and apply the configuration")).color(UITheme.color(-5195576)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Restart Minecraft automatically")).color(UITheme.color(-5195576)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Replace your current configuration")).color(UITheme.color(-5195576)));
        dialog.child((Component)warningBox);
        dialog.child((Component)ScreenUIComponents.createErrorCard("BACKUP RECOMMENDATION", "Please export your current configuration before proceeding. If you do not export a backup, you will lose your current configuration and cannot revert!"));
        dialog.child((Component)ScreenUIComponents.createButtonRow(ScreenUIComponents.createButton("Export First", btn -> {
            this.closeTopOverlay();
            class_310.method_1551().method_1507((class_437)new ExportConfigScreen());
        }), ScreenUIComponents.createButton("Import & Restart", btn -> {
            this.closeTopOverlay();
            this.performImport();
        }), ScreenUIComponents.createButton("Cancel", btn -> this.closeTopOverlay())));
        this.showOverlay(dialog, false);
    }

    private void performImport() {
        if (this.selectedFile == null || this.previewMetadata == null) {
            return;
        }
        this.importButton.active(false);
        this.progressPanel.clearChildren();
        final boolean applyImmediately = this.applyImmediatelyCheckbox.method_20372();
        ConfigImportService.importConfig(this.selectedFile, applyImmediately, new ProgressListener(){

            @Override
            public void onProgress(String message, int percentage) {
                class_310.method_1551().execute(() -> {
                    ImportConfigScreen.this.progressPanel.clearChildren();
                    ImportConfigScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)(message + " (" + percentage + "%)"))).color(UITheme.color(-18355)));
                });
            }

            @Override
            public void onComplete(boolean success, String message) {
                class_310.method_1551().execute(() -> {
                    ImportConfigScreen.this.progressPanel.clearChildren();
                    if (success) {
                        ImportConfigScreen.this.updateStatus("Success!", -15681151);
                        if (applyImmediately) {
                            ImportConfigScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Game will restart to apply configuration...")).color(UITheme.color(-15681151)));
                        } else {
                            ImportConfigScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(-15681151)));
                            ImportConfigScreen.this.importButton.active(true);
                        }
                    } else {
                        ImportConfigScreen.this.updateStatus("Import failed", -1096636);
                        ImportConfigScreen.this.progressPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(-1096636)));
                        ImportConfigScreen.this.importButton.active(true);
                    }
                });
            }
        });
    }

    private void updateStatus(String message, int color) {
        this.statusLabel.text((class_2561)class_2561.method_43470((String)message));
        this.statusLabel.color(UITheme.color(color));
    }
}

