/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.wizard;

import com.github.kd_gaming1.packcore.ui.screen.wizard.pages.ApplyConfigurationWizard;
import com.github.kd_gaming1.packcore.ui.screen.wizard.pages.ItemBackgroundWizardPage;
import com.github.kd_gaming1.packcore.ui.screen.wizard.pages.OptimizationWizardPage;
import com.github.kd_gaming1.packcore.ui.screen.wizard.pages.ResourcePacksWizardPage;
import com.github.kd_gaming1.packcore.ui.screen.wizard.pages.TabDesignWizardPage;
import com.github.kd_gaming1.packcore.ui.screen.wizard.pages.UsefulInfoWizardPage;
import com.github.kd_gaming1.packcore.ui.screen.wizard.pages.WelcomeWizardPage;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class WizardNavigator {
    private static final Map<Integer, PageInfo> PAGES = new LinkedHashMap<Integer, PageInfo>();

    private static void registerPage(int index, String id, class_2561 displayName, PageFactory factory, boolean optional) {
        PAGES.put(index, new PageInfo(id, displayName, factory, optional));
    }

    public static class_437 createWizardPage(int pageNumber) {
        PageInfo info = PAGES.get(pageNumber);
        return info != null ? info.factory().create() : new WelcomeWizardPage();
    }

    public static PageInfo getPageInfo(int pageNumber) {
        return PAGES.get(pageNumber);
    }

    public static int getTotalPages() {
        return PAGES.size();
    }

    public static boolean isPageOptional(int pageNumber) {
        PageInfo info = PAGES.get(pageNumber);
        return info != null && info.optional();
    }

    public static int getNextRequiredPage(int currentPage) {
        for (int i = currentPage + 1; i < PAGES.size(); ++i) {
            PageInfo info = PAGES.get(i);
            if (info == null || info.optional()) continue;
            return i;
        }
        return -1;
    }

    public static Map<Integer, PageInfo> getAllPages() {
        return new LinkedHashMap<Integer, PageInfo>(PAGES);
    }

    static {
        WizardNavigator.registerPage(0, "welcome", (class_2561)class_2561.method_43470((String)"Welcome"), WelcomeWizardPage::new, false);
        WizardNavigator.registerPage(1, "optimization", (class_2561)class_2561.method_43470((String)"Performance Settings"), OptimizationWizardPage::new, false);
        WizardNavigator.registerPage(2, "tab_design", (class_2561)class_2561.method_43470((String)"Tab Design"), TabDesignWizardPage::new, true);
        WizardNavigator.registerPage(3, "item_background", (class_2561)class_2561.method_43470((String)"Item Background"), ItemBackgroundWizardPage::new, true);
        WizardNavigator.registerPage(4, "resource_packs", (class_2561)class_2561.method_43470((String)"Resource Packs"), ResourcePacksWizardPage::new, true);
        WizardNavigator.registerPage(5, "useful_info", (class_2561)class_2561.method_43470((String)"Useful Information"), UsefulInfoWizardPage::new, false);
        WizardNavigator.registerPage(6, "apply", (class_2561)class_2561.method_43470((String)"Apply Configuration"), ApplyConfigurationWizard::new, false);
    }

    public record PageInfo(String id, class_2561 displayName, PageFactory factory, boolean optional) {
    }

    @FunctionalInterface
    public static interface PageFactory {
        public class_437 create();
    }
}

