/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.wizard.pages;

import com.github.kd_gaming1.packcore.ui.screen.components.WizardUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.wizard.BaseWizardPage;
import com.github.kd_gaming1.packcore.ui.screen.wizard.WizardNavigator;
import com.github.kd_gaming1.packcore.util.markdown.MarkdownService;
import com.github.kd_gaming1.packcore.util.wizard.WizardDataStore;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class OptimizationWizardPage
extends BaseWizardPage {
    private static final String FALLBACK_CONTENT = "# Optimization Profile\n\nChoose your preferred performance settings.\nFind and edit this content in `rundir/packcore/wizard_markdown_content/optimisation.md`\n";
    private static final List<ProfileOption> PROFILES = List.of(new ProfileOption("Max FPS", "\ud83d\ude80", "Maximum FPS", "Highest frame rates. Reduces visual quality for smooth gameplay."), new ProfileOption("Balanced", "\u2696", "Balanced", "Best of both. Good FPS while keeping important visuals."), new ProfileOption("Quality", "\ud83d\udc8e", "Visual Quality", "Beautiful graphics. Requires good hardware."), new ProfileOption("Shaders", "\u2728", "Shaders Enabled", "Ultimate visuals. Needs high-end system."));
    private final String markdownContent;
    private final WizardDataStore dataStore;
    private String selectedProfile;
    private LabelComponent headerTitle;
    private FlowLayout rightPanel;

    public OptimizationWizardPage() {
        super(new BaseWizardPage.WizardPageInfo((class_2561)class_2561.method_43470((String)"FPS OR QUALITY???"), 1, 6), class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"));
        MarkdownService markdownService = new MarkdownService();
        this.markdownContent = markdownService.getOrDefault("optimisation.md", FALLBACK_CONTENT);
        this.dataStore = WizardDataStore.getInstance();
        this.selectedProfile = this.dataStore.getOptimizationProfile();
    }

    @Override
    protected void buildContent(FlowLayout contentContainer) {
        contentContainer.child((Component)WizardUIComponents.createHeader("Choose your preferred optimisation profile for", "Please read the information below carefully before continuing."));
        contentContainer.child(WizardUIComponents.createMarkdownScroll(this.markdownContent));
    }

    @Override
    protected void buildContentRight(FlowLayout contentContainerRight) {
        this.rightPanel = contentContainerRight;
        this.rightPanel.child((Component)this.createSelectionHeader());
        this.rightPanel.child(this.createProfileOptions());
    }

    private FlowLayout createSelectionHeader() {
        FlowLayout header = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).margins(Insets.of((int)8, (int)0, (int)8, (int)8));
        if (this.selectedProfile.isEmpty()) {
            this.headerTitle = WizardUIComponents.createStatusLabel("Select your performance profile below", "\ud83d\udc47", -18355);
        } else {
            ProfileOption selected = this.findProfile(this.selectedProfile);
            String icon = selected != null ? selected.icon() + " " : "";
            this.headerTitle = WizardUIComponents.createStatusLabel("Selected: " + icon + this.selectedProfile, "\u2713", -15681151);
        }
        header.child((Component)this.headerTitle);
        return header;
    }

    private ScrollContainer<FlowLayout> createProfileOptions() {
        FlowLayout profilesLayout = Containers.verticalFlow((Sizing)Sizing.fill((int)96), (Sizing)Sizing.content()).gap(8);
        for (ProfileOption profile : PROFILES) {
            boolean isSelected = profile.key().equals(this.selectedProfile);
            FlowLayout optionBox = WizardUIComponents.createOptionBox(profile.icon(), profile.title(), profile.description(), isSelected, box -> this.selectProfile(profile.key()));
            profilesLayout.child((Component)optionBox);
        }
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)profilesLayout);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scrollContainer.scrollbarThiccness(6);
        scrollContainer.surface(Surface.flat((int)0x40000000).and(Surface.outline((int)0x30FFFFFF)));
        scrollContainer.padding(Insets.of((int)6));
        scrollContainer.margins(Insets.bottom((int)4));
        return scrollContainer;
    }

    private void selectProfile(String profileKey) {
        this.selectedProfile = profileKey;
        this.dataStore.setOptimizationProfile(profileKey);
        if (this.headerTitle != null) {
            ProfileOption selected = this.findProfile(profileKey);
            String icon = selected != null ? selected.icon() + " " : "";
            this.headerTitle.text((class_2561)class_2561.method_43470((String)("\u2713 Selected: " + icon + profileKey)).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-15681151));
        }
        this.rebuildRightPanel();
    }

    private void rebuildRightPanel() {
        this.rightPanel.clearChildren();
        this.rightPanel.child((Component)this.createSelectionHeader());
        this.rightPanel.child(this.createProfileOptions());
    }

    private ProfileOption findProfile(String key) {
        return PROFILES.stream().filter(p -> p.key().equals(key)).findFirst().orElse(null);
    }

    @Override
    protected void onContinuePressed() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(WizardNavigator.createWizardPage(2));
    }

    @Override
    protected int getContentColumnWidthPercent() {
        return 55;
    }

    @Override
    protected boolean shouldShowStatusInfo() {
        return false;
    }

    @Override
    protected boolean shouldShowRightPanel() {
        return true;
    }

    private record ProfileOption(String key, String icon, String title, String description) {
    }
}

