/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.screen.wizard.pages;

import com.github.kd_gaming1.packcore.ui.screen.components.WizardUIComponents;
import com.github.kd_gaming1.packcore.ui.screen.wizard.BaseWizardPage;
import com.github.kd_gaming1.packcore.ui.screen.wizard.WizardNavigator;
import com.github.kd_gaming1.packcore.ui.surface.effects.TextureSurfaces;
import com.github.kd_gaming1.packcore.util.wizard.WizardDataStore;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class TabDesignWizardPage
extends BaseWizardPage {
    private final WizardDataStore dataStore = WizardDataStore.getInstance();
    private String selectedDesign = this.dataStore.getTabDesign();
    private LabelComponent selectionLabel;
    private FlowLayout classicImageContainer;
    private FlowLayout modernImageContainer;

    public TabDesignWizardPage() {
        super(new BaseWizardPage.WizardPageInfo((class_2561)class_2561.method_43470((String)"Tab design"), 2, 6), class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"));
        if (this.selectedDesign.isEmpty()) {
            this.selectedDesign = "None";
        }
    }

    @Override
    protected void buildContent(FlowLayout contentContainer) {
        contentContainer.surface(TextureSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/frame.png"), 1920, 1080));
        contentContainer.padding(Insets.of((int)22, (int)22, (int)18, (int)18));
        contentContainer.child((Component)WizardUIComponents.createHeader("Choose your preferred tab design to use in-game when playing with", "The pack has two mods that change the tab list: SkyHanni and Skyblocker. You can not use both at the same time, so decide which one you like best\u2014and select it. (Tip: Click the image)").margins(Insets.horizontal((int)34)));
        contentContainer.child((Component)this.createSelectionLabel());
        contentContainer.child((Component)this.createImageChoices());
    }

    @Override
    protected void buildContentRight(FlowLayout contentContainerRight) {
    }

    private LabelComponent createSelectionLabel() {
        int color;
        Object displayText;
        if ("None".equals(this.selectedDesign)) {
            displayText = "\ud83d\udc47 Click an image below to choose your tab design";
            color = -18355;
        } else {
            displayText = "\u2713 Selected: " + this.selectedDesign;
            color = -15681151;
        }
        this.selectionLabel = WizardUIComponents.createStatusLabel((String)displayText, null, color);
        this.selectionLabel.margins(Insets.left((int)16));
        return this.selectionLabel;
    }

    private FlowLayout createImageChoices() {
        FlowLayout choicesRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).gap(12).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        choicesRow.child((Component)this.createTabDesignOption(TabDesignOption.SKYHANNI));
        choicesRow.child((Component)this.createTabDesignOption(TabDesignOption.SKYBLOCKER));
        return choicesRow;
    }

    private FlowLayout createTabDesignOption(TabDesignOption option) {
        FlowLayout wrapper = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)48), (Sizing)Sizing.expand()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).margins(Insets.of((int)0, (int)10, (int)8, (int)8)).cursorStyle(CursorStyle.HAND);
        wrapper.child((Component)Components.label((class_2561)class_2561.method_43470((String)option.displayName).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-1)).margins(Insets.of((int)4, (int)4, (int)2, (int)4)));
        boolean isSelected = option.key.equals(this.selectedDesign);
        class_2960 textureId = class_2960.method_60655((String)"packcore", (String)("textures/gui/wizard/" + option.texturePath));
        FlowLayout imageContainer = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand()).verticalAlignment(VerticalAlignment.CENTER).horizontalAlignment(HorizontalAlignment.CENTER).surface(TextureSurfaces.scaledContain(textureId, 2560, 1441)).margins(Insets.of((int)4)).cursorStyle(CursorStyle.HAND);
        if (isSelected) {
            imageContainer.surface(Surface.outline((int)-15681151).and(TextureSurfaces.scaledContain(textureId, 2560, 1441)));
        }
        if (option == TabDesignOption.SKYHANNI) {
            this.classicImageContainer = imageContainer;
        } else {
            this.modernImageContainer = imageContainer;
        }
        imageContainer.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.selectDesign(option.key);
            return true;
        });
        wrapper.child((Component)imageContainer);
        return wrapper;
    }

    private void selectDesign(String design) {
        this.selectedDesign = design;
        this.dataStore.setTabDesign(design);
        if (this.selectionLabel != null) {
            this.selectionLabel.text((class_2561)class_2561.method_43470((String)("\u2713 Selected: " + this.selectedDesign)).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(Color.ofRgb((int)-15681151));
        }
        this.updateBorders();
    }

    private void updateBorders() {
        if (this.classicImageContainer != null && this.modernImageContainer != null) {
            this.classicImageContainer.surface(TextureSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/skyhanni_tab.png"), 2560, 1441));
            this.modernImageContainer.surface(TextureSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/skyblocker_tab.png"), 2560, 1441));
            if ("SkyHanni".equals(this.selectedDesign)) {
                this.classicImageContainer.surface(TextureSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/skyhanni_tab.png"), 2560, 1441).and(Surface.outline((int)-15681151)));
            } else if ("Skyblocker".equals(this.selectedDesign)) {
                this.modernImageContainer.surface(TextureSurfaces.scaledContain(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/skyblocker_tab.png"), 2560, 1441).and(Surface.outline((int)-15681151)));
            }
        }
    }

    @Override
    protected void onContinuePressed() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(WizardNavigator.createWizardPage(3));
    }

    @Override
    protected int getContentColumnWidthPercent() {
        return 100;
    }

    @Override
    protected boolean shouldShowStatusInfo() {
        return false;
    }

    private static enum TabDesignOption {
        SKYHANNI("SkyHanni", "SkyHanni Compact Tab", "skyhanni_tab.png"),
        SKYBLOCKER("Skyblocker", "Skyblocker Fancy TabList", "skyblocker_tab.png");

        private final String key;
        private final String displayName;
        private final String texturePath;

        private TabDesignOption(String key, String displayName, String texturePath) {
            this.key = key;
            this.displayName = displayName;
            this.texturePath = texturePath;
        }
    }
}

