/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.ui.toast;

import io.wispforest.owo.ui.base.BaseOwoToast;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_374;

public class PackCoreToast
extends BaseOwoToast<FlowLayout> {
    private static final int DEFAULT_WIDTH = 280;
    private static final int DEFAULT_PADDING = 12;
    private static final long DEFAULT_DURATION_MS = 10000L;

    private PackCoreToast(Builder builder) {
        super(() -> PackCoreToast.createContent(builder), PackCoreToast.createTimeoutPredicate(System.currentTimeMillis(), builder.duration));
    }

    private static BaseOwoToast.VisibilityPredicate<FlowLayout> createTimeoutPredicate(long startTime, long duration) {
        return (toast, time) -> {
            long elapsed = System.currentTimeMillis() - startTime;
            return elapsed < duration ? class_368.class_369.field_2210 : class_368.class_369.field_2209;
        };
    }

    private static FlowLayout createContent(Builder builder) {
        FlowLayout container = Containers.verticalFlow((Sizing)Sizing.fixed((int)builder.width), (Sizing)Sizing.content());
        if (builder.icon != null) {
            FlowLayout iconRow = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).verticalAlignment(VerticalAlignment.CENTER);
            if (builder.iconTexture != null) {
                iconRow.child((Component)Components.texture((class_2960)builder.iconTexture, (int)0, (int)0, (int)builder.iconSize, (int)builder.iconSize, (int)builder.iconSize, (int)builder.iconSize));
            } else if (builder.icon != null) {
                iconRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)builder.icon).method_27692(class_124.field_1067)).color(Color.ofRgb((int)builder.borderColor)));
            }
            if (builder.title != null) {
                iconRow.child((Component)builder.title);
            }
            container.child((Component)iconRow);
        } else if (builder.title != null) {
            container.child((Component)builder.title);
        }
        for (LabelComponent line : builder.lines) {
            container.child((Component)line);
        }
        container.gap(builder.gap).padding(Insets.of((int)builder.padding)).surface(Surface.flat((int)builder.backgroundColor)).horizontalAlignment(builder.horizontalAlignment).verticalAlignment(VerticalAlignment.TOP);
        if (builder.borderColor != 0) {
            FlowLayout borderContainer = Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
            borderContainer.child((Component)container).surface(Surface.outline((int)builder.borderColor)).padding(Insets.of((int)1));
            return borderContainer;
        }
        return container;
    }

    public void show() {
        class_374 toastManager = class_310.method_1551().method_1566();
        toastManager.method_1999((class_368)this);
    }

    public static void showUpdateAvailable(String currentVersion, String newVersion, String modpackName) {
        new Builder().type(ToastType.UPDATE).title((class_2561)class_2561.method_43470((String)"Update Available for ").method_10852((class_2561)class_2561.method_43470((String)modpackName).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"!"))).line((class_2561)class_2561.method_43470((String)currentVersion).method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)" \u2192 ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)newVersion).method_27692(class_124.field_1065))).line("Update the pack in your launcher", class_124.field_1080, class_124.field_1056).duration(12000L).show();
    }

    public static void showExportComplete(String configName, String fileName) {
        new Builder().type(ToastType.SUCCESS).title("Export Complete!").line((class_2561)class_2561.method_43470((String)"Config: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)configName).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}))).line((class_2561)class_2561.method_43470((String)"Saved as: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)fileName).method_27692(class_124.field_1054))).line("You can now share or import this config", class_124.field_1080, class_124.field_1056).show();
    }

    public static void showBackupComplete(String backupName, String fileName, boolean isRestore) {
        String title = isRestore ? "Restore Complete!" : "Backup Complete!";
        String message = isRestore ? "Configuration restored successfully." : "Backup saved successfully.";
        new Builder().type(ToastType.SUCCESS).borderColor(isRestore ? -11184641 : -11141291).title(title).line((class_2561)class_2561.method_43470((String)"Name: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)backupName).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}))).line((class_2561)class_2561.method_43470((String)"File: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)fileName).method_27692(class_124.field_1054))).line(message, class_124.field_1080, class_124.field_1056).show();
    }

    public static void showError(String title, String message) {
        new Builder().type(ToastType.ERROR).title(title).line(message, class_124.field_1061).duration(8000L).show();
    }

    public static void showWarning(String title, String message) {
        new Builder().type(ToastType.WARNING).title(title).line(message, class_124.field_1054).show();
    }

    public static void showInfo(String title, String message) {
        new Builder().type(ToastType.INFO).title(title).line(message, class_124.field_1075).show();
    }

    public static void showSuccess(String message) {
        new Builder().type(ToastType.SUCCESS).title("Success!").line(message, class_124.field_1060).duration(5000L).show();
    }

    public static class Builder {
        private LabelComponent title;
        private final List<LabelComponent> lines = new ArrayList<LabelComponent>();
        private ToastType type = ToastType.INFO;
        private int borderColor;
        private String icon;
        private class_2960 iconTexture;
        private int iconSize;
        private int width;
        private int padding;
        private int gap;
        private long duration;
        private int backgroundColor;
        private HorizontalAlignment horizontalAlignment;

        public Builder() {
            this.borderColor = ToastType.INFO.borderColor;
            this.icon = null;
            this.iconTexture = null;
            this.iconSize = 16;
            this.width = 280;
            this.padding = 12;
            this.gap = 2;
            this.duration = 10000L;
            this.backgroundColor = -1073741824;
            this.horizontalAlignment = HorizontalAlignment.LEFT;
        }

        public Builder type(ToastType type) {
            this.type = type;
            this.borderColor = type.borderColor;
            this.icon = type.icon;
            return this;
        }

        public Builder title(String text) {
            this.title = Components.label((class_2561)class_2561.method_43470((String)text).method_27695(new class_124[]{class_124.field_1068, class_124.field_1067}));
            this.title.horizontalTextAlignment(HorizontalAlignment.LEFT);
            return this;
        }

        public Builder title(class_2561 text) {
            this.title = Components.label((class_2561)text);
            this.title.horizontalTextAlignment(HorizontalAlignment.LEFT);
            return this;
        }

        public Builder line(String text) {
            return this.line(text, class_124.field_1080);
        }

        public Builder line(String text, class_124 ... formatting) {
            LabelComponent line = Components.label((class_2561)class_2561.method_43470((String)text).method_27695(formatting));
            line.horizontalTextAlignment(HorizontalAlignment.LEFT);
            this.lines.add(line);
            return this;
        }

        public Builder line(class_2561 text) {
            LabelComponent line = Components.label((class_2561)text);
            line.horizontalTextAlignment(HorizontalAlignment.LEFT);
            this.lines.add(line);
            return this;
        }

        public Builder icon(String icon) {
            this.icon = icon;
            this.iconTexture = null;
            return this;
        }

        public Builder iconTexture(class_2960 texture, int size) {
            this.iconTexture = texture;
            this.iconSize = size;
            this.icon = null;
            return this;
        }

        public Builder borderColor(int color) {
            this.borderColor = color;
            return this;
        }

        public Builder backgroundColor(int color) {
            this.backgroundColor = color;
            return this;
        }

        public Builder duration(long durationMs) {
            this.duration = durationMs;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder padding(int padding) {
            this.padding = padding;
            return this;
        }

        public Builder gap(int gap) {
            this.gap = gap;
            return this;
        }

        public Builder alignment(HorizontalAlignment alignment) {
            this.horizontalAlignment = alignment;
            return this;
        }

        public PackCoreToast build() {
            if (this.title == null) {
                throw new IllegalStateException("Toast must have a title");
            }
            return new PackCoreToast(this);
        }

        public void show() {
            this.build().show();
        }
    }

    public static enum ToastType {
        SUCCESS(-11141291, "\u2713"),
        WARNING(-10496, "\u26a0"),
        ERROR(-43691, "\u2717"),
        INFO(-11184641, "\u2139"),
        UPDATE(-10496, "\u2191");

        private final int borderColor;
        private final String icon;

        private ToastType(int borderColor, String icon) {
            this.borderColor = borderColor;
            this.icon = icon;
        }
    }
}

