/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.io.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipAsyncTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipAsyncTask.class);
    private static final int BUFFER_SIZE = 16384;
    private static final ExecutorService ZIP_EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("AsyncZip-" + thread.threadId());
        thread.setDaemon(true);
        return thread;
    });

    public CompletableFuture<Void> zipDirectoryAsync(File dir, String zipFilePath, ProgressCallback progressCallback) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.zipDirectory(dir, zipFilePath, progressCallback);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to zip directory", e);
            }
        }, ZIP_EXECUTOR);
    }

    public void zipDirectory(File dir, String zipFilePath, final ProgressCallback progressCallback) throws IOException {
        final Path basePath = dir.toPath();
        final AtomicLong totalSize = new AtomicLong(0L);
        try (Stream<Path> walk = Files.walk(basePath, new FileVisitOption[0]);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                try {
                    totalSize.addAndGet(Files.size(path));
                }
                catch (IOException e) {
                    LOGGER.debug("Could not get size for: {}", path);
                }
            });
        }
        final AtomicLong processedBytes = new AtomicLong(0L);
        final int lastReportedProgress = 0;
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             BufferedOutputStream bos = new BufferedOutputStream(fos, 16384);
             final ZipOutputStream zos = new ZipOutputStream(bos);){
            zos.setLevel(6);
            final byte[] buffer = new byte[16384];
            Files.walkFileTree(basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path relativePath = basePath.relativize(dir);
                    if (!relativePath.toString().isEmpty()) {
                        String entryName = relativePath.toString().replace(File.separatorChar, '/') + "/";
                        ZipEntry dirEntry = new ZipEntry(entryName);
                        dirEntry.setTime(attrs.lastModifiedTime().toMillis());
                        zos.putNextEntry(dirEntry);
                        zos.closeEntry();
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relativePath = basePath.relativize(file);
                    String entryName = relativePath.toString().replace(File.separatorChar, '/');
                    ZipEntry fileEntry = new ZipEntry(entryName);
                    fileEntry.setTime(attrs.lastModifiedTime().toMillis());
                    fileEntry.setSize(attrs.size());
                    zos.putNextEntry(fileEntry);
                    try (InputStream is = Files.newInputStream(file, StandardOpenOption.READ);){
                        int bytesRead;
                        while ((bytesRead = is.read(buffer)) > 0) {
                            int currentProgress;
                            zos.write(buffer, 0, bytesRead);
                            long processed = processedBytes.addAndGet(bytesRead);
                            if (progressCallback == null || totalSize.get() <= 0L || (currentProgress = (int)(processed * 100L / totalSize.get())) == lastReportedProgress) continue;
                            progressCallback.onProgress(processed, totalSize.get(), currentProgress);
                        }
                    }
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    LOGGER.warn("Failed to zip file: {} - {}", (Object)file, (Object)exc.getMessage());
                    return FileVisitResult.CONTINUE;
                }
            });
            if (progressCallback != null) {
                progressCallback.onProgress(processedBytes.get(), totalSize.get(), 100);
            }
            LOGGER.info("Successfully zipped {} to {}", (Object)dir.getAbsolutePath(), (Object)zipFilePath);
        }
    }

    public CompletableFuture<Void> zipSingleFileAsync(File file, String zipFileName, ProgressCallback progressCallback) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.zipSingleFile(file, zipFileName, progressCallback);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to zip file", e);
            }
        }, ZIP_EXECUTOR);
    }

    public void zipSingleFile(File file, String zipFileName, ProgressCallback progressCallback) throws IOException {
        long totalSize = file.length();
        AtomicLong processedBytes = new AtomicLong(0L);
        int lastReportedProgress = 0;
        try (FileOutputStream fos = new FileOutputStream(zipFileName);
             BufferedOutputStream bos = new BufferedOutputStream(fos, 16384);
             ZipOutputStream zos = new ZipOutputStream(bos);
             FileInputStream fis = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(fis, 16384);){
            int bytesRead;
            ZipEntry ze = new ZipEntry(file.getName());
            ze.setTime(file.lastModified());
            ze.setSize(file.length());
            zos.putNextEntry(ze);
            byte[] buffer = new byte[16384];
            while ((bytesRead = bis.read(buffer)) > 0) {
                int currentProgress;
                zos.write(buffer, 0, bytesRead);
                long processed = processedBytes.addAndGet(bytesRead);
                if (progressCallback == null || totalSize <= 0L || (currentProgress = (int)(processed * 100L / totalSize)) == lastReportedProgress) continue;
                lastReportedProgress = currentProgress;
                progressCallback.onProgress(processed, totalSize, currentProgress);
            }
            zos.closeEntry();
            if (progressCallback != null) {
                progressCallback.onProgress(totalSize, totalSize, 100);
            }
            LOGGER.info("Successfully zipped {} to {}", (Object)file.getCanonicalPath(), (Object)zipFileName);
        }
    }

    public static void shutdown() {
        ZIP_EXECUTOR.shutdown();
    }

    public static interface ProgressCallback {
        public void onProgress(long var1, long var3, int var5);
    }
}

