/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.markdown;

import com.github.kd_gaming1.packcore.util.markdown.MarkdownLoadResult;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MarkdownService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkdownService.class);
    private final Path infoHelpDir;
    private final String assetsNamespace;

    public MarkdownService() {
        this(FabricLoader.getInstance().getGameDir().resolve("packcore/wizard_markdown_content"), "packcore");
    }

    public MarkdownService(Path infoHelpDir, String assetsNamespace) {
        this.infoHelpDir = infoHelpDir;
        this.assetsNamespace = assetsNamespace;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MarkdownLoadResult load(String fileName) {
        String sanitized = MarkdownService.sanitize(fileName);
        if (sanitized == null) {
            return new MarkdownLoadResult.Error(fileName, "Invalid file name", null);
        }
        Path file = this.infoHelpDir.resolve(sanitized);
        if (Files.isRegularFile(file, new LinkOption[0])) {
            try {
                return new MarkdownLoadResult.Success(Files.readString(file));
            }
            catch (IOException e) {
                LOGGER.error("Failed to read markdown file: {}", (Object)file, (Object)e);
                return new MarkdownLoadResult.Error(sanitized, "Failed to read file", e);
            }
        }
        String resourcePath = "/assets/" + this.assetsNamespace + "/markdown/" + sanitized;
        try (InputStream in = MarkdownService.class.getResourceAsStream(resourcePath);){
            if (in != null) {
                byte[] bytes = in.readAllBytes();
                MarkdownLoadResult.Success success = new MarkdownLoadResult.Success(new String(bytes, StandardCharsets.UTF_8));
                return success;
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read classpath markdown: {}", (Object)resourcePath, (Object)e);
            return new MarkdownLoadResult.Error(sanitized, "Failed to read classpath resource", e);
        }
        LOGGER.warn("Markdown not found: {} (fs: {}, classpath: {})", new Object[]{sanitized, file, resourcePath});
        return new MarkdownLoadResult.NotFound(sanitized);
    }

    public String getOrDefault(String fileName, String fallback) {
        MarkdownLoadResult result;
        MarkdownLoadResult markdownLoadResult = result = this.load(fileName);
        Objects.requireNonNull(markdownLoadResult);
        MarkdownLoadResult markdownLoadResult2 = markdownLoadResult;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MarkdownLoadResult.Success.class, MarkdownLoadResult.NotFound.class, MarkdownLoadResult.Error.class}, (Object)markdownLoadResult2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                MarkdownLoadResult.Success s = (MarkdownLoadResult.Success)markdownLoadResult2;
                yield s.content();
            }
            case 1 -> {
                MarkdownLoadResult.NotFound __ = (MarkdownLoadResult.NotFound)markdownLoadResult2;
                yield fallback;
            }
            case 2 -> {
                MarkdownLoadResult.Error e = (MarkdownLoadResult.Error)markdownLoadResult2;
                yield fallback;
            }
        };
    }

    private static String sanitize(String name) {
        if (name == null) {
            return null;
        }
        Object n = name.trim();
        if (((String)n).isEmpty() || ((String)n).contains("..") || ((String)n).contains("/") || ((String)n).contains("\\")) {
            return null;
        }
        if (!((String)n).endsWith(".md")) {
            n = (String)n + ".md";
        }
        return n;
    }
}

