/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.update.modrinth;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.util.update.modrinth.ModrinthVersion;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;

public class ModrinthClient {
    private static final String API_BASE_URL = "https://api.modrinth.com/v2";
    private static final String USER_AGENT = "kdgaming0/packcore/2.0.0";
    private final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    private final Gson gson = new Gson();

    public ModrinthVersion getLatestVersion(String projectId, String updateChannel, String minecraftVersion) throws IOException, InterruptedException {
        PackCore.LOGGER.info("Checking for updates - Project: {}, Channel: {}, MC Version: {}", new Object[]{projectId, updateChannel, minecraftVersion});
        String url = "https://api.modrinth.com/v2/project/" + projectId + "/version";
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", USER_AGENT).timeout(Duration.ofSeconds(30L)).GET().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            String error = "Modrinth API returned status: " + response.statusCode() + " for project: " + projectId;
            PackCore.LOGGER.error(error);
            throw new IOException(error);
        }
        PackCore.LOGGER.debug("API Response: {}", (Object)response.body());
        return this.parseLatestVersion(response.body(), updateChannel, minecraftVersion);
    }

    private ModrinthVersion parseLatestVersion(String jsonResponse, String updateChannel, String minecraftVersion) {
        JsonArray versionsArray = (JsonArray)this.gson.fromJson(jsonResponse, JsonArray.class);
        ArrayList<ModrinthVersion> suitableVersions = new ArrayList<ModrinthVersion>();
        for (int i = 0; i < versionsArray.size(); ++i) {
            JsonObject versionObj = versionsArray.get(i).getAsJsonObject();
            String versionType = versionObj.get("version_type").getAsString();
            JsonArray gameVersions = versionObj.getAsJsonArray("game_versions");
            if (!this.isVersionTypeAllowed(versionType, updateChannel) || !this.supportsMinecraftVersion(gameVersions, minecraftVersion)) continue;
            ModrinthVersion version = new ModrinthVersion(versionObj.get("version_number").getAsString(), versionType, versionObj.has("changelog") && !versionObj.get("changelog").isJsonNull() ? versionObj.get("changelog").getAsString() : "No changelog available", versionObj.get("id").getAsString(), versionObj.get("date_published").getAsString());
            suitableVersions.add(version);
        }
        return suitableVersions.isEmpty() ? null : (ModrinthVersion)suitableVersions.getFirst();
    }

    private boolean isVersionTypeAllowed(String versionType, String updateChannel) {
        return switch (updateChannel.toLowerCase()) {
            case "alpha" -> true;
            case "beta" -> {
                if (versionType.equals("beta") || versionType.equals("release")) {
                    yield true;
                }
                yield false;
            }
            case "release" -> versionType.equals("release");
            default -> false;
        };
    }

    private boolean supportsMinecraftVersion(JsonArray gameVersions, String targetVersion) {
        String baseVersion = targetVersion.endsWith("+") ? targetVersion.substring(0, targetVersion.length() - 1) : null;
        for (int i = 0; i < gameVersions.size(); ++i) {
            String version = gameVersions.get(i).getAsString();
            if (!version.equals(targetVersion) && (baseVersion == null || !version.startsWith(baseVersion))) continue;
            return true;
        }
        return false;
    }
}

