/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.update.modrinth;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.modpack.ModpackInfo;
import com.github.kd_gaming1.packcore.ui.screen.title.SBEStyledTitleScreen;
import com.github.kd_gaming1.packcore.util.update.UpdateResult;
import com.github.kd_gaming1.packcore.util.update.modrinth.ModrinthClient;
import com.github.kd_gaming1.packcore.util.update.modrinth.ModrinthVersion;
import java.time.Duration;
import java.time.Instant;

public class UpdateCache {
    private String cachedVersionNumber;
    private String cachedVersionType;
    private String cachedChangelog;
    private String cachedVersionId;
    private boolean updateAvailable;
    private String cachedModrinthProjectId;
    private String cachedUpdateChannel;
    private String cachedCurrentVersion;
    private String cachedMinecraftVersion;
    private Instant lastUpdateCheck;
    private static final long CACHE_DURATION_MINUTES = 15L;
    private final ModrinthClient apiClient = new ModrinthClient();

    public UpdateResult checkForUpdates(ModpackInfo modpackInfo) {
        if (modpackInfo.isConfigurationValid()) {
            String error = modpackInfo.getValidationError();
            PackCore.LOGGER.error("Invalid modpack configuration: {}", (Object)error);
            return UpdateResult.error("Configuration error: " + error);
        }
        if (this.isCacheValid(modpackInfo)) {
            return this.createResultFromCache();
        }
        try {
            return this.fetchAndCacheUpdates(modpackInfo);
        }
        catch (Exception e) {
            return UpdateResult.error("Failed to check for updates: " + e.getMessage());
        }
    }

    private boolean isCacheValid(ModpackInfo modpackInfo) {
        return this.lastUpdateCheck != null && Duration.between(this.lastUpdateCheck, Instant.now()).toMinutes() < 15L && this.configMatches(modpackInfo);
    }

    private boolean configMatches(ModpackInfo modpackInfo) {
        return modpackInfo.getModrinthProjectId().equals(this.cachedModrinthProjectId) && modpackInfo.getUpdateChannel().equals(this.cachedUpdateChannel) && modpackInfo.getVersion().equals(this.cachedCurrentVersion) && modpackInfo.getMinecraftVersion().equals(this.cachedMinecraftVersion);
    }

    private UpdateResult createResultFromCache() {
        return new UpdateResult(this.updateAvailable, this.cachedVersionNumber, this.cachedVersionType, this.cachedChangelog, this.cachedVersionId);
    }

    private UpdateResult fetchAndCacheUpdates(ModpackInfo modpackInfo) {
        try {
            boolean isNewer;
            ModrinthVersion latestVersion = this.apiClient.getLatestVersion(modpackInfo.getModrinthProjectId(), modpackInfo.getUpdateChannel(), modpackInfo.getMinecraftVersion());
            this.updateCacheConfig(modpackInfo);
            this.lastUpdateCheck = Instant.now();
            if (latestVersion == null) {
                this.updateAvailable = false;
                this.cachedVersionNumber = null;
                this.cachedVersionType = null;
                this.cachedChangelog = "No versions found matching your criteria";
                this.cachedVersionId = null;
                return new UpdateResult(false, null, null, "No versions found matching your criteria", null);
            }
            this.updateAvailable = isNewer = this.compareVersions(latestVersion.versionNumber(), modpackInfo.getVersion()) > 0;
            this.cachedVersionNumber = latestVersion.versionNumber();
            this.cachedVersionType = latestVersion.versionType();
            this.cachedChangelog = latestVersion.changelog();
            this.cachedVersionId = latestVersion.versionId();
            return new UpdateResult(isNewer, this.cachedVersionNumber, this.cachedVersionType, this.cachedChangelog, this.cachedVersionId);
        }
        catch (Exception e) {
            return UpdateResult.error("Failed to check for updates: " + e.getMessage());
        }
    }

    private void updateCacheConfig(ModpackInfo modpackInfo) {
        this.cachedModrinthProjectId = modpackInfo.getModrinthProjectId();
        this.cachedUpdateChannel = modpackInfo.getUpdateChannel();
        this.cachedCurrentVersion = modpackInfo.getVersion();
        this.cachedMinecraftVersion = modpackInfo.getMinecraftVersion();
    }

    private int compareVersions(String v1, String v2) {
        return SBEStyledTitleScreen.compareVersions(v1, v2);
    }
}

