/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.config.apply;

import com.github.kd_gaming1.packcore.config.backup.LocalBackupOps;
import com.github.kd_gaming1.packcore.config.storage.ConfigFileRepository;
import com.github.kd_gaming1.packcore.util.io.zip.UnzipService;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigAutoApplier {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigAutoApplier.class);

    public static boolean applyBestMatchingConfig(Path gameDir) {
        LOGGER.info("Starting automatic config application...");
        Dimension screenSize = ConfigAutoApplier.detectResolution();
        if (screenSize == null) {
            LOGGER.error("Failed to detect screen resolution");
            return false;
        }
        LOGGER.info("Detected screen resolution: {}x{}", (Object)screenSize.width, (Object)screenSize.height);
        List<ConfigFileRepository.ConfigFile> allConfigs = ConfigFileRepository.getAllConfigs();
        if (allConfigs.isEmpty()) {
            LOGGER.warn("No configs available for automatic application");
            return false;
        }
        LOGGER.info("Found {} available configs", (Object)allConfigs.size());
        ConfigFileRepository.ConfigFile bestMatch = ConfigAutoApplier.findBestMatch(screenSize, allConfigs);
        if (bestMatch == null) {
            LOGGER.error("Could not find suitable config to apply");
            return false;
        }
        LOGGER.info("Selected config: {} ({})", (Object)bestMatch.getDisplayName(), (Object)(bestMatch.official() ? "Official" : "Custom"));
        return ConfigAutoApplier.applyConfigDirect(bestMatch, gameDir);
    }

    private static boolean applyConfigDirect(ConfigFileRepository.ConfigFile config, Path gameDir) {
        LOGGER.info("Applying config: {}", (Object)config.getDisplayName());
        try {
            Path backup = LocalBackupOps.createBackup(gameDir);
            if (backup != null) {
                LOGGER.info("Backup created at: {}", (Object)backup);
                LocalBackupOps.cleanOldBackups(gameDir, 5);
            }
            UnzipService unzipper = new UnzipService();
            unzipper.unzip(config.path().toString(), gameDir.toString(), (bytesProcessed, totalBytes, percentage) -> {
                if (percentage % 25 == 0) {
                    LOGGER.info("Extraction progress: {}%", (Object)percentage);
                }
            });
            ConfigFileRepository.saveCurrentConfig(config.metadata());
            LOGGER.info("Config applied successfully: {}", (Object)config.getDisplayName());
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to apply config", (Throwable)e);
            return false;
        }
    }

    private static Dimension detectResolution() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            LOGGER.debug("Screen dimensions: {}x{}", (Object)screenSize.width, (Object)screenSize.height);
            return screenSize;
        }
        catch (Exception e) {
            LOGGER.error("Failed to detect resolution", (Throwable)e);
            return null;
        }
    }

    private static ConfigFileRepository.ConfigFile findBestMatch(Dimension detectedResolution, List<ConfigFileRepository.ConfigFile> configs) {
        LOGGER.info("Available configs:");
        for (ConfigFileRepository.ConfigFile config : configs) {
            String targetRes = config.metadata().getTargetResolution();
            Dimension configRes = ConfigAutoApplier.parseResolution(targetRes);
            double distance = ConfigAutoApplier.calculateDistance(detectedResolution, configRes);
            LOGGER.info("  - {} | Resolution: {} | Official: {} | Distance: {}", new Object[]{config.getDisplayName(), targetRes, config.official(), configRes != null ? String.format("%.0f", distance) : "N/A"});
        }
        ConfigFileRepository.ConfigFile selected = configs.stream().min(ConfigAutoApplier.createConfigComparator(detectedResolution)).orElse(null);
        if (selected != null) {
            Dimension selectedRes = ConfigAutoApplier.parseResolution(selected.metadata().getTargetResolution());
            double distance = ConfigAutoApplier.calculateDistance(detectedResolution, selectedRes);
            LOGGER.info("Best match selected: {} (distance: {} pixels)", (Object)selected.getDisplayName(), (Object)String.format("%.0f", distance));
        }
        return selected;
    }

    private static Comparator<ConfigFileRepository.ConfigFile> createConfigComparator(Dimension targetResolution) {
        return Comparator.comparing(c -> !c.official()).thenComparing(c -> {
            Dimension configRes = ConfigAutoApplier.parseResolution(c.metadata().getTargetResolution());
            return ConfigAutoApplier.calculateDistance(targetResolution, configRes);
        }).thenComparing(ConfigFileRepository.ConfigFile::getDisplayName);
    }

    private static double calculateDistance(Dimension target, Dimension candidate) {
        if (target == null || candidate == null) {
            return Double.MAX_VALUE;
        }
        double widthDiff = target.width - candidate.width;
        double heightDiff = target.height - candidate.height;
        return Math.sqrt(widthDiff * widthDiff + heightDiff * heightDiff);
    }

    private static Dimension parseResolution(String resolution) {
        if (resolution == null || resolution.trim().isEmpty()) {
            return null;
        }
        String cleaned = resolution.trim().toLowerCase();
        if ((cleaned = cleaned.replace('\u00d7', 'x')).matches("\\d+\\s*x\\s*\\d+")) {
            String[] parts = cleaned.split("x");
            try {
                int width = Integer.parseInt(parts[0].trim());
                int height = Integer.parseInt(parts[1].trim());
                return new Dimension(width, height);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Could not parse resolution numbers: {}", (Object)resolution);
                return null;
            }
        }
        LOGGER.warn("Resolution format not recognized: {}", (Object)resolution);
        return null;
    }
}

