/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.config.apply;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDescriptionRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private static final Gson GSON = new Gson();
    private static final String DESCRIPTIONS_FILE = "file-descriptions.json";
    private static final String CONFIG_PREFIX = "config/";
    private static final String RESOURCEPACKS_PREFIX = "resourcepacks/";
    private static Map<String, FileDescription> masterDescriptions = new HashMap<String, FileDescription>();

    private static void loadMasterDescriptions() {
        try {
            class_3300 resourceManager = class_310.method_1551().method_1478();
            class_2960 resourceId = class_2960.method_60655((String)"packcore", (String)DESCRIPTIONS_FILE);
            try (InputStream stream = ((class_3298)resourceManager.method_14486(resourceId).orElseThrow()).method_14482();){
                Map<String, FileDescription> descriptions = FileDescriptionRegistry.parseDescriptionsJson(stream);
                masterDescriptions = descriptions;
                LOGGER.info("Loaded {} master file descriptions", (Object)descriptions.size());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load master descriptions", (Throwable)e);
            masterDescriptions = new HashMap<String, FileDescription>();
        }
    }

    public static Map<String, FileDescription> loadFromZip(ZipFile zipFile) {
        ZipEntry entry = zipFile.getEntry(DESCRIPTIONS_FILE);
        if (entry != null) {
            HashMap<String, FileDescription> hashMap;
            block9: {
                InputStream stream = zipFile.getInputStream(entry);
                try {
                    Map<String, FileDescription> customDescriptions = FileDescriptionRegistry.parseDescriptionsJson(stream);
                    LOGGER.info("Loaded {} custom file descriptions from ZIP", (Object)customDescriptions.size());
                    HashMap<String, FileDescription> merged = new HashMap<String, FileDescription>(masterDescriptions);
                    merged.putAll(customDescriptions);
                    hashMap = merged;
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOGGER.warn("Failed to load descriptions from ZIP, using master", (Throwable)e);
                    }
                }
                stream.close();
            }
            return hashMap;
        }
        return new HashMap<String, FileDescription>(masterDescriptions);
    }

    private static Map<String, FileDescription> parseDescriptionsJson(InputStream stream) {
        JsonObject root = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
        if (root.has("descriptions")) {
            Type typeToken = new TypeToken<Map<String, FileDescription>>(){}.getType();
            return (Map)GSON.fromJson(root.get("descriptions"), typeToken);
        }
        return new HashMap<String, FileDescription>();
    }

    public static Optional<FileDescription> getDescription(String path, Map<String, FileDescription> descriptions) {
        String normalizedPath = FileDescriptionRegistry.normalizePath(path);
        FileDescription exact = descriptions.get(normalizedPath);
        if (exact != null) {
            return Optional.of(exact);
        }
        for (Map.Entry<String, FileDescription> entry : descriptions.entrySet()) {
            if (!normalizedPath.endsWith(entry.getKey().toLowerCase())) continue;
            return Optional.of(entry.getValue());
        }
        return FileDescriptionRegistry.inferDescription(normalizedPath);
    }

    public static Optional<FileDescription> getDescription(String path) {
        return FileDescriptionRegistry.getDescription(path, masterDescriptions);
    }

    private static String normalizePath(String path) {
        return path.replace("\\", "/").toLowerCase();
    }

    private static Optional<FileDescription> inferDescription(String path) {
        if (path.startsWith(CONFIG_PREFIX)) {
            return FileDescriptionRegistry.inferConfigDescription(path);
        }
        if (path.startsWith(RESOURCEPACKS_PREFIX)) {
            return FileDescriptionRegistry.inferResourcePackDescription(path);
        }
        return Optional.empty();
    }

    private static Optional<FileDescription> inferConfigDescription(String path) {
        String fileName = path.substring(CONFIG_PREFIX.length());
        int slashIndex = fileName.indexOf(47);
        if (slashIndex > 0) {
            String folderName = fileName.substring(0, slashIndex);
            return Optional.of(new FileDescription(FileDescriptionRegistry.formatModName(folderName) + " Configuration", "Settings and options for " + FileDescriptionRegistry.formatModName(folderName), "\u2699", false));
        }
        String baseName = FileDescriptionRegistry.getBaseName(fileName);
        return Optional.of(new FileDescription(FileDescriptionRegistry.formatModName(baseName) + " Config", "Configuration file for " + FileDescriptionRegistry.formatModName(baseName), "\u2699", false));
    }

    private static Optional<FileDescription> inferResourcePackDescription(String path) {
        String packName = path.substring(RESOURCEPACKS_PREFIX.length());
        int slashIndex = packName.indexOf(47);
        if (slashIndex > 0) {
            packName = packName.substring(0, slashIndex);
        }
        return Optional.of(new FileDescription("Resource Pack: " + packName, "Texture and sound resources", "\ud83c\udfa8", false));
    }

    private static String getBaseName(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex > 0 ? fileName.substring(0, dotIndex) : fileName;
    }

    private static String formatModName(String modName) {
        modName = modName.replace("-", " ").replace("_", " ");
        String[] words = modName.split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return formatted.toString().trim();
    }

    public static boolean isImportantFile(String path) {
        return FileDescriptionRegistry.getDescription(path).map(FileDescription::isImportant).orElse(false);
    }

    public static String getIcon(String path) {
        return FileDescriptionRegistry.getDescription(path).map(FileDescription::icon).orElse("\ud83d\udcc4");
    }

    static {
        FileDescriptionRegistry.loadMasterDescriptions();
    }

    public record FileDescription(String displayName, String description, String icon, boolean isImportant) {
    }
}

