/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.config.model;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class ConfigMetadata {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    private String name = "Unknown Config";
    private String description = "";
    private String version = "1.0.0";
    private String author = "Unknown";
    private String createdDate = LocalDateTime.now().format(DATE_FORMAT);
    private String targetResolution = "Any";
    private List<String> mods = new ArrayList<String>();
    private String source = "Community";

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public String getTargetResolution() {
        return this.targetResolution;
    }

    public List<String> getMods() {
        return new ArrayList<String>(this.mods);
    }

    public String getSource() {
        return this.source;
    }

    public String getDisplayName() {
        return this.name + " v" + this.version;
    }

    public boolean isValid() {
        return this.name != null && !this.name.isBlank();
    }

    public static class Builder {
        private final ConfigMetadata metadata = new ConfigMetadata();

        public Builder name(String name) {
            this.metadata.name = name != null && !name.isBlank() ? name : "Unknown Config";
            return this;
        }

        public Builder description(String description) {
            this.metadata.description = description != null ? description : "";
            return this;
        }

        public Builder version(String version) {
            this.metadata.version = version != null && !version.isBlank() ? version : "1.0.0";
            return this;
        }

        public Builder author(String author) {
            this.metadata.author = author != null && !author.isBlank() ? author : "Unknown";
            return this;
        }

        public Builder targetResolution(String resolution) {
            this.metadata.targetResolution = resolution != null && !resolution.isBlank() ? resolution : "Any";
            return this;
        }

        public Builder mods(List<String> mods) {
            this.metadata.mods = mods != null ? new ArrayList<String>(mods) : new ArrayList();
            return this;
        }

        public Builder source(String source) {
            this.metadata.source = source != null ? source : "Community";
            return this;
        }

        public Builder createdNow() {
            this.metadata.createdDate = LocalDateTime.now().format(DATE_FORMAT);
            return this;
        }

        public ConfigMetadata build() {
            return this.metadata;
        }
    }
}

