/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.scamshield.ScamShieldChatHandler;
import com.github.kd_gaming1.packcore.util.HypixelEventUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;

public class ChatMessageInterceptor {
    private static final ChatMessageInterceptor INSTANCE = new ChatMessageInterceptor();
    private static final Pattern HYPIXEL_CHAT_PATTERN = Pattern.compile("(?:\\[\\d+\\]\\s*)?(?:\\[[^\\]]+\\]\\s*)*([a-zA-Z0-9_]+):\\s+(.+)$");

    private ChatMessageInterceptor() {
    }

    public static ChatMessageInterceptor getInstance() {
        return INSTANCE;
    }

    public void register() {
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> {
            if (overlay) {
                return;
            }
            if (!HypixelEventUtil.isHelloPacketReceived()) {
                if (PackCoreConfig.enableScamShieldDebugging) {
                    PackCore.LOGGER.info("[ScamShield] Skipping - not connected to Hypixel");
                }
                return;
            }
            String rawMessage = message.getString();
            if (rawMessage == null || rawMessage.isEmpty()) {
                return;
            }
            String cleanMessage = rawMessage.replaceAll("\u00a7.", "");
            ChatMessageData chatData = this.extractChatData(cleanMessage);
            if (chatData == null) {
                if (PackCoreConfig.enableScamShieldDebugging) {
                    PackCore.LOGGER.info("[ScamShield] [SERVER] Received message: '{}'", (Object)cleanMessage);
                }
                return;
            }
            if (cleanMessage.startsWith("[NPC]")) {
                if (PackCoreConfig.enableScamShieldDebugging) {
                    PackCore.LOGGER.info("[ScamShield] [NPC] Skipping CHAT message from NPC: '{}'", (Object)cleanMessage);
                }
                return;
            }
            if (PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield] [PLAYER: {}] Message: '{}'", (Object)chatData.sender, (Object)chatData.message);
            }
            ScamShieldChatHandler.getInstance().processChatMessage(chatData.message, chatData.sender);
        });
        ClientReceiveMessageEvents.CHAT.register((message, signedMessage, sender, params, timestamp) -> {
            if (!HypixelEventUtil.isHelloPacketReceived()) {
                if (PackCoreConfig.enableScamShieldDebugging) {
                    PackCore.LOGGER.info("[ScamShield] Skipping CHAT - not connected to Hypixel");
                }
                return;
            }
            String rawMessage = message.getString();
            if (rawMessage == null || rawMessage.isEmpty()) {
                return;
            }
            String cleanMessage = rawMessage.replaceAll("\u00a7.", "");
            if (cleanMessage.startsWith("[NPC]")) {
                if (PackCoreConfig.enableScamShieldDebugging) {
                    PackCore.LOGGER.info("[ScamShield] [NPC] Skipping CHAT message from NPC: '{}'", (Object)cleanMessage);
                }
                return;
            }
            if (sender != null && !cleanMessage.isEmpty()) {
                if (PackCoreConfig.enableScamShieldDebugging) {
                    PackCore.LOGGER.info("[ScamShield] [CHAT PLAYER: {}] Message: '{}'", (Object)sender, (Object)cleanMessage);
                }
                ScamShieldChatHandler.getInstance().processChatMessage(cleanMessage, String.valueOf(sender));
            }
        });
    }

    private ChatMessageData extractChatData(String cleanMessage) {
        if (this.isSystemMessage(cleanMessage)) {
            return null;
        }
        Matcher matcher = HYPIXEL_CHAT_PATTERN.matcher(cleanMessage);
        if (matcher.find()) {
            String sender = matcher.group(1);
            String messageContent = matcher.group(2);
            if (sender != null && messageContent != null && !messageContent.isEmpty()) {
                return new ChatMessageData(sender, messageContent);
            }
        }
        return null;
    }

    private boolean isSystemMessage(String cleanMessage) {
        return cleanMessage.startsWith("You are ") || cleanMessage.startsWith("Profile ID:") || cleanMessage.contains(" is holding [") || cleanMessage.contains(" joined the lobby!") || cleanMessage.contains(" has quit!") || cleanMessage.contains(" \u27a4 ");
    }

    public static class ChatMessageData {
        public final String sender;
        public final String message;

        public ChatMessageData(String sender, String message) {
            this.sender = sender;
            this.message = message;
        }
    }
}

