/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield;

import com.github.kd_gaming1.packcore.scamshield.detector.ConfidenceLevel;
import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import com.github.kd_gaming1.packcore.scamshield.detector.ScamCategory;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class ScamWarningMessageBuilder {
    public static class_2561 buildWarningMessage(DetectionResult result) {
        ConfidenceLevel level = result.getConfidenceLevel();
        ScamCategory category = result.getPrimaryCategory();
        return switch (level) {
            default -> throw new MatchException(null, null);
            case ConfidenceLevel.LOW -> ScamWarningMessageBuilder.buildLowConfidenceMessage(result, category);
            case ConfidenceLevel.MEDIUM -> ScamWarningMessageBuilder.buildMediumConfidenceMessage(result, category);
            case ConfidenceLevel.HIGH -> ScamWarningMessageBuilder.buildHighConfidenceMessage(result, category);
        };
    }

    private static class_2561 buildLowConfidenceMessage(DetectionResult result, ScamCategory category) {
        class_5250 message = class_2561.method_43470((String)"");
        message.method_10852((class_2561)class_2561.method_43470((String)"\n\u26a0 LOW CONFIDENCE \u26a0\n").method_27694(style -> style.method_36139(0xFFAA00).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"ScamShield Notice\n\n").method_27694(style -> style.method_36139(0xFFAA00).method_10982(Boolean.valueOf(true))));
        switch (category) {
            case DISCORD_VERIFY: 
            case PHISHING: {
                ScamWarningMessageBuilder.appendLowPhishing(message);
                break;
            }
            case FAKE_REWARD: {
                ScamWarningMessageBuilder.appendLowGiveaway(message);
                break;
            }
            case ACCOUNT_THEFT: {
                ScamWarningMessageBuilder.appendLowCoopIsland(message);
                break;
            }
            default: {
                ScamWarningMessageBuilder.appendLowBase(message);
            }
        }
        message.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        ScamWarningMessageBuilder.appendLowActions(message, result);
        message.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        return message;
    }

    private static void appendLowBase(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"This user sent unusual messages.\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\nIt might be harmless, but stay cautious:\n").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Don't click suspicious links\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Don't enter login info\n").method_27694(style -> style.method_36139(0xFFFF55)));
    }

    private static void appendLowPhishing(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"Possible suspicious link or verification request detected.\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\n\u26a0 Stay Safe:\n").method_27694(style -> style.method_36139(0xFFAA00).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Scams often ask you to verify through fake sites\n").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Don't click links from strangers\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Never enter your email or password\n").method_27694(style -> style.method_36139(0xFFFF55)));
    }

    private static void appendLowGiveaway(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"\"Too good to be true\" offer detected.\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"(Free ranks, giveaways, high-profit trades)\n\n").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)class_2561.method_43470((String)"Could be real, but scammers often:\n").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Promise big rewards to make you act fast\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Ask you to trade or visit their island first\n").method_27694(style -> style.method_36139(0xFFFF55)));
    }

    private static void appendLowCoopIsland(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"Co-op or island access mentioned.\n\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26a0 Warning:\n").method_27694(style -> style.method_36139(0xFFAA00).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"Some scammers use co-op to steal items or delete islands.\n\n").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)class_2561.method_43470((String)"Double-check before using ").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"/coopadd").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
    }

    private static void appendLowActions(class_5250 message, DetectionResult result) {
        message.method_10852((class_2561)class_2561.method_43470((String)"\ud83d\udcda Learn more: ").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)ScamWarningMessageBuilder.buildEducationButton());
        message.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2713 Trust this player? ").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)ScamWarningMessageBuilder.buildWhitelistButton(result.getSender()));
    }

    private static class_2561 buildMediumConfidenceMessage(DetectionResult result, ScamCategory category) {
        class_5250 message = class_2561.method_43470((String)"");
        message.method_10852((class_2561)class_2561.method_43470((String)"\n\ud83d\udfe0 MEDIUM CONFIDENCE \ud83d\udfe0\n").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"ScamShield Warning\n\n").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
        switch (category) {
            case DISCORD_VERIFY: 
            case PHISHING: {
                ScamWarningMessageBuilder.appendMediumPhishing(message);
                break;
            }
            case FAKE_REWARD: {
                ScamWarningMessageBuilder.appendMediumGiveaway(message);
                break;
            }
            case ACCOUNT_THEFT: {
                ScamWarningMessageBuilder.appendMediumCoopIsland(message);
                break;
            }
            case CUSTOM: {
                if (result.getTriggeredScamTypes().stream().anyMatch(type -> type.contains("trade") || type.contains("manipulation"))) {
                    ScamWarningMessageBuilder.appendMediumTrade(message);
                    break;
                }
                ScamWarningMessageBuilder.appendMediumBase(message);
                break;
            }
            default: {
                ScamWarningMessageBuilder.appendMediumBase(message);
            }
        }
        message.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        ScamWarningMessageBuilder.appendMediumActions(message, result);
        message.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        return message;
    }

    private static void appendMediumBase(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"Multiple messages match known scam patterns.\n\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\ud83d\uded1 DO NOT:\n").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Click suspicious links\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Log in on unfamiliar websites\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Enter email, password, or codes\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 \"Verify\" through Discord\n").method_27694(style -> style.method_36139(0xFFFF55)));
    }

    private static void appendMediumPhishing(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"Phishing/Verification scam detected.\n\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26a0 This scammer likely wants to:\n").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Make you \"verify\" through fake sites\n").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Steal your account login details\n\n").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2713 Only log in on official Microsoft/Minecraft pages\n").method_27694(style -> style.method_36139(0x55FF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2717 Never enter credentials elsewhere\n").method_27694(style -> style.method_36139(0xFF5555)));
    }

    private static void appendMediumGiveaway(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"\"Free rank\" or giveaway scam detected.\n\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"Common tactics:\n").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Ask you to join Discord first\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Request coins before \"rewarding\" you\n\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26a0 If it sounds too good to be true, it usually is.\n").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
    }

    private static void appendMediumTrade(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"Trade or \"item flip\" scam detected.\n\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"Red flags:\n").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Deals far better than market value\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Pressure to trade quickly\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Asking for payment before delivery\n\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26a0 Be cautious when paying before receiving items.\n").method_27694(style -> style.method_36139(0xFF5555)));
    }

    private static void appendMediumCoopIsland(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"Co-op access scam detected.\n\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26a0 Danger:\n").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"Scammers may ask you to run ").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)class_2561.method_43470((String)"/coopadd").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\nfor \"gifts\" or \"help.\"\n\n").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)class_2561.method_43470((String)"Once added, they can:\n").method_27694(style -> style.method_36139(0xFF5555)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Steal your items\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Delete your island\n\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26d4 Don't add players you don't personally know.\n").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
    }

    private static void appendMediumActions(class_5250 message, DetectionResult result) {
        message.method_10852((class_2561)class_2561.method_43470((String)"\ud83d\udcda Learn more: ").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)ScamWarningMessageBuilder.buildEducationButton());
        message.method_10852((class_2561)class_2561.method_43470((String)"\n\n"));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26a0 Whitelist only if you fully trust this player:\n").method_27694(style -> style.method_36139(0xFF5555)));
        message.method_10852((class_2561)class_2561.method_43470((String)("/scamshield whitelist add " + result.getSender())).method_27694(style -> style.method_36139(0xAAAAAA).method_10978(Boolean.valueOf(true))));
    }

    private static class_2561 buildHighConfidenceMessage(DetectionResult result, ScamCategory category) {
        class_5250 message = class_2561.method_43470((String)"");
        message.method_10852((class_2561)class_2561.method_43470((String)"\n\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\n").method_27694(style -> style.method_36139(0xFF0000).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"   CRITICAL SCAM ALERT   \n").method_27694(style -> style.method_36139(0xFF0000).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\u26d4\n\n").method_27694(style -> style.method_36139(0xFF0000).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\ud83d\udea8 NEARLY CERTAIN SCAM ATTEMPT \ud83d\udea8\n\n").method_27694(style -> style.method_36139(0xFF0000).method_10982(Boolean.valueOf(true))));
        switch (category) {
            case DISCORD_VERIFY: 
            case PHISHING: {
                ScamWarningMessageBuilder.appendHighPhishing(message);
                break;
            }
            case FAKE_REWARD: {
                ScamWarningMessageBuilder.appendHighGiveaway(message);
                break;
            }
            case ACCOUNT_THEFT: {
                ScamWarningMessageBuilder.appendHighCoopIsland(message);
                break;
            }
            case CUSTOM: {
                if (result.getTriggeredScamTypes().stream().anyMatch(type -> type.contains("trade") || type.contains("manipulation"))) {
                    ScamWarningMessageBuilder.appendHighTrade(message);
                    break;
                }
                ScamWarningMessageBuilder.appendHighBase(message);
                break;
            }
            default: {
                ScamWarningMessageBuilder.appendHighBase(message);
            }
        }
        message.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        ScamWarningMessageBuilder.appendHighActions(message, result);
        message.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        return message;
    }

    private static void appendHighBase(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"\ud83d\udea8 Scam Type: ").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"Account Theft\n\n").method_27694(style -> style.method_36139(0xFFFFFF).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26d4 STOP ALL COMMUNICATION NOW!\n\n").method_27694(style -> style.method_36139(0xFF0000).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"What they want:\n").method_27694(style -> style.method_36139(0xFFFF55).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Your login credentials\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Your 2FA codes\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Access to steal everything\n\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        ScamWarningMessageBuilder.appendRecommendedActions(message);
    }

    private static void appendHighPhishing(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"\ud83d\udea8 Scam Type: ").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"Discord/Verification Phishing\n\n").method_27694(style -> style.method_36139(0xFFFFFF).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26d4 STOP! DO NOT:\n").method_27694(style -> style.method_36139(0xFF0000).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Click any links\n").method_27694(style -> style.method_36139(0xFF5555)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 \"Verify\" your account\n").method_27694(style -> style.method_36139(0xFF5555)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Enter Microsoft login details\n\n").method_27694(style -> style.method_36139(0xFF5555)));
        ScamWarningMessageBuilder.appendRecommendedActions(message);
    }

    private static void appendHighGiveaway(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"\ud83d\udea8 Scam Type: ").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"Fake Giveaway/Free Rank\n\n").method_27694(style -> style.method_36139(0xFFFFFF).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26d4 STOP! DO NOT:\n").method_27694(style -> style.method_36139(0xFF0000).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Send any items or coins\n").method_27694(style -> style.method_36139(0xFF5555)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Log in to any links\n").method_27694(style -> style.method_36139(0xFF5555)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Join their Discord\n\n").method_27694(style -> style.method_36139(0xFF5555)));
        ScamWarningMessageBuilder.appendRecommendedActions(message);
    }

    private static void appendHighTrade(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"\ud83d\udea8 Scam Type: ").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"Trade/Item Flip Scam\n\n").method_27694(style -> style.method_36139(0xFFFFFF).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26d4 STOP THE TRADE!\n\n").method_27694(style -> style.method_36139(0xFF0000).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2705 Keep your items and coins safe\n").method_27694(style -> style.method_36139(0x55FF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2705 Report and block immediately\n\n").method_27694(style -> style.method_36139(0x55FF55)));
        ScamWarningMessageBuilder.appendRecommendedActions(message);
    }

    private static void appendHighCoopIsland(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"\ud83d\udea8 Scam Type: ").method_27694(style -> style.method_36139(0xFF5555).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"Co-op Access Theft\n\n").method_27694(style -> style.method_36139(0xFFFFFF).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u26d4 DO NOT RUN ").method_27694(style -> style.method_36139(0xFF0000).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"/coopadd").method_27694(style -> style.method_36139(0xFF0000).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"!\n\n").method_27694(style -> style.method_36139(0xFF0000).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"They can:\n").method_27694(style -> style.method_36139(0xFF5555)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Steal ALL your items\n").method_27694(style -> style.method_36139(0xFFFF55)));
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2022 Delete your island entirely\n\n").method_27694(style -> style.method_36139(0xFFFF55)));
        ScamWarningMessageBuilder.appendRecommendedActions(message);
    }

    private static void appendRecommendedActions(class_5250 message) {
        message.method_10852((class_2561)class_2561.method_43470((String)"\u2705 TAKE ACTION NOW:\n").method_27694(style -> style.method_36139(0x55FF55).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)"1. Stop replying immediately\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"2. Use ").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"/report").method_27694(style -> style.method_36139(0x55FF55).method_10982(Boolean.valueOf(true))));
        message.method_10852((class_2561)class_2561.method_43470((String)" to notify staff\n").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"3. Block with ").method_27694(style -> style.method_36139(0xFFFFFF)));
        message.method_10852((class_2561)class_2561.method_43470((String)"/ignore add <PlayerName>\n").method_27694(style -> style.method_36139(0x55FF55).method_10982(Boolean.valueOf(true))));
    }

    private static void appendHighActions(class_5250 message, DetectionResult result) {
        message.method_10852((class_2561)class_2561.method_43470((String)"\ud83d\udcda Learn how to protect your account:\n").method_27694(style -> style.method_36139(0xAAAAAA)));
        message.method_10852((class_2561)ScamWarningMessageBuilder.buildEducationButton());
    }

    private static class_5250 buildEducationButton() {
        return class_2561.method_43470((String)"[Open ScamShield Education Menu]").method_27694(style -> style.method_10977(class_124.field_1078).method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10609("/scamshield education")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"\u00a7aClick to learn about common scams\n\u00a77Run: /scamshield education"))));
    }

    private static class_5250 buildWhitelistButton(String playerName) {
        String command = "/scamshield whitelist add " + playerName;
        return class_2561.method_43470((String)"[Whitelist User]").method_27694(style -> style.method_10977(class_124.field_1060).method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10610(command)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("\u00a7aClick to whitelist \u00a7e" + playerName + "\n\u00a77This will skip future scam checks for this player.\n\u00a77Suggest: " + command)))));
    }
}

