/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.scamshield.detector.types;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.scamshield.context.ConversationContext;
import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import com.github.kd_gaming1.packcore.scamshield.detector.language.LanguageDatabase;
import com.github.kd_gaming1.packcore.scamshield.detector.language.TacticDefinition;
import com.github.kd_gaming1.packcore.scamshield.detector.types.ScamType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PhishingLanguageScam
implements ScamType {
    private boolean enabled = true;
    private final LanguageDatabase languageDB;
    private final Map<String, Set<String>> userDetectedTactics = new HashMap<String, Set<String>>();

    public PhishingLanguageScam() {
        this.languageDB = new LanguageDatabase();
        PackCore.LOGGER.info("[ScamShield] PhishingLanguageScam initialized with {} tactics", (Object)this.languageDB.getTactics().size());
    }

    @Override
    public String getId() {
        return "phishing_language";
    }

    @Override
    public String getDisplayName() {
        return "Phishing Language & Tactics";
    }

    @Override
    public void analyze(String message, String rawMessage, String sender, ConversationContext context, DetectionResult.Builder result) {
        if (!this.enabled) {
            return;
        }
        Map<String, TacticDefinition> tactics = this.languageDB.getTactics();
        if (tactics.isEmpty()) {
            return;
        }
        int totalScore = 0;
        HashSet<String> detectedTactics = new HashSet<String>();
        HashMap<String, Integer> tacticScores = new HashMap<String, Integer>();
        for (Map.Entry<String, TacticDefinition> entry : tactics.entrySet()) {
            String tacticId = entry.getKey();
            TacticDefinition tactic = entry.getValue();
            int tacticScore = tactic.analyze(message);
            if (tacticScore <= 0) continue;
            detectedTactics.add(tacticId);
            tacticScores.put(tacticId, tacticScore);
            totalScore += tacticScore;
            if (!PackCoreConfig.enableScamShieldDebugging) continue;
            PackCore.LOGGER.info("[ScamShield]   Tactic '{}' detected: +{} points", (Object)tacticId, (Object)tacticScore);
        }
        if (detectedTactics.size() >= 2) {
            int clusteringBonus = this.calculateClusteringBonus(detectedTactics, tacticScores);
            totalScore += clusteringBonus;
            if (PackCoreConfig.enableScamShieldDebugging && clusteringBonus > 0) {
                PackCore.LOGGER.info("[ScamShield]   Tactic clustering detected! {} tactics = +{} bonus", (Object)detectedTactics.size(), (Object)clusteringBonus);
            }
        }
        if (sender != null && !detectedTactics.isEmpty()) {
            this.userDetectedTactics.computeIfAbsent(sender.toLowerCase(), k -> new HashSet()).addAll(detectedTactics);
        }
        if (totalScore > 0) {
            double contextMultiplier = context.getSensitivityMultiplier(this.getId());
            totalScore = (int)((double)totalScore * contextMultiplier);
            result.addScamTypeContribution(this.getId(), totalScore);
            if (PackCoreConfig.enableScamShieldDebugging) {
                PackCore.LOGGER.info("[ScamShield] {} detected: +{} points (tactics: {}, context: {}x)", new Object[]{this.getDisplayName(), totalScore, detectedTactics, contextMultiplier});
            }
        }
    }

    private int calculateClusteringBonus(Set<String> detectedTactics, Map<String, Integer> tacticScores) {
        int size = detectedTactics.size();
        int bonus = 0;
        if (size == 2) {
            bonus = 10;
        } else if (size == 3) {
            bonus = 25;
        } else if (size >= 4) {
            bonus = 50;
        }
        if (detectedTactics.contains("authority") && detectedTactics.contains("credential_fishing")) {
            bonus += 40;
        }
        if (detectedTactics.contains("urgency") && detectedTactics.contains("scarcity")) {
            bonus += 20;
        }
        if (detectedTactics.contains("trust_building") && detectedTactics.contains("reciprocity")) {
            bonus += 25;
        }
        if (detectedTactics.contains("urgency") && detectedTactics.contains("authority") && detectedTactics.contains("credential_fishing")) {
            bonus += 60;
        }
        return bonus;
    }

    public Set<String> getUserTactics(String sender) {
        if (sender == null) {
            return Set.of();
        }
        return this.userDetectedTactics.getOrDefault(sender.toLowerCase(), Set.of());
    }

    public void clearUserTactics(String sender) {
        if (sender != null) {
            this.userDetectedTactics.remove(sender.toLowerCase());
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void reload() {
        this.languageDB.reload();
        PackCore.LOGGER.info("[ScamShield] {} reloaded language database", (Object)this.getDisplayName());
    }

    public LanguageDatabase getLanguageDatabase() {
        return this.languageDB;
    }
}

