/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.help.introduction;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.gui.help.BaseWizardPage;
import com.github.kd_gaming1.packcore.gui.help.WizardNavigator;
import com.github.kd_gaming1.packcore.lavendermd.CustomLavenderCompiler;
import com.github.kd_gaming1.packcore.util.MarkdownFileUtil;
import com.github.kd_gaming1.packcore.util.modpack.ModpackInfo;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.MarkdownProcessor;
import io.wispforest.lavendermd.feature.BasicFormattingFeature;
import io.wispforest.lavendermd.feature.BlockQuoteFeature;
import io.wispforest.lavendermd.feature.ColorFeature;
import io.wispforest.lavendermd.feature.ImageFeature;
import io.wispforest.lavendermd.feature.LinkFeature;
import io.wispforest.lavendermd.feature.ListFeature;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class IntroductionScreenPage
extends BaseWizardPage {
    private static final MarkdownProcessor<ParentComponent> MARKDOWN_PROCESSOR = new MarkdownProcessor(CustomLavenderCompiler::new, new MarkdownFeature[]{new BasicFormattingFeature(), new ColorFeature(), new LinkFeature(), new ListFeature(), new BlockQuoteFeature(), new ImageFeature()});
    private static final Map<String, ParentComponent> COMPONENT_CACHE = new ConcurrentHashMap<String, ParentComponent>();
    private final String welcomeMarkdown = MarkdownFileUtil.readMarkdownFile("Welcome.md");
    private final ModpackInfo modpackInfo = PackCore.getModpackInfo();

    public IntroductionScreenPage() {
        super(new BaseWizardPage.WizardPageInfo((class_2561)class_2561.method_43470((String)"Welcome"), 0, 5), class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"));
    }

    @Override
    protected void buildContent(FlowLayout contentContainer) {
        contentContainer.child((Component)this.createWelcomeHeader());
        contentContainer.child(this.createMarkdownSection());
    }

    @Override
    protected void buildContentRight(FlowLayout contentContainerRight) {
    }

    private FlowLayout createWelcomeHeader() {
        FlowLayout header = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6);
        class_5250 welcomeText = TextOps.concat((class_2561)TextOps.withColor((String)"Welcome to ", (int)0xFFFFFF), (class_2561)class_2561.method_43470((String)this.modpackInfo.getName()).method_10862(class_2583.field_24360.method_36139(-10496).method_10982(Boolean.TRUE)));
        LabelComponent welcomeTitle = Components.label((class_2561)welcomeText);
        LabelComponent subtitle = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"Let's get you set up for the best experience! Take 30 seconds and read through the welcome please.").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.TRUE))).color(Color.ofRgb((int)0xB9BBBE)).margins(Insets.of((int)2, (int)0, (int)2, (int)0)).sizing(Sizing.expand(), Sizing.content());
        header.child((Component)welcomeTitle).child((Component)subtitle);
        return header;
    }

    private ScrollContainer<FlowLayout> createMarkdownSection() {
        FlowLayout markdownWrapper = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(4);
        ParentComponent markdownComponent = COMPONENT_CACHE.computeIfAbsent(this.welcomeMarkdown, arg_0 -> MARKDOWN_PROCESSOR.process(arg_0));
        markdownWrapper.child((Component)markdownComponent);
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)markdownWrapper);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scrollContainer.scrollbarThiccness(6);
        scrollContainer.surface(Surface.flat((int)0x40000000).and(Surface.outline((int)0x30FFFFFF)));
        scrollContainer.padding(Insets.of((int)8));
        return scrollContainer;
    }

    @Override
    protected void onContinuePressed() {
        this.field_22787.method_1507(WizardNavigator.createWizardPage(1));
    }

    @Override
    protected boolean shouldShowStatusInfo() {
        return true;
    }
}

