/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util;

import com.github.kd_gaming1.packcore.util.ConfigFileOperations;
import com.github.kd_gaming1.packcore.util.ConfigFileUtils;
import com.github.kd_gaming1.packcore.util.copysystem.UnzipFiles;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoConfigApplicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoConfigApplicator.class);
    private static final Map<String, Integer> RESOLUTION_PRIORITY = Map.of("4k", 4, "1440p", 3, "1080p", 2, "720p", 1, "any", 0);

    public static boolean applyBestMatchingConfig(Path gameDir) {
        LOGGER.info("Starting automatic config application...");
        String detectedResolution = AutoConfigApplicator.detectResolution();
        LOGGER.info("Detected screen resolution: {}", (Object)detectedResolution);
        List<ConfigFileUtils.ConfigFile> allConfigs = ConfigFileUtils.getAllConfigs();
        if (allConfigs.isEmpty()) {
            LOGGER.warn("No configs available for automatic application");
            return false;
        }
        LOGGER.info("Found {} available configs", (Object)allConfigs.size());
        ConfigFileUtils.ConfigFile bestMatch = AutoConfigApplicator.findBestMatch(detectedResolution, allConfigs);
        if (bestMatch == null) {
            LOGGER.error("Could not find suitable config to apply");
            return false;
        }
        LOGGER.info("Selected config: {} ({})", (Object)bestMatch.getDisplayName(), (Object)(bestMatch.isOfficial() ? "Official" : "Custom"));
        return AutoConfigApplicator.applyConfigDirect(bestMatch, gameDir);
    }

    private static boolean applyConfigDirect(ConfigFileUtils.ConfigFile config, Path gameDir) {
        LOGGER.info("Applying config: {}", (Object)config.getDisplayName());
        try {
            Path backup = ConfigFileOperations.createBackup(gameDir);
            if (backup != null) {
                LOGGER.info("Backup created at: {}", (Object)backup);
                ConfigFileOperations.cleanOldBackups(gameDir, 5);
            }
            UnzipFiles unzipper = new UnzipFiles();
            unzipper.unzip(config.getPath().toString(), gameDir.toString(), (bytesProcessed, totalBytes, percentage) -> {
                if (percentage % 25 == 0) {
                    LOGGER.info("Extraction progress: {}%", (Object)percentage);
                }
            });
            ConfigFileUtils.saveCurrentConfig(config.getMetadata());
            LOGGER.info("Config applied successfully: {}", (Object)config.getDisplayName());
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to apply config", (Throwable)e);
            return false;
        }
    }

    private static String detectResolution() {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            int width = screenSize.width;
            int height = screenSize.height;
            LOGGER.debug("Screen dimensions: {}x{}", (Object)width, (Object)height);
            return AutoConfigApplicator.categorizeResolution(width, height);
        }
        catch (Exception e) {
            LOGGER.error("Failed to detect resolution, defaulting to 1080p", (Throwable)e);
            return "1080p";
        }
    }

    private static String categorizeResolution(int width, int height) {
        if (height >= 2160) {
            return "4k";
        }
        if (height >= 1440) {
            return "1440p";
        }
        if (height >= 1080) {
            return "1080p";
        }
        return "720p";
    }

    private static ConfigFileUtils.ConfigFile findBestMatch(String detectedResolution, List<ConfigFileUtils.ConfigFile> configs) {
        LOGGER.debug("Finding best match for resolution: {}", (Object)detectedResolution);
        LOGGER.info("Available configs:");
        for (ConfigFileUtils.ConfigFile config : configs) {
            LOGGER.info("  - {} | Resolution: {} | Official: {}", new Object[]{config.getDisplayName(), config.getMetadata().getTargetResolution(), config.isOfficial()});
        }
        ConfigFileUtils.ConfigFile selected = configs.stream().min(AutoConfigApplicator.createConfigComparator(detectedResolution)).orElse(null);
        if (selected != null) {
            LOGGER.info("Best match selected: {} (distance: {})", (Object)selected.getDisplayName(), (Object)AutoConfigApplicator.getResolutionDistance(detectedResolution, selected.getMetadata().getTargetResolution()));
        }
        return selected;
    }

    private static Comparator<ConfigFileUtils.ConfigFile> createConfigComparator(String targetResolution) {
        return Comparator.comparing(c -> !c.isOfficial()).thenComparing(c -> AutoConfigApplicator.getResolutionDistance(targetResolution, c.getMetadata().getTargetResolution())).thenComparing(c -> c.getDisplayName());
    }

    private static int getResolutionDistance(String target, String candidate) {
        String targetLower;
        if (candidate == null) {
            return 999;
        }
        String candidateLower = AutoConfigApplicator.normalizeResolution(candidate).toLowerCase();
        if (candidateLower.equals(targetLower = AutoConfigApplicator.normalizeResolution(target).toLowerCase())) {
            return 0;
        }
        if (candidateLower.equals("any")) {
            return 10;
        }
        int targetPriority = RESOLUTION_PRIORITY.getOrDefault(targetLower, 0);
        int candidatePriority = RESOLUTION_PRIORITY.getOrDefault(candidateLower, 0);
        return Math.abs(targetPriority - candidatePriority);
    }

    private static String normalizeResolution(String resolution) {
        if (resolution == null) {
            return "any";
        }
        String lower = resolution.toLowerCase().trim();
        if (lower.equals("4k") || lower.equals("1440p") || lower.equals("1080p") || lower.equals("720p") || lower.equals("any")) {
            return lower;
        }
        if (lower.contains("x")) {
            try {
                String[] parts = lower.split("x");
                if (parts.length == 2) {
                    int width = Integer.parseInt(parts[0].trim());
                    int height = Integer.parseInt(parts[1].trim());
                    return AutoConfigApplicator.categorizeResolution(width, height);
                }
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Could not parse resolution: {}", (Object)resolution);
            }
        }
        return "any";
    }
}

