/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util;

import com.github.kd_gaming1.packcore.gui.configscreen.util.FileTreeNode;
import com.github.kd_gaming1.packcore.util.ConfigFileOperations;
import com.github.kd_gaming1.packcore.util.ConfigMetadata;
import com.github.kd_gaming1.packcore.util.copysystem.AsyncZipFiles;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigExportManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigExportManager.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<String> HIDDEN_FOLDERS = Set.of("packcore", "logs", "crash-reports", "screenshots", ".git", ".minecraft", "saves", "assets", "mods", ".firmament");
    private static final Set<String> EXCLUDED_CONFIG_SUBFOLDERS = Set.of("firmament/profiles", "skyhanni/backup", "skyhanni/repo", "skyblocker/item-repo", "skyocean/data");
    private static final int MAX_TREE_DEPTH = 10;
    private static final int MAX_CHILDREN_PER_NODE = 100;
    private static final int BATCH_SIZE = 50;
    private final Path gameDir;
    private final Path exportDir;
    private final Map<Path, Long> sizeCache = new ConcurrentHashMap<Path, Long>();

    public ConfigExportManager() {
        this.gameDir = class_310.method_1551().field_1697.toPath();
        this.exportDir = this.gameDir.resolve("packcore/modpack_config/custom_configs");
        try {
            Files.createDirectories(this.exportDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create export directory", (Throwable)e);
        }
    }

    public FileTreeNode buildFileTree() {
        FileTreeNode root = new FileTreeNode(this.gameDir, "Game Directory", true);
        root.setExpanded(true);
        try (Stream<Path> entries = Files.list(this.gameDir);){
            List<Path> sortedEntries = entries.filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(path -> !this.isHidden((Path)path)).sorted(this.comparePaths()).limit(100L).toList();
            for (Path path2 : sortedEntries) {
                FileTreeNode node = this.createLazyNode(path2);
                if (node == null || node.isHidden()) continue;
                root.addChild(node);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to build file tree", (Throwable)e);
        }
        return root;
    }

    private FileTreeNode createLazyNode(Path path) {
        String fileName = path.getFileName().toString();
        boolean isDirectory = Files.isDirectory(path, new LinkOption[0]);
        FileTreeNode node = new FileTreeNode(path, fileName, isDirectory);
        if (this.isHidden(path)) {
            node.setHidden(true);
            return node;
        }
        if (isDirectory) {
            try (Stream<Path> children = Files.list(path);){
                boolean hasChildren = children.filter(child -> !this.isHidden((Path)child)).findAny().isPresent();
                node.setHasUnloadedChildren(hasChildren);
            }
            catch (IOException e) {
                LOGGER.debug("Could not check directory: {}", (Object)path);
            }
        }
        return node;
    }

    public void loadNodeChildren(FileTreeNode node) {
        if (!node.isDirectory() || node.isChildrenLoaded()) {
            return;
        }
        try (Stream<Path> children = Files.list(node.getPath());){
            List<Path> sortedChildren = children.filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(child -> !this.isHidden((Path)child)).sorted(this.comparePaths()).limit(100L).toList();
            for (Path childPath : sortedChildren) {
                FileTreeNode childNode = this.createLazyNode(childPath);
                if (childNode == null || childNode.isHidden()) continue;
                node.addChild(childNode);
            }
            node.setChildrenLoaded(true);
            node.setHasUnloadedChildren(false);
        }
        catch (IOException e) {
            LOGGER.debug("Could not list directory: {}", (Object)node.getPath());
        }
    }

    private boolean isHidden(Path path) {
        String name = path.getFileName().toString().toLowerCase();
        if (HIDDEN_FOLDERS.contains(name) || name.startsWith(".")) {
            return true;
        }
        Path relativePath = this.gameDir.relativize(path);
        String relativePathStr = relativePath.toString().replace("\\", "/");
        return EXCLUDED_CONFIG_SUBFOLDERS.stream().anyMatch(excluded -> relativePathStr.equals(excluded) || relativePathStr.startsWith(excluded + "/"));
    }

    private Comparator<Path> comparePaths() {
        return Comparator.comparing(p -> !Files.isDirectory(p, new LinkOption[0])).thenComparing(p -> p.getFileName().toString().toLowerCase());
    }

    public Set<Path> getPresetPaths(PresetType presetType) {
        HashSet<Path> paths = new HashSet<Path>();
        switch (presetType.ordinal()) {
            case 0: {
                this.addIfExists(paths, "config");
                break;
            }
            case 1: {
                this.addIfExists(paths, "options.txt");
                this.addIfExists(paths, "servers.dat");
                break;
            }
            case 2: {
                this.addIfExists(paths, "config");
                this.addIfExists(paths, "options.txt");
                this.addIfExists(paths, "servers.dat");
                break;
            }
            case 3: {
                paths.clear();
            }
        }
        return paths;
    }

    private void addIfExists(Set<Path> paths, String relativePath) {
        Path path = this.gameDir.resolve(relativePath);
        if (Files.exists(path, new LinkOption[0])) {
            paths.add(path);
        }
    }

    public long calculateSelectionSize(Set<Path> selectedPaths) {
        return selectedPaths.parallelStream().mapToLong(this::getCachedSize).sum();
    }

    private long getCachedSize(Path path) {
        return this.sizeCache.computeIfAbsent(path, p -> {
            block9: {
                Long l;
                block10: {
                    if (Files.isRegularFile(p, new LinkOption[0])) {
                        return Files.size(p);
                    }
                    if (!Files.isDirectory(p, new LinkOption[0])) break block9;
                    Stream<Path> paths = Files.walk(p, new FileVisitOption[0]);
                    try {
                        l = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).mapToLong(file -> {
                            try {
                                return Files.size(file);
                            }
                            catch (IOException e) {
                                return 0L;
                            }
                        }).sum();
                        if (paths == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (paths != null) {
                                try {
                                    paths.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LOGGER.debug("Could not calculate size for: {}", p);
                        }
                    }
                    paths.close();
                }
                return l;
            }
            return 0L;
        });
    }

    public List<String> scanInstalledMods() {
        ArrayList<String> mods = new ArrayList<String>();
        Path modsDir = this.gameDir.resolve("mods");
        if (Files.exists(modsDir, new LinkOption[0]) && Files.isDirectory(modsDir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(modsDir);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                    String name = p.getFileName().toString().toLowerCase();
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }).map(p -> p.getFileName().toString().replaceAll("\\.(jar|zip)$", "")).sorted().forEach(mods::add);
            }
            catch (IOException e) {
                LOGGER.error("Failed to scan mods folder", (Throwable)e);
            }
        }
        return mods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path exportConfigAsync(ExportRequest request, Consumer<String> progressCallback) throws IOException {
        this.validateExportRequest(request);
        Path tempDir = Files.createTempDirectory("packcore_export", new FileAttribute[0]);
        try {
            LOGGER.info("Starting async export for {} selected paths", (Object)request.selectedPaths.size());
            progressCallback.accept("Copying files...");
            this.copySelectedPathsAsync(request.selectedPaths, tempDir, progressCallback);
            progressCallback.accept("Creating metadata...");
            ConfigMetadata metadata = ConfigMetadata.builder().name(request.name).description(request.description).version(request.version).author(request.author).targetResolution(request.targetResolution).mods(request.includedMods).source("Community").createdNow().build();
            Path metadataPath = tempDir.resolve("packcore_metadata.json");
            Files.writeString(metadataPath, (CharSequence)GSON.toJson((Object)metadata), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            progressCallback.accept("Creating zip archive...");
            String zipFileName = this.generateZipFileName(request.name);
            Path zipPath = this.exportDir.resolve(zipFileName);
            AsyncZipFiles zipFiles = new AsyncZipFiles();
            CompletableFuture<Void> zipFuture = zipFiles.zipDirectoryAsync(tempDir.toFile(), zipPath.toString(), (bytesProcessed, totalBytes, percentage) -> progressCallback.accept(String.format("Zipping: %d%%", percentage)));
            zipFuture.join();
            progressCallback.accept("Export complete!");
            LOGGER.info("Config exported successfully to: {}", (Object)zipPath);
            Path path = zipPath;
            return path;
        }
        finally {
            CompletableFuture.runAsync(() -> {
                try {
                    ConfigFileOperations.deleteDirectory(tempDir);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to clean up temp directory", (Throwable)e);
                }
            });
        }
    }

    public Path exportConfig(ExportRequest request) throws IOException {
        return this.exportConfigAsync(request, message -> {});
    }

    private void validateExportRequest(ExportRequest request) {
        if (request.selectedPaths == null || request.selectedPaths.isEmpty()) {
            throw new IllegalArgumentException("No paths selected for export");
        }
        if (request.name == null || request.name.isBlank()) {
            throw new IllegalArgumentException("Config name is required");
        }
    }

    private void copySelectedPathsAsync(Set<Path> selectedPaths, Path targetDir, Consumer<String> progressCallback) throws IOException {
        int total = selectedPaths.size();
        int processed = 0;
        ArrayList<Path> pathList = new ArrayList<Path>(selectedPaths);
        for (int i = 0; i < pathList.size(); i += 50) {
            int end = Math.min(i + 50, pathList.size());
            List batch = pathList.subList(i, end);
            batch.parallelStream().forEach(selectedPath -> {
                try {
                    if (!Files.exists(selectedPath, new LinkOption[0])) {
                        LOGGER.warn("Selected path does not exist: {}", selectedPath);
                        return;
                    }
                    Path relativePath = this.gameDir.relativize((Path)selectedPath);
                    Path targetPath = targetDir.resolve(relativePath);
                    if (Files.isDirectory(selectedPath, new LinkOption[0])) {
                        ConfigFileOperations.copyDirectory(selectedPath, targetPath);
                    } else {
                        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                        Files.copy(selectedPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to copy: {}", selectedPath, (Object)e);
                }
            });
            processed = end;
            int percentage = processed * 100 / total;
            progressCallback.accept(String.format("Copying files: %d%%", percentage));
        }
    }

    private String generateZipFileName(String configName) {
        String sanitized = configName.replaceAll("[^a-zA-Z0-9\\-_]", "_");
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
        return sanitized + "_" + timestamp + ".zip";
    }

    public void openExportFolder() {
        try {
            Desktop.getDesktop().open(this.exportDir.toFile());
        }
        catch (Exception e) {
            LOGGER.error("Failed to open export folder", (Throwable)e);
        }
    }

    public static enum PresetType {
        MODS_ONLY("Mod Configs Only"),
        MINECRAFT_ONLY("MC Configs Only"),
        ALL_CONFIGS("Both Configs"),
        CLEAR("Clear All");

        private final String displayName;

        private PresetType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }

    public static class ExportRequest {
        public final Set<Path> selectedPaths;
        public final String name;
        public final String description;
        public final String version;
        public final String author;
        public final String targetResolution;
        public final List<String> includedMods;

        public ExportRequest(Set<Path> selectedPaths, String name, String description, String version, String author, String targetResolution, List<String> includedMods) {
            this.selectedPaths = selectedPaths;
            this.name = name;
            this.description = description;
            this.version = version;
            this.author = author;
            this.targetResolution = targetResolution;
            this.includedMods = includedMods != null ? includedMods : new ArrayList();
        }
    }
}

