/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util;

import com.github.kd_gaming1.packcore.util.ConfigMetadata;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileUtils.class);
    private static final Gson GSON = new Gson();
    public static final String METADATA_FILE = "packcore_metadata.json";
    public static final String OFFICIAL_CONFIGS_PATH = "packcore/modpack_config/official_configs";
    public static final String CUSTOM_CONFIGS_PATH = "packcore/modpack_config/custom_configs";

    public static ConfigMetadata getCurrentConfig() {
        Path gameDir = FabricLoader.getInstance().getGameDir();
        Path metadataPath = gameDir.resolve(METADATA_FILE);
        if (!Files.exists(metadataPath, new LinkOption[0])) {
            return ConfigFileUtils.createDefaultConfig();
        }
        try {
            String content = Files.readString(metadataPath, StandardCharsets.UTF_8);
            ConfigMetadata metadata = (ConfigMetadata)GSON.fromJson(content, ConfigMetadata.class);
            return metadata != null ? metadata : ConfigFileUtils.createDefaultConfig();
        }
        catch (JsonSyntaxException | IOException e) {
            LOGGER.error("Failed to read current config metadata", e);
            return ConfigFileUtils.createDefaultConfig();
        }
    }

    private static ConfigMetadata createDefaultConfig() {
        return ConfigMetadata.builder().name("Default Configuration").description("Stock Minecraft configuration").version("1.0.0").author("System").source("System").targetResolution("Any").build();
    }

    public static void saveCurrentConfig(ConfigMetadata metadata) throws IOException {
        Path gameDir = FabricLoader.getInstance().getGameDir();
        Path metadataPath = gameDir.resolve(METADATA_FILE);
        String json = GSON.toJson((Object)metadata);
        Files.writeString(metadataPath, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ConfigMetadata readMetadataFromZip(Path zipPath) {
        if (!Files.exists(zipPath, new LinkOption[0]) || !zipPath.toString().endsWith(".zip")) {
            LOGGER.warn("Invalid zip path: {}", (Object)zipPath);
            return null;
        }
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            ConfigMetadata configMetadata;
            ZipEntry metadataEntry = zipFile.getEntry(METADATA_FILE);
            if (metadataEntry == null) {
                LOGGER.debug("No metadata found in zip: {}", (Object)zipPath);
                ConfigMetadata configMetadata2 = ConfigFileUtils.createFallbackMetadata(zipPath);
                return configMetadata2;
            }
            try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(metadataEntry), StandardCharsets.UTF_8);){
                ConfigMetadata metadata = (ConfigMetadata)GSON.fromJson((Reader)reader, ConfigMetadata.class);
                configMetadata = metadata != null ? metadata : ConfigFileUtils.createFallbackMetadata(zipPath);
            }
            return configMetadata;
        }
        catch (JsonSyntaxException | IOException e) {
            LOGGER.error("Failed to read metadata from zip: {}", (Object)zipPath, (Object)e);
            return ConfigFileUtils.createFallbackMetadata(zipPath);
        }
    }

    private static ConfigMetadata createFallbackMetadata(Path zipPath) {
        String fileName = zipPath.getFileName().toString();
        String displayName = fileName.endsWith(".zip") ? fileName.substring(0, fileName.length() - 4) : fileName;
        return ConfigMetadata.builder().name(displayName).description("No description available").version("Unknown").author("Unknown").source("Unknown").build();
    }

    public static List<ConfigFile> getAllConfigs() {
        ArrayList<ConfigFile> configs = new ArrayList<ConfigFile>();
        configs.addAll(ConfigFileUtils.getConfigs(OFFICIAL_CONFIGS_PATH, true));
        configs.addAll(ConfigFileUtils.getConfigs(CUSTOM_CONFIGS_PATH, false));
        return configs;
    }

    public static List<ConfigFile> getOfficialConfigs() {
        return ConfigFileUtils.getConfigs(OFFICIAL_CONFIGS_PATH, true);
    }

    public static List<ConfigFile> getCustomConfigs() {
        return ConfigFileUtils.getConfigs(CUSTOM_CONFIGS_PATH, false);
    }

    private static List<ConfigFile> getConfigs(String relativePath, boolean official) {
        ArrayList<ConfigFile> configs = new ArrayList<ConfigFile>();
        Path gameDir = FabricLoader.getInstance().getGameDir();
        Path configDir = gameDir.resolve(relativePath);
        if (!Files.exists(configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
                LOGGER.info("Created config directory: {}", (Object)configDir);
            }
            catch (IOException e) {
                LOGGER.error("Failed to create config directory: {}", (Object)configDir, (Object)e);
            }
            return configs;
        }
        try (Stream<Path> files = Files.list(configDir);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().toLowerCase().endsWith(".zip")).forEach(path -> {
                String fileName = path.getFileName().toString();
                ConfigMetadata metadata = ConfigFileUtils.readMetadataFromZip(path);
                if (metadata != null && official) {
                    metadata = ConfigMetadata.builder().name(metadata.getName()).description(metadata.getDescription()).version(metadata.getVersion()).author(metadata.getAuthor()).targetResolution(metadata.getTargetResolution()).mods(metadata.getMods()).source("Official").build();
                }
                configs.add(new ConfigFile(fileName, (Path)path, official, metadata));
            });
        }
        catch (IOException e) {
            LOGGER.error("Failed to read configs from: {}", (Object)configDir, (Object)e);
        }
        return configs;
    }

    public static boolean configExists(String fileName) {
        if (!((String)fileName).endsWith(".zip")) {
            fileName = (String)fileName + ".zip";
        }
        Path gameDir = FabricLoader.getInstance().getGameDir();
        Path officialPath = gameDir.resolve(OFFICIAL_CONFIGS_PATH).resolve((String)fileName);
        Path customPath = gameDir.resolve(CUSTOM_CONFIGS_PATH).resolve((String)fileName);
        return Files.exists(officialPath, new LinkOption[0]) || Files.exists(customPath, new LinkOption[0]);
    }

    public static boolean deleteConfig(ConfigFile config) {
        if (config == null || config.isOfficial()) {
            return false;
        }
        try {
            Files.deleteIfExists(config.getPath());
            LOGGER.info("Deleted config: {}", (Object)config.getPath());
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete config: {}", (Object)config.getPath(), (Object)e);
            return false;
        }
    }

    public static class ConfigFile {
        private final String fileName;
        private final Path path;
        private final boolean official;
        private final ConfigMetadata metadata;

        public ConfigFile(String fileName, Path path, boolean official, ConfigMetadata metadata) {
            this.fileName = fileName;
            this.path = path;
            this.official = official;
            this.metadata = metadata != null ? metadata : new ConfigMetadata();
        }

        public String getFileName() {
            return this.fileName;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isOfficial() {
            return this.official;
        }

        public ConfigMetadata getMetadata() {
            return this.metadata;
        }

        public String getDisplayName() {
            if (this.metadata != null && this.metadata.isValid()) {
                return this.metadata.getDisplayName();
            }
            return this.fileName.endsWith(".zip") ? this.fileName.substring(0, this.fileName.length() - 4) : this.fileName;
        }
    }
}

