/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.config;

import com.github.kd_gaming1.packcore.util.config.PerformanceProfileUtil;
import java.io.IOException;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.gui.SodiumGameOptions;
import net.caffeinemc.mods.sodium.client.render.chunk.DeferMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodiumIntegration {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");

    public static boolean applyProfile(PerformanceProfileUtil.PerformanceProfile profile) {
        try {
            SodiumGameOptions options = SodiumClientMod.options();
            if (options.isReadOnly()) {
                LOGGER.warn("Sodium config is read-only, cannot apply profile");
                return false;
            }
            switch (profile) {
                case PERFORMANCE: {
                    SodiumIntegration.applyPerformanceSettings(options);
                    break;
                }
                case BALANCED: {
                    SodiumIntegration.applyBalancedSettings(options);
                    break;
                }
                case QUALITY: 
                case SHADERS: {
                    SodiumIntegration.applyQualitySettings(options);
                    break;
                }
                default: {
                    LOGGER.warn("Unknown profile: {}", (Object)profile);
                    return false;
                }
            }
            SodiumGameOptions.writeToDisk((SodiumGameOptions)options);
            LOGGER.debug("Sodium profile '{}' applied successfully", (Object)profile.name());
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to save Sodium configuration", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error applying Sodium profile", (Throwable)e);
            return false;
        }
    }

    public static boolean restoreDefaults() {
        try {
            SodiumClientMod.restoreDefaultOptions();
            LOGGER.debug("Sodium default settings restored");
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to restore Sodium defaults", (Throwable)e);
            return false;
        }
    }

    private static void applyPerformanceSettings(SodiumGameOptions options) {
        options.quality.weatherQuality = SodiumGameOptions.WeatherQuality.FAST;
        options.quality.leavesQuality = SodiumGameOptions.LeavesQuality.FAST;
        options.quality.enableVignette = true;
        options.advanced.enableMemoryTracing = false;
        options.advanced.useAdvancedStagingBuffers = true;
        options.advanced.cpuRenderAheadLimit = 3;
        options.performance.chunkBuilderThreads = 0;
        options.performance.chunkBuildDeferMode = DeferMode.ALWAYS;
        options.performance.animateOnlyVisibleTextures = true;
        options.performance.useEntityCulling = true;
        options.performance.useFogOcclusion = true;
        options.performance.useBlockFaceCulling = true;
        options.performance.useNoErrorGLContext = true;
        LOGGER.debug("Applied Sodium performance settings");
    }

    private static void applyBalancedSettings(SodiumGameOptions options) {
        options.quality.weatherQuality = SodiumGameOptions.WeatherQuality.DEFAULT;
        options.quality.leavesQuality = SodiumGameOptions.LeavesQuality.DEFAULT;
        options.quality.enableVignette = true;
        options.advanced.enableMemoryTracing = false;
        options.advanced.useAdvancedStagingBuffers = true;
        options.advanced.cpuRenderAheadLimit = 3;
        options.performance.chunkBuilderThreads = 0;
        options.performance.chunkBuildDeferMode = DeferMode.ALWAYS;
        options.performance.animateOnlyVisibleTextures = true;
        options.performance.useEntityCulling = true;
        options.performance.useFogOcclusion = true;
        options.performance.useBlockFaceCulling = true;
        options.performance.useNoErrorGLContext = true;
        LOGGER.debug("Applied Sodium balanced settings");
    }

    private static void applyQualitySettings(SodiumGameOptions options) {
        options.quality.weatherQuality = SodiumGameOptions.WeatherQuality.FANCY;
        options.quality.leavesQuality = SodiumGameOptions.LeavesQuality.FANCY;
        options.quality.enableVignette = true;
        options.advanced.enableMemoryTracing = false;
        options.advanced.useAdvancedStagingBuffers = true;
        options.advanced.cpuRenderAheadLimit = 3;
        options.performance.chunkBuilderThreads = 0;
        options.performance.chunkBuildDeferMode = DeferMode.ALWAYS;
        options.performance.animateOnlyVisibleTextures = true;
        options.performance.useEntityCulling = true;
        options.performance.useFogOcclusion = true;
        options.performance.useBlockFaceCulling = true;
        options.performance.useNoErrorGLContext = true;
        LOGGER.debug("Applied Sodium quality settings");
    }
}

