/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.configscreen;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.gui.configscreen.ModpackConfigMenuScreen;
import com.github.kd_gaming1.packcore.gui.ui.UITheme;
import com.github.kd_gaming1.packcore.gui.util.UiSurfaces;
import com.github.kd_gaming1.packcore.util.BackupCompletionNotifier;
import com.github.kd_gaming1.packcore.util.BackupManager;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.OverlayContainer;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupManagementScreen
extends BaseOwoScreen<FlowLayout> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"packcore");
    private BackupManager.BackupInfo selectedBackup = null;
    private FlowLayout infoPanel;
    private FlowLayout rootComponent;
    private FlowLayout sidebarContent;
    private OverlayContainer<FlowLayout> currentOverlay = null;
    private FlowLayout progressDialog = null;
    private LabelComponent progressLabel = null;
    private Map<BackupManager.BackupInfo, FlowLayout> entryComponents = new HashMap<BackupManager.BackupInfo, FlowLayout>();
    private volatile boolean operationInBackground = false;
    private volatile String currentOperationName = "";
    private volatile boolean isRestoreOperation = false;

    @NotNull
    protected OwoUIAdapter createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        this.rootComponent = rootComponent;
        rootComponent.surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"), 1920, 1082));
        rootComponent.padding(Insets.of((int)8));
        rootComponent.child((Component)this.createHeader());
        rootComponent.child((Component)this.createMainContent());
    }

    private FlowLayout createHeader() {
        FlowLayout header = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)50));
        header.gap(8);
        header.verticalAlignment(VerticalAlignment.CENTER);
        header.child((Component)Components.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/assets/sbe_logo.png"), (int)0, (int)0, (int)40, (int)40, (int)40, (int)40));
        header.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Backup Manager - " + PackCore.getModpackInfo().getName())).method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(UITheme.color(0xFFFFFF)));
        FlowLayout backContainer = Containers.horizontalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.content());
        backContainer.horizontalAlignment(HorizontalAlignment.RIGHT);
        backContainer.child(Components.button((class_2561)class_2561.method_43470((String)"Back"), btn -> class_310.method_1551().method_1507((class_437)new ModpackConfigMenuScreen())).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/previous.png"), (int)0, (int)0, (int)90, (int)57)).sizing(Sizing.fixed((int)90), Sizing.fixed((int)19)));
        header.child((Component)backContainer);
        return header;
    }

    private FlowLayout createMainContent() {
        FlowLayout mainContent = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand());
        mainContent.gap(8);
        mainContent.child((Component)this.createSidebar());
        mainContent.child((Component)this.createInfoPanel());
        return mainContent;
    }

    private FlowLayout createSidebar() {
        FlowLayout sidebar = Containers.verticalFlow((Sizing)Sizing.fill((int)35), (Sizing)Sizing.expand());
        sidebar.gap(8);
        sidebar.surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/notif_box.png"), 607, 755));
        sidebar.padding(Insets.of((int)12));
        int guiScale = (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        int padding = guiScale <= 2 ? 16 : 8;
        Component infoLabel = Components.label((class_2561)class_2561.method_43470((String)"Manage your configuration backups. Auto backups are created before applying new configs.")).color(UITheme.color(0xFFFFFF)).sizing(Sizing.fill((int)95), Sizing.content());
        FlowLayout infoContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        infoContainer.padding(Insets.of((int)padding, (int)0, (int)padding, (int)0));
        infoContainer.child(infoLabel);
        sidebar.child((Component)infoContainer);
        this.sidebarContent = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content());
        this.sidebarContent.gap(8);
        this.rebuildSidebarContent();
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)this.sidebarContent);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        sidebar.child((Component)scrollContainer);
        FlowLayout buttonContainer = Containers.ltrTextFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttonContainer.gap(4);
        buttonContainer.horizontalAlignment(HorizontalAlignment.CENTER);
        buttonContainer.child(Components.button((class_2561)class_2561.method_43470((String)"Create Backup"), btn -> this.showCreateBackupDialog()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)90, (int)57)).sizing(Sizing.fixed((int)90), Sizing.fixed((int)19)).margins(Insets.bottom((int)4)));
        buttonContainer.child(Components.button((class_2561)class_2561.method_43470((String)"Open Folder"), btn -> BackupManager.openBackupsFolder()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)90, (int)57)).sizing(Sizing.fixed((int)90), Sizing.fixed((int)19)).margins(Insets.bottom((int)4)));
        buttonContainer.child(Components.button((class_2561)class_2561.method_43470((String)"Refresh"), btn -> this.refreshBackupsList()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)90, (int)57)).sizing(Sizing.fixed((int)90), Sizing.fixed((int)19)).margins(Insets.bottom((int)4)));
        sidebar.child((Component)buttonContainer);
        return sidebar;
    }

    private void rebuildSidebarContent() {
        this.sidebarContent.clearChildren();
        this.entryComponents.clear();
        this.showLoadingInSidebar();
        BackupManager.getBackupsAsync().thenAccept(allBackups -> class_310.method_1551().execute(() -> {
            this.sidebarContent.clearChildren();
            List<BackupManager.BackupInfo> manualBackups = allBackups.stream().filter(b -> b.type == BackupManager.BackupType.MANUAL).toList();
            List<BackupManager.BackupInfo> autoBackups = allBackups.stream().filter(b -> b.type == BackupManager.BackupType.AUTO).toList();
            this.sidebarContent.child((Component)this.createBackupSection("Manual Backups", manualBackups, true));
            this.sidebarContent.child((Component)this.createBackupSection("Auto Backups", autoBackups, false));
        }));
    }

    private void showLoadingInSidebar() {
        this.sidebarContent.clearChildren();
        FlowLayout loading = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        loading.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Loading backups...")).color(UITheme.color(0xB9BBBE)));
        this.sidebarContent.child((Component)loading);
    }

    private FlowLayout createBackupSection(String title, List<BackupManager.BackupInfo> backups, boolean isManual) {
        FlowLayout section = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand((int)(isManual ? 45 : 50)));
        section.gap(4);
        section.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-10496)));
        section.padding(Insets.of((int)8));
        section.child((Component)Components.label((class_2561)class_2561.method_43470((String)title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(0xFFFFFF)));
        FlowLayout listContent = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        listContent.gap(2);
        if (backups.isEmpty()) {
            listContent.child((Component)Components.label((class_2561)class_2561.method_43470((String)"No backups found")).color(UITheme.color(0xB9BBBE)));
        } else {
            for (BackupManager.BackupInfo backup : backups) {
                listContent.child((Component)this.createBackupEntry(backup));
            }
        }
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)listContent);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        section.child((Component)scrollContainer);
        return section;
    }

    private FlowLayout createBackupEntry(BackupManager.BackupInfo backup) {
        FlowLayout entry = Containers.verticalFlow((Sizing)Sizing.fill((int)95), (Sizing)Sizing.content());
        entry.gap(2);
        entry.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811)));
        entry.padding(Insets.of((int)6));
        String displayTitle = backup.title != null && !backup.title.isEmpty() ? backup.title : backup.configName;
        entry.child((Component)Components.label((class_2561)class_2561.method_43470((String)displayTitle)).color(UITheme.color(0xFFFFFF)));
        FlowLayout badges = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        badges.gap(4);
        badges.child((Component)Components.label((class_2561)class_2561.method_43470((String)backup.type.getDisplayName())).color(UITheme.color(backup.type == BackupManager.BackupType.MANUAL ? -11353062 : -348908)));
        badges.child((Component)Components.label((class_2561)class_2561.method_43470((String)("v" + backup.configVersion))).color(UITheme.color(0xB9BBBE)));
        entry.child((Component)badges);
        this.entryComponents.put(backup, entry);
        entry.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.selectBackup(backup);
            return true;
        });
        entry.mouseEnter().subscribe(() -> {
            if (this.selectedBackup != backup) {
                entry.surface(Surface.flat((int)-1069925830).and(Surface.outline((int)-10496)));
            }
        });
        entry.mouseLeave().subscribe(() -> {
            if (this.selectedBackup != backup) {
                entry.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811)));
            }
        });
        return entry;
    }

    private FlowLayout createInfoPanel() {
        this.infoPanel = Containers.verticalFlow((Sizing)Sizing.fill((int)65), (Sizing)Sizing.expand());
        this.infoPanel.gap(8);
        this.infoPanel.surface(UiSurfaces.stretched(class_2960.method_60655((String)"packcore", (String)"textures/gui/menu/info_box.png"), 1142, 934));
        this.infoPanel.padding(Insets.of((int)14));
        this.showEmptyState();
        return this.infoPanel;
    }

    private void showEmptyState() {
        this.infoPanel.clearChildren();
        this.infoPanel.horizontalAlignment(HorizontalAlignment.CENTER);
        this.infoPanel.verticalAlignment(VerticalAlignment.CENTER);
        this.infoPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Select a backup to view details")).color(UITheme.color(0xB9BBBE)));
    }

    private void selectBackup(BackupManager.BackupInfo backup) {
        if (this.selectedBackup != null && this.entryComponents.containsKey(this.selectedBackup)) {
            FlowLayout previousEntry = this.entryComponents.get(this.selectedBackup);
            previousEntry.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-11184811)));
        }
        this.selectedBackup = backup;
        if (this.entryComponents.containsKey(backup)) {
            FlowLayout currentEntry = this.entryComponents.get(backup);
            currentEntry.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-10496)));
        }
        this.showBackupDetails();
    }

    private void showBackupDetails() {
        if (this.selectedBackup == null) {
            return;
        }
        this.infoPanel.clearChildren();
        this.infoPanel.horizontalAlignment(HorizontalAlignment.LEFT);
        this.infoPanel.verticalAlignment(VerticalAlignment.TOP);
        int guiScale = (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        int padding = guiScale <= 2 ? 6 : 0;
        String headerText = this.selectedBackup.title != null && !this.selectedBackup.title.isEmpty() ? this.selectedBackup.title : this.selectedBackup.configName;
        this.infoPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)headerText).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)).margins(Insets.of((int)padding, (int)0, (int)0, (int)0)));
        FlowLayout infoBox = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        infoBox.gap(4);
        infoBox.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-11184811)));
        infoBox.padding(Insets.of((int)8));
        infoBox.child((Component)this.createInfoRow("Type:", this.selectedBackup.type.getDisplayName()));
        infoBox.child((Component)this.createInfoRow("Config:", this.selectedBackup.configName));
        infoBox.child((Component)this.createInfoRow("Version:", this.selectedBackup.configVersion));
        infoBox.child((Component)this.createInfoRow("Created:", this.formatTimestamp(this.selectedBackup.timestamp)));
        infoBox.child((Component)this.createInfoRow("Size:", this.formatSize(this.selectedBackup.sizeBytes)));
        infoBox.child((Component)this.createInfoRow("Backup ID:", this.selectedBackup.backupId));
        this.infoPanel.child((Component)infoBox);
        if (this.selectedBackup.description != null && !this.selectedBackup.description.trim().isEmpty()) {
            this.infoPanel.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Description:").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
            this.infoPanel.child(Components.label((class_2561)class_2561.method_43470((String)this.selectedBackup.description)).color(UITheme.color(0xFFFFFF)).sizing(Sizing.fill((int)95), Sizing.content()));
        }
        FlowLayout warningBox = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        warningBox.gap(4);
        warningBox.surface(Surface.flat((int)-1067699433).and(Surface.outline((int)-348908)));
        warningBox.padding(Insets.of((int)12));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 Restore Information").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-348908)));
        warningBox.child(Components.label((class_2561)class_2561.method_43470((String)"Restoring will replace current files. An auto-backup will be created first.")).color(UITheme.color(0xFFFFFF)).sizing(Sizing.fill((int)95), Sizing.content()));
        this.infoPanel.child((Component)warningBox);
        FlowLayout buttonPanel = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttonPanel.gap(8);
        buttonPanel.horizontalAlignment(HorizontalAlignment.CENTER);
        buttonPanel.child(Components.button((class_2561)class_2561.method_43470((String)"Restore Backup"), btn -> this.showRestoreConfirmation()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        if (this.selectedBackup.type == BackupManager.BackupType.MANUAL) {
            buttonPanel.child(Components.button((class_2561)class_2561.method_43470((String)"Delete"), btn -> this.showDeleteConfirmation()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        }
        this.infoPanel.child((Component)buttonPanel);
    }

    private FlowLayout createInfoRow(String label, String value) {
        FlowLayout row = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        row.gap(8);
        row.child(Components.label((class_2561)class_2561.method_43470((String)label)).color(UITheme.color(0xB9BBBE)).sizing(Sizing.fixed((int)80), Sizing.content()));
        row.child((Component)Components.label((class_2561)class_2561.method_43470((String)value)).color(UITheme.color(0xFFFFFF)));
        return row;
    }

    private String formatTimestamp(String isoTimestamp) {
        try {
            return isoTimestamp.replace('T', ' ').substring(0, Math.min(isoTimestamp.length(), 19));
        }
        catch (Exception e) {
            return isoTimestamp;
        }
    }

    private String formatSize(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return String.format("%.1f KB", (double)bytes / 1024.0);
        }
        return String.format("%.1f MB", (double)bytes / 1048576.0);
    }

    private void showCreateBackupDialog() {
        FlowLayout popup = Containers.verticalFlow((Sizing)Sizing.fixed((int)450), (Sizing)Sizing.content());
        popup.gap(12);
        popup.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-10496)));
        popup.padding(Insets.of((int)20));
        popup.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Create Manual Backup").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)));
        popup.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Title:*")).color(UITheme.color(0xFFFFFF)));
        TextBoxComponent titleField = Components.textBox((Sizing)Sizing.fill((int)95), (String)"");
        titleField.method_47404((class_2561)class_2561.method_43470((String)"Enter backup title"));
        popup.child((Component)titleField);
        popup.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Description (optional):")).color(UITheme.color(0xFFFFFF)));
        TextBoxComponent descriptionField = Components.textBox((Sizing)Sizing.fill((int)95), (String)"");
        descriptionField.method_47404((class_2561)class_2561.method_43470((String)"Additional details about this backup"));
        popup.child((Component)descriptionField);
        FlowLayout buttons = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttons.gap(12);
        buttons.horizontalAlignment(HorizontalAlignment.CENTER);
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Create"), btn -> {
            String title = titleField.method_1882().trim();
            String description = descriptionField.method_1882().trim();
            this.closeOverlay();
            this.performCreateBackup(title.isEmpty() ? null : title, description.isEmpty() ? null : description);
        }).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.closeOverlay()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        popup.child((Component)buttons);
        this.showOverlay(popup);
    }

    private void performCreateBackup(String title, String description) {
        String finalTitle;
        this.currentOperationName = finalTitle = title != null ? title : "Manual backup - " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm"));
        this.operationInBackground = false;
        this.isRestoreOperation = false;
        this.showBackupWarningDialog(finalTitle, description);
    }

    private void showBackupWarningDialog(String title, String description) {
        FlowLayout dialogContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)400), (Sizing)Sizing.content());
        dialogContainer.surface(Surface.flat((int)-14013910).and(Surface.outline((int)-10496)));
        dialogContainer.padding(Insets.of((int)16));
        dialogContainer.positioning(Positioning.absolute((int)((this.field_22789 - 400) / 2), (int)((this.field_22790 - 200) / 2))).zIndex(10);
        dialogContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Backup Notice")).color(UITheme.color(-10496)).margins(Insets.bottom((int)8)));
        FlowLayout warningText = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        warningText.gap(4);
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 Important Notice:")).color(UITheme.color(0xFFFFFF)).margins(Insets.bottom((int)4)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 The backup will run in the background")).color(UITheme.color(0xFFFFFF)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 A progress indicator will show the status")).color(UITheme.color(0xFFFFFF)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 You can continue using the interface")).color(UITheme.color(0xFFFFFF)).margins(Insets.bottom((int)8)));
        dialogContainer.child((Component)warningText);
        FlowLayout buttonRow = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttonRow.gap(8);
        buttonRow.horizontalAlignment(HorizontalAlignment.CENTER);
        buttonRow.child(Components.button((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.rootComponent.removeChild((Component)dialogContainer)).sizing(Sizing.fixed((int)80), Sizing.fixed((int)20)));
        buttonRow.child(Components.button((class_2561)class_2561.method_43470((String)"Continue"), btn -> {
            this.rootComponent.removeChild((Component)dialogContainer);
            this.executeBackupCreation(title, description);
        }).sizing(Sizing.fixed((int)120), Sizing.fixed((int)20)));
        dialogContainer.child((Component)buttonRow);
        this.rootComponent.child((Component)dialogContainer);
    }

    private void executeBackupCreation(String title, String description) {
        this.operationInBackground = false;
        this.showProgressDialog("Creating Backup", "Preparing backup...");
        ((CompletableFuture)BackupManager.createManualBackupAsync(title, description, this::updateProgress).thenAccept(backupPath -> class_310.method_1551().execute(() -> {
            this.closeProgressDialog();
            this.refreshBackupsList();
            BackupCompletionNotifier.notifyBackupComplete(this.currentOperationName, backupPath, false);
            if (class_310.method_1551().field_1755 == this) {
                try {
                    class_156.method_668().method_672(backupPath.getParent().toFile());
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to auto-open backup folder", (Throwable)e);
                }
            }
        }))).exceptionally(throwable -> {
            class_310.method_1551().execute(() -> {
                this.closeProgressDialog();
                LOGGER.error("Failed to create backup", throwable);
                this.showErrorDialog("Backup failed: " + throwable.getMessage());
            });
            return null;
        });
    }

    private void showRestoreConfirmation() {
        if (this.selectedBackup == null) {
            return;
        }
        FlowLayout popup = Containers.verticalFlow((Sizing)Sizing.fixed((int)500), (Sizing)Sizing.content());
        popup.gap(12);
        popup.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-348908)));
        popup.padding(Insets.of((int)20));
        FlowLayout headerRow = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        headerRow.gap(8);
        headerRow.verticalAlignment(VerticalAlignment.CENTER);
        headerRow.child(Components.label((class_2561)class_2561.method_43470((String)"\u26a0")).color(UITheme.color(-348908)).sizing(Sizing.fixed((int)24), Sizing.content()));
        headerRow.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Restore Backup?").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-348908)));
        popup.child((Component)headerRow);
        popup.child((Component)Components.label((class_2561)class_2561.method_43470((String)("Backup: " + this.selectedBackup.getDisplayName())).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(0xFFFFFF)));
        FlowLayout warningBox = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        warningBox.gap(4);
        warningBox.surface(Surface.flat((int)-1070978518).and(Surface.outline((int)-348908)));
        warningBox.padding(Insets.of((int)12));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"This will:")).color(UITheme.color(0xFFFFFF)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Replace your current configuration files")).color(UITheme.color(0xB9BBBE)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Create an auto-backup of your current state")).color(UITheme.color(0xB9BBBE)));
        warningBox.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 Overwrite mod configs and settings")).color(UITheme.color(0xB9BBBE)));
        popup.child((Component)warningBox);
        FlowLayout buttons = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttons.gap(12);
        buttons.horizontalAlignment(HorizontalAlignment.CENTER);
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Restore"), btn -> {
            this.closeOverlay();
            this.showRestoreWarningDialog();
        }).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.closeOverlay()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        popup.child((Component)buttons);
        this.showOverlay(popup);
    }

    private void showRestoreWarningDialog() {
        FlowLayout dialogContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)400), (Sizing)Sizing.content());
        dialogContainer.surface(Surface.flat((int)-14013910).and(Surface.outline((int)-10496)));
        dialogContainer.padding(Insets.of((int)16));
        dialogContainer.positioning(Positioning.absolute((int)((this.field_22789 - 400) / 2), (int)((this.field_22790 - 200) / 2))).zIndex(10);
        dialogContainer.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Restore Notice")).color(UITheme.color(-10496)).margins(Insets.bottom((int)8)));
        FlowLayout warningText = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        warningText.gap(4);
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u26a0 Important Notice:")).color(UITheme.color(0xFFFFFF)).margins(Insets.bottom((int)4)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 The restore will run in the background")).color(UITheme.color(0xFFFFFF)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 A progress indicator will show the status")).color(UITheme.color(0xFFFFFF)));
        warningText.child((Component)Components.label((class_2561)class_2561.method_43470((String)"\u2022 You can continue using the interface")).color(UITheme.color(0xFFFFFF)).margins(Insets.bottom((int)8)));
        dialogContainer.child((Component)warningText);
        FlowLayout buttonRow = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttonRow.gap(8);
        buttonRow.horizontalAlignment(HorizontalAlignment.CENTER);
        buttonRow.child(Components.button((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.rootComponent.removeChild((Component)dialogContainer)).sizing(Sizing.fixed((int)80), Sizing.fixed((int)20)));
        buttonRow.child(Components.button((class_2561)class_2561.method_43470((String)"Continue Restore"), btn -> {
            this.rootComponent.removeChild((Component)dialogContainer);
            this.performRestore();
        }).sizing(Sizing.fixed((int)120), Sizing.fixed((int)20)));
        dialogContainer.child((Component)buttonRow);
        this.rootComponent.child((Component)dialogContainer);
    }

    private void performRestore() {
        if (this.selectedBackup == null) {
            return;
        }
        this.currentOperationName = this.selectedBackup.getDisplayName();
        this.operationInBackground = false;
        this.isRestoreOperation = true;
        this.showProgressDialog("Restoring Backup", "Preparing restore...");
        ((CompletableFuture)BackupManager.restoreBackupAsync(this.selectedBackup, this::updateProgress).thenAccept(success -> class_310.method_1551().execute(() -> {
            this.closeProgressDialog();
            if (success.booleanValue()) {
                this.refreshBackupsList();
                Path gameDir = class_310.method_1551().field_1697.toPath();
                Path backupsDir = gameDir.resolve("packcore/backups");
                Path backupPath = backupsDir.resolve(this.selectedBackup.backupId + ".zip");
                BackupCompletionNotifier.notifyBackupComplete(this.currentOperationName, backupPath, true);
            } else {
                this.showErrorDialog("Failed to restore backup!");
            }
        }))).exceptionally(throwable -> {
            class_310.method_1551().execute(() -> {
                this.closeProgressDialog();
                LOGGER.error("Failed to restore backup", throwable);
                this.showErrorDialog("Restore failed: " + throwable.getMessage());
            });
            return null;
        });
    }

    private void showDeleteConfirmation() {
        if (this.selectedBackup == null) {
            return;
        }
        FlowLayout popup = Containers.verticalFlow((Sizing)Sizing.fixed((int)400), (Sizing)Sizing.content());
        popup.gap(12);
        popup.surface(Surface.flat((int)-1072031206).and(Surface.outline((int)-45745)));
        popup.padding(Insets.of((int)20));
        popup.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Delete Backup?").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-45745)));
        popup.child((Component)Components.label((class_2561)class_2561.method_43470((String)this.selectedBackup.getDisplayName())).color(UITheme.color(0xFFFFFF)));
        popup.child((Component)Components.label((class_2561)class_2561.method_43470((String)"This action cannot be undone.")).color(UITheme.color(0xB9BBBE)));
        FlowLayout buttons = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttons.gap(12);
        buttons.horizontalAlignment(HorizontalAlignment.CENTER);
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Delete"), btn -> {
            this.closeOverlay();
            this.performDelete();
        }).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        buttons.child(Components.button((class_2561)class_2561.method_43470((String)"Cancel"), btn -> this.closeOverlay()).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/button.png"), (int)0, (int)0, (int)100, (int)60)).sizing(Sizing.fixed((int)100), Sizing.fixed((int)20)));
        popup.child((Component)buttons);
        this.showOverlay(popup);
    }

    private void performDelete() {
        if (this.selectedBackup == null) {
            return;
        }
        if (BackupManager.deleteBackup(this.selectedBackup)) {
            LOGGER.info("Deleted backup: {}", (Object)this.selectedBackup.getDisplayName());
            this.selectedBackup = null;
            this.refreshBackupsList();
        } else {
            this.showErrorDialog("Failed to delete backup");
        }
    }

    private void showProgressDialog(String title, String message) {
        this.progressDialog = Containers.verticalFlow((Sizing)Sizing.fixed((int)350), (Sizing)Sizing.content());
        this.progressDialog.surface(Surface.flat((int)-14013910).and(Surface.outline((int)-10496)));
        this.progressDialog.padding(Insets.of((int)16));
        this.progressDialog.positioning(Positioning.absolute((int)((this.field_22789 - 350) / 2), (int)((this.field_22790 - 150) / 2)));
        this.progressDialog.zIndex(20);
        this.progressDialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-10496)).margins(Insets.bottom((int)8)));
        this.progressLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(0xFFFFFF)).margins(Insets.bottom((int)12));
        this.progressDialog.child((Component)this.progressLabel);
        FlowLayout buttonRow = Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        buttonRow.gap(8);
        buttonRow.horizontalAlignment(HorizontalAlignment.CENTER);
        ButtonComponent backgroundButton = (ButtonComponent)Components.button((class_2561)class_2561.method_43470((String)"Continue in Background"), btn -> {
            this.operationInBackground = true;
            this.closeProgressDialog();
        }).horizontalSizing(Sizing.content());
        buttonRow.child((Component)backgroundButton);
        this.progressDialog.child((Component)buttonRow);
        this.rootComponent.child((Component)this.progressDialog);
    }

    private void updateProgress(String message) {
        class_310.method_1551().execute(() -> {
            if (this.progressLabel != null && !this.operationInBackground) {
                this.progressLabel.text((class_2561)class_2561.method_43470((String)message));
            }
        });
    }

    private void closeProgressDialog() {
        if (this.progressDialog != null) {
            this.rootComponent.removeChild((Component)this.progressDialog);
            this.progressDialog = null;
            this.progressLabel = null;
        }
    }

    private void showErrorDialog(String message) {
        FlowLayout errorDialog = Containers.verticalFlow((Sizing)Sizing.fixed((int)350), (Sizing)Sizing.content());
        errorDialog.surface(Surface.flat((int)-14013910).and(Surface.outline((int)-45745)));
        errorDialog.padding(Insets.of((int)16));
        errorDialog.positioning(Positioning.absolute((int)((this.field_22789 - 350) / 2), (int)((this.field_22790 - 120) / 2)));
        errorDialog.zIndex(20);
        errorDialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Error").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).color(UITheme.color(-45745)).margins(Insets.bottom((int)8)));
        errorDialog.child((Component)Components.label((class_2561)class_2561.method_43470((String)message)).color(UITheme.color(0xFFFFFF)).margins(Insets.bottom((int)12)));
        errorDialog.child(Components.button((class_2561)class_2561.method_43470((String)"OK"), btn -> this.rootComponent.removeChild((Component)errorDialog)).sizing(Sizing.fixed((int)80), Sizing.fixed((int)20)).horizontalSizing(Sizing.content()));
        this.rootComponent.child((Component)errorDialog);
    }

    private void showOverlay(FlowLayout popup) {
        this.currentOverlay = Containers.overlay((Component)popup);
        this.currentOverlay.positioning(Positioning.relative((int)50, (int)40));
        this.currentOverlay.zIndex(15);
        this.rootComponent.child(this.currentOverlay);
    }

    private void closeOverlay() {
        if (this.currentOverlay != null) {
            this.rootComponent.removeChild(this.currentOverlay);
            this.currentOverlay = null;
        }
    }

    private void refreshBackupsList() {
        this.selectedBackup = null;
        this.showEmptyState();
        this.rebuildSidebarContent();
    }

    public void method_25419() {
        BackupManager.shutdown();
        super.method_25419();
    }
}

