/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.help;

import com.github.kd_gaming1.packcore.PackCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WizardDataManager {
    private static WizardDataManager instance;
    private String optimizationProfile = "";
    private final List<String> resourcePacksOrdered = new ArrayList<String>();
    private String tabDesign = "";
    private boolean configurationApplied = false;
    private boolean configurationApplying = false;
    private String lastError = "";

    private WizardDataManager() {
    }

    public static WizardDataManager getInstance() {
        if (instance == null) {
            instance = new WizardDataManager();
        }
        return instance;
    }

    public void setOptimizationProfile(String profile) {
        this.optimizationProfile = profile;
        PackCore.LOGGER.debug("Set optimization profile: {}", (Object)profile);
    }

    public String getOptimizationProfile() {
        return this.optimizationProfile;
    }

    public void setResourcePacksOrdered(List<String> packs) {
        this.resourcePacksOrdered.clear();
        this.resourcePacksOrdered.addAll(packs);
        PackCore.LOGGER.debug("Set resource packs: {}", packs);
    }

    public List<String> getResourcePacksOrdered() {
        return new ArrayList<String>(this.resourcePacksOrdered);
    }

    public void setTabDesign(String design) {
        this.tabDesign = design;
        PackCore.LOGGER.debug("Set tab design: {}", (Object)design);
    }

    public String getTabDesign() {
        return this.tabDesign;
    }

    public void setConfigurationApplying(boolean applying) {
        this.configurationApplying = applying;
    }

    public boolean isConfigurationApplying() {
        return this.configurationApplying;
    }

    public void setConfigurationApplied(boolean applied) {
        this.configurationApplied = applied;
    }

    public boolean isConfigurationApplied() {
        return this.configurationApplied;
    }

    public void setConfigurationResult(String result, String errorMessage) {
        this.lastError = errorMessage != null ? errorMessage : "";
        PackCore.LOGGER.debug("Configuration result: {} - {}", (Object)result, (Object)errorMessage);
    }

    public String getConfigurationResult() {
        return this.configurationApplied ? "success" : (!this.lastError.isEmpty() ? "failed" : "");
    }

    public String getConfigurationErrorMessage() {
        return this.lastError;
    }

    public Set<String> getAdditionalSettings() {
        return new HashSet<String>();
    }

    public WizardConfiguration getConfiguration() {
        return new WizardConfiguration(this.optimizationProfile, new ArrayList<String>(this.resourcePacksOrdered), this.tabDesign);
    }

    public boolean isConfigurationComplete() {
        return !this.optimizationProfile.isEmpty();
    }

    public void reset() {
        this.optimizationProfile = "";
        this.resourcePacksOrdered.clear();
        this.tabDesign = "";
        this.configurationApplied = false;
        this.configurationApplying = false;
        this.lastError = "";
        PackCore.LOGGER.info("Wizard data reset");
    }

    public static void clearInstance() {
        instance = null;
    }

    public static class WizardConfiguration {
        private final String optimizationProfile;
        private final List<String> resourcePacksOrdered;
        private final String tabDesign;

        public WizardConfiguration(String optimizationProfile, List<String> resourcePacksOrdered, String tabDesign) {
            this.optimizationProfile = optimizationProfile;
            this.resourcePacksOrdered = resourcePacksOrdered;
            this.tabDesign = tabDesign;
        }

        public String getOptimizationProfile() {
            return this.optimizationProfile;
        }

        public List<String> getResourcePacksOrdered() {
            return new ArrayList<String>(this.resourcePacksOrdered);
        }

        public String getTabDesign() {
            return this.tabDesign;
        }

        public Set<String> getAdditionalSettings() {
            return new HashSet<String>();
        }

        public Map<String, Object> getCustomSettings() {
            return new HashMap<String, Object>();
        }
    }
}

