/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.help.guide;

import com.github.kd_gaming1.packcore.gui.help.guide.GuideViewerScreen;
import com.github.kd_gaming1.packcore.gui.help.guide.util.GuideInfo;
import com.github.kd_gaming1.packcore.gui.help.guide.util.GuideUtil;
import com.github.kd_gaming1.packcore.gui.util.UiSurfaces;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class BaseGuidePage
extends BaseOwoScreen<FlowLayout> {
    private final class_2960 backgroundTexture = class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png");
    private FlowLayout guideListContainer;

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(UiSurfaces.stretched(this.backgroundTexture, 1920, 1082)).padding(Insets.of((int)8));
        rootComponent.child((Component)this.createHeader());
        rootComponent.child((Component)this.createMainContent());
        this.loadGuides();
    }

    private FlowLayout createHeader() {
        FlowLayout header = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)42)).padding(Insets.of((int)2)).verticalAlignment(VerticalAlignment.CENTER);
        header.child((Component)Components.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/assets/sbe_logo.png"), (int)0, (int)0, (int)40, (int)40, (int)40, (int)40));
        header.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Guides & Help").method_27694(s -> s.method_27704(class_2960.method_60655((String)"packcore", (String)"gallaeciaforte")))).color(Color.ofRgb((int)-10496)).shadow(true).margins(Insets.of((int)0, (int)0, (int)4, (int)4)));
        header.child((Component)Containers.horizontalFlow((Sizing)Sizing.expand(), (Sizing)Sizing.expand()));
        header.child(Components.button((class_2561)class_2561.method_43470((String)"Close"), btn -> class_310.method_1551().method_1507(null)).renderer(ButtonComponent.Renderer.texture((class_2960)class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/previous.png"), (int)0, (int)0, (int)90, (int)57)).sizing(Sizing.fixed((int)90), Sizing.fixed((int)19)));
        return header;
    }

    private FlowLayout createMainContent() {
        FlowLayout mainContent = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.expand()).gap(6).padding(Insets.of((int)8));
        mainContent.child(Components.label((class_2561)TextOps.withColor((String)"Welcome to the PackCore Guides & Help! Browse the list of guides, or join the Discord for help.", (int)0xFFFFFF)).horizontalSizing(Sizing.fill((int)100)).margins(Insets.of((int)0, (int)0, (int)2, (int)0)));
        this.guideListContainer = Containers.verticalFlow((Sizing)Sizing.fill((int)98), (Sizing)Sizing.content()).gap(4);
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)this.guideListContainer).scrollbar(ScrollContainer.Scrollbar.vanilla()).scrollbarThiccness(6);
        mainContent.child((Component)scrollContainer);
        return mainContent;
    }

    private void loadGuides() {
        this.guideListContainer.clearChildren();
        List<GuideInfo> guides = GuideUtil.loadAvailableGuides();
        if (guides.isEmpty()) {
            LabelComponent noGuidesLabel = Components.label((class_2561)TextOps.withColor((String)"No guides found. Place .md files in the packcore/guides folder.", (int)0xB9BBBE));
            this.guideListContainer.child((Component)noGuidesLabel);
        } else {
            for (GuideInfo guide : guides) {
                this.guideListContainer.child((Component)this.createGuideEntry(guide));
            }
        }
    }

    private FlowLayout createGuideEntry(GuideInfo guide) {
        FlowLayout entry = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(2).padding(Insets.of((int)8)).surface(Surface.flat((int)0x30000000).and(Surface.outline((int)0x20FFFFFF))).margins(Insets.of((int)0, (int)0, (int)2, (int)0));
        LabelComponent titleLabel = Components.label((class_2561)class_2561.method_43470((String)guide.getTitle())).color(Color.ofRgb((int)-10496)).shadow(false);
        LabelComponent previewLabel = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)guide.getPreview())).color(Color.ofRgb((int)0xB9BBBE)).sizing(Sizing.fill((int)100), Sizing.content());
        entry.child((Component)titleLabel);
        entry.child((Component)previewLabel);
        this.setupGuideEntryInteraction(entry, guide);
        return entry;
    }

    private void setupGuideEntryInteraction(FlowLayout entry, GuideInfo guide) {
        entry.mouseEnter().subscribe(() -> entry.surface(Surface.flat((int)0x40FFFFFF).and(Surface.outline((int)0x40FFFFFF))));
        entry.mouseLeave().subscribe(() -> entry.surface(Surface.flat((int)0x30000000).and(Surface.outline((int)0x20FFFFFF))));
        entry.mouseDown().subscribe((mouseX, mouseY, button) -> {
            if (button == 0) {
                this.openGuide(guide);
                return true;
            }
            return false;
        });
        entry.cursorStyle(CursorStyle.HAND);
    }

    private void openGuide(GuideInfo guide) {
        if (!guide.isContentLoaded()) {
            GuideUtil.loadGuideContent(guide);
        }
        this.field_22787.method_1507((class_437)new GuideViewerScreen(guide, (class_437)this));
    }

    public void refresh() {
        this.loadGuides();
    }
}

