/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.gui.help.introduction;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.gui.help.BaseWizardPage;
import com.github.kd_gaming1.packcore.gui.help.WizardDataManager;
import com.github.kd_gaming1.packcore.gui.help.WizardNavigator;
import com.github.kd_gaming1.packcore.lavendermd.CustomLavenderCompiler;
import com.github.kd_gaming1.packcore.util.MarkdownFileUtil;
import com.github.kd_gaming1.packcore.util.modpack.ModpackInfo;
import io.wispforest.lavendermd.MarkdownFeature;
import io.wispforest.lavendermd.MarkdownProcessor;
import io.wispforest.lavendermd.feature.BasicFormattingFeature;
import io.wispforest.lavendermd.feature.BlockQuoteFeature;
import io.wispforest.lavendermd.feature.ColorFeature;
import io.wispforest.lavendermd.feature.ImageFeature;
import io.wispforest.lavendermd.feature.LinkFeature;
import io.wispforest.lavendermd.feature.ListFeature;
import io.wispforest.owo.ops.TextOps;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class IntroductionScreenPageOne
extends BaseWizardPage {
    private static final MarkdownProcessor<ParentComponent> MARKDOWN_PROCESSOR = new MarkdownProcessor(CustomLavenderCompiler::new, new MarkdownFeature[]{new BasicFormattingFeature(), new ColorFeature(), new LinkFeature(), new ListFeature(), new BlockQuoteFeature(), new ImageFeature()});
    private static final Map<String, ParentComponent> COMPONENT_CACHE = new ConcurrentHashMap<String, ParentComponent>();
    private final String welcomeMarkdown;
    private final ModpackInfo modpackInfo;
    private String selectedOptimisationProfile = "";
    LabelComponent headerTitle;
    private FlowLayout rightPanel;
    private static final int SELECTED_OUTLINE_COLOR = -16711936;
    private static final int UNSELECTED_OUTLINE_COLOR = -10496;
    private final List<OptionProfile> allProfiles = List.of(new OptionProfile("Max FPS", "Profile: Max FPS", "Maximizes performance by reducing visual effects and render distances. Uses fast graphics mode, minimal particles, and optimized settings for the highest possible frame rates. Perfect for older hardware."), new OptionProfile("Balanced", "Profile: Balanced", "Provides an optimal balance between performance and visual quality. Maintains good frame rates while preserving important visual features like shadows and fancy graphics. Ideal for most gaming scenarios and hardware configurations."), new OptionProfile("Quality", "Profile: Quality", "Prioritizes visual fidelity with high render distances, fancy graphics mode, and enhanced visual effects. Includes fabulous graphics with improved lighting and shadows. Best suited for high-end systems or content creation."), new OptionProfile("Shaders", "Profile: Shaders", "Ultimate visual experience combining quality settings with shaders enabled. Features high render distances, fabulous graphics, and optimized settings and shaders enabled from the get go. Requires high-end hardware for optimal performance."));

    public IntroductionScreenPageOne() {
        super(new BaseWizardPage.WizardPageInfo((class_2561)class_2561.method_43470((String)"FPS OR QUALITY???"), 1, 5), class_2960.method_60655((String)"packcore", (String)"textures/gui/wizard/welcome_bg.png"));
        this.welcomeMarkdown = MarkdownFileUtil.readMarkdownFile("Optimisation.md");
        this.modpackInfo = PackCore.getModpackInfo();
        String savedProfile = WizardDataManager.getInstance().getOptimizationProfile();
        if (!savedProfile.isEmpty()) {
            this.selectedOptimisationProfile = savedProfile;
        }
    }

    @Override
    protected void buildContent(FlowLayout contentContainer) {
        contentContainer.child((Component)this.createWelcomeHeader());
        contentContainer.child(this.createMarkdownSection());
    }

    @Override
    protected void buildContentRight(FlowLayout contentContainerRight) {
        this.rightPanel = contentContainerRight;
        this.rightPanel.child((Component)this.createHeader());
        this.rightPanel.child(this.createProfilesScrollContainer());
    }

    private FlowLayout createWelcomeHeader() {
        FlowLayout header = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6);
        class_5250 welcomeText = TextOps.concat((class_2561)TextOps.withColor((String)"Choose your prefer optimisation profile for ", (int)0xFFFFFF), (class_2561)class_2561.method_43470((String)this.modpackInfo.getName()).method_10862(class_2583.field_24360.method_36139(-10496).method_10982(Boolean.TRUE)));
        LabelComponent welcomeTitle = Components.label((class_2561)welcomeText);
        LabelComponent subtitle = (LabelComponent)Components.label((class_2561)class_2561.method_43470((String)"Please read the information below carefully before continuing. Need help? Click the discord button at the bottom.").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.TRUE))).color(Color.ofRgb((int)0xB9BBBE)).margins(Insets.of((int)2, (int)0, (int)2, (int)0)).sizing(Sizing.expand(), Sizing.content());
        header.child((Component)welcomeTitle).child((Component)subtitle);
        return header;
    }

    private ScrollContainer<FlowLayout> createMarkdownSection() {
        FlowLayout markdownWrapper = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(4);
        Component markdownComponent = COMPONENT_CACHE.computeIfAbsent(this.welcomeMarkdown, arg_0 -> MARKDOWN_PROCESSOR.process(arg_0)).horizontalSizing(Sizing.fill((int)98));
        markdownWrapper.child(markdownComponent);
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)markdownWrapper);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scrollContainer.scrollbarThiccness(6);
        scrollContainer.surface(Surface.flat((int)0x40000000).and(Surface.outline((int)0x30FFFFFF)));
        scrollContainer.padding(Insets.of((int)8));
        return scrollContainer;
    }

    private FlowLayout createHeader() {
        FlowLayout header = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content()).gap(6).margins(Insets.top((int)4));
        this.headerTitle = this.selectedOptimisationProfile.isEmpty() ? (LabelComponent)Components.label((class_2561)TextOps.withColor((String)"Select your optimisation profile by clicking one of the boxes below", (int)-10496)).horizontalSizing(Sizing.fill((int)100)) : (LabelComponent)Components.label((class_2561)TextOps.withColor((String)("Your selected profile is: " + this.selectedOptimisationProfile), (int)-10496)).horizontalSizing(Sizing.fill((int)100));
        header.child((Component)this.headerTitle);
        return header;
    }

    private FlowLayout createProfileBox(OptionProfile profile) {
        boolean isSelected = profile.key.equals(this.selectedOptimisationProfile);
        FlowLayout box = Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content());
        box.surface(Surface.flat((int)553637632).and(Surface.outline((int)(isSelected ? -16711936 : -10496))));
        box.padding(Insets.of((int)2));
        LabelComponent infoTitle = (LabelComponent)Components.label((class_2561)TextOps.withColor((String)profile.title, (int)-10496).method_10862(class_2583.field_24360.method_10982(Boolean.TRUE))).margins(Insets.of((int)2, (int)2, (int)2, (int)2));
        LabelComponent infoText = (LabelComponent)Components.label((class_2561)TextOps.withColor((String)profile.description, (int)0xFFFFFF).method_10862(class_2583.field_24360.method_10978(Boolean.TRUE))).horizontalSizing(Sizing.fill((int)100)).margins(Insets.of((int)2, (int)2, (int)2, (int)2));
        box.child((Component)infoTitle).child((Component)infoText);
        box.mouseDown().subscribe((mouseX, mouseY, button) -> {
            this.selectedOptimisationProfile(profile.key);
            return true;
        });
        return box;
    }

    private ScrollContainer<FlowLayout> createProfilesScrollContainer() {
        FlowLayout profilesLayout = Containers.verticalFlow((Sizing)Sizing.fill((int)96), (Sizing)Sizing.content()).gap(6);
        for (OptionProfile profile : this.allProfiles) {
            profilesLayout.child((Component)this.createProfileBox(profile));
        }
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand(), (Component)profilesLayout);
        scrollContainer.scrollbar(ScrollContainer.Scrollbar.vanilla());
        scrollContainer.scrollbarThiccness(6);
        scrollContainer.surface(Surface.flat((int)0x40000000).and(Surface.outline((int)0x30FFFFFF)));
        scrollContainer.padding(Insets.of((int)6));
        scrollContainer.margins(Insets.bottom((int)4));
        return scrollContainer;
    }

    private void selectedOptimisationProfile(String profileKey) {
        this.selectedOptimisationProfile = profileKey;
        WizardDataManager.getInstance().setOptimizationProfile(profileKey);
        if (this.headerTitle != null) {
            this.headerTitle.text((class_2561)TextOps.withColor((String)("Your selected performance profile: " + this.selectedOptimisationProfile), (int)-10496));
        }
        this.updateProfileBoxes();
    }

    private void updateProfileBoxes() {
        this.rightPanel.children().stream().filter(child -> child instanceof ScrollContainer).findFirst().ifPresent(scrollContainer -> {
            FlowLayout profilesLayout = (FlowLayout)((ScrollContainer)scrollContainer).child();
            for (int i = 0; i < profilesLayout.children().size() && i < this.allProfiles.size(); ++i) {
                Component child = (Component)profilesLayout.children().get(i);
                if (!(child instanceof FlowLayout)) continue;
                FlowLayout existingBox = (FlowLayout)child;
                OptionProfile profile = this.allProfiles.get(i);
                boolean isSelected = profile.key.equals(this.selectedOptimisationProfile);
                existingBox.surface(Surface.flat((int)553637632).and(Surface.outline((int)(isSelected ? -16711936 : -10496))));
            }
        });
    }

    @Override
    protected void onContinuePressed() {
        this.field_22787.method_1507(WizardNavigator.createWizardPage(2));
    }

    @Override
    protected int getContentColumnWidthPercent() {
        return 55;
    }

    @Override
    protected boolean shouldShowStatusInfo() {
        return false;
    }

    @Override
    protected boolean shouldShowRightPanel() {
        return true;
    }

    public record OptionProfile(String key, String title, String description) {
    }
}

