/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.util.config;

import com.github.kd_gaming1.packcore.PackCore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_3288;

public class ResourcePackUtil {
    private static final Map<String, String[]> MULTI_PACK_KEYWORDS = Map.of("HypixelPlus", new String[]{"hypixel"}, "FurfSkyOverlay", new String[]{"overlay", "furfsky"}, "FurfSkyFull", new String[]{"full", "furfsky"}, "SkyBlockDarkUI", new String[]{"skyblock", "dark ui", "dark_ui"}, "Defrosted", new String[]{"defrosted"}, "Looshy", new String[]{"looshy"});
    private static final Map<String, String> PACK_KEYWORDS = Map.of("HypixelPlus", "hypixel", "FurfSkyOverlay", "overlay", "FurfSkyFull", "furfsky", "SkyBlockDarkUI", "skyblock dark ui", "Defrosted", "defrosted", "Looshy", "looshy");

    public static CompletableFuture<Boolean> applyResourcePacksOrdered(List<String> packKeysOrdered) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        try {
            class_310 client = class_310.method_1551();
            if (client == null) {
                return CompletableFuture.completedFuture(false);
            }
            List<String> foundPackIds = ResourcePackUtil.findAvailablePackIdsOrderedList(packKeysOrdered);
            if (foundPackIds.isEmpty()) {
                PackCore.LOGGER.warn("No matching resource packs found for keys: {}", packKeysOrdered);
                return CompletableFuture.completedFuture(false);
            }
            PackCore.LOGGER.info("Found {} packs in order: {}", (Object)foundPackIds.size(), foundPackIds);
            client.execute(() -> ResourcePackUtil.applyPacksOnMainThread(foundPackIds, result));
        }
        catch (Exception e) {
            PackCore.LOGGER.error("Failed to apply resource packs", (Throwable)e);
            return CompletableFuture.completedFuture(false);
        }
        return result.completeOnTimeout(false, 10L, TimeUnit.SECONDS);
    }

    private static void applyPacksOnMainThread(List<String> foundPackIds, CompletableFuture<Boolean> result) {
        try {
            class_310 client = class_310.method_1551();
            class_3283 packManager = client.method_1520();
            ArrayList currentPacks = new ArrayList(client.field_1690.field_1887);
            ArrayList<String> newPacks = new ArrayList<String>();
            Set<String> allKnownPackIds = ResourcePackUtil.getAllKnownPackIds();
            PackCore.LOGGER.info("Current packs from options.txt: {}", currentPacks);
            PackCore.LOGGER.info("All known managed pack IDs: {}", allKnownPackIds);
            PackCore.LOGGER.info("Packs to add (in order): {}", foundPackIds);
            for (String pack : currentPacks) {
                if (!allKnownPackIds.contains(pack)) {
                    newPacks.add(pack);
                    PackCore.LOGGER.info("Keeping non-managed pack: {}", (Object)pack);
                    continue;
                }
                PackCore.LOGGER.info("Removing previously enabled managed pack: {}", (Object)pack);
            }
            PackCore.LOGGER.info("Base packs (after removing managed): {}", newPacks);
            Collections.reverse(foundPackIds);
            for (int i = 0; i < foundPackIds.size(); ++i) {
                String packId = foundPackIds.get(i);
                if (!newPacks.contains(packId)) {
                    newPacks.add(packId);
                    PackCore.LOGGER.info("Adding resource pack: {} (reversed index: {}, final position: {})", new Object[]{packId, i + 1, newPacks.size() - 1});
                    continue;
                }
                PackCore.LOGGER.warn("Pack {} was already in the list, skipping duplicate", (Object)packId);
            }
            PackCore.LOGGER.info("Final pack order for options.txt: {}", newPacks);
            packManager.method_14447(newPacks);
            client.field_1690.field_1887.clear();
            client.field_1690.field_1887.addAll(newPacks);
            client.field_1690.method_1640();
            ((CompletableFuture)client.method_1521().thenRun(() -> {
                PackCore.LOGGER.info("Resource reload completed successfully");
                result.complete(true);
            })).exceptionally(e -> {
                PackCore.LOGGER.error("Resource reload failed", e);
                result.complete(false);
                return null;
            });
        }
        catch (Exception e2) {
            PackCore.LOGGER.error("Failed to apply packs", (Throwable)e2);
            result.complete(false);
        }
    }

    private static List<String> findAvailablePackIdsOrderedList(List<String> packKeysOrdered) {
        ArrayList<String> found = new ArrayList<String>();
        class_310 client = class_310.method_1551();
        if (client == null) {
            return found;
        }
        class_3283 packManager = client.method_1520();
        Collection allProfiles = packManager.method_14441();
        for (int index = 0; index < packKeysOrdered.size(); ++index) {
            String key = packKeysOrdered.get(index).trim();
            if (key.isEmpty()) continue;
            Object[] keywords = ResourcePackUtil.getKeywordsForPack(key);
            if (keywords == null) {
                PackCore.LOGGER.warn("No keywords found for pack key: {}", (Object)key);
                continue;
            }
            PackCore.LOGGER.info("Looking for pack '{}' (selection #{}) with keywords: {}", new Object[]{key, index + 1, Arrays.toString(keywords)});
            class_3288 bestMatch = ResourcePackUtil.findBestMatch(allProfiles, (String[])keywords);
            if (bestMatch != null) {
                found.add(bestMatch.method_14463());
                PackCore.LOGGER.info("MATCHED '{}' -> '{}' (display: '{}') [Selection #{} -> Pack position #{}]", new Object[]{key, bestMatch.method_14463(), bestMatch.method_14457().getString(), index + 1, found.size()});
                continue;
            }
            PackCore.LOGGER.warn("No match found for pack '{}' (selection #{}) with keywords: {}", new Object[]{key, index + 1, Arrays.toString(keywords)});
        }
        return found;
    }

    private static String[] getKeywordsForPack(String key) {
        String keyword;
        String[] keywords = MULTI_PACK_KEYWORDS.get(key);
        if (keywords == null && (keyword = PACK_KEYWORDS.get(key)) != null) {
            keywords = new String[]{keyword};
        }
        return keywords;
    }

    private static class_3288 findBestMatch(Collection<class_3288> allProfiles, String[] keywords) {
        class_3288 bestMatch = null;
        int bestScore = -1;
        for (class_3288 profile : allProfiles) {
            String name = ResourcePackUtil.stripMinecraftColors(profile.method_14457().getString().toLowerCase());
            String id = ResourcePackUtil.stripMinecraftColors(profile.method_14463().toLowerCase());
            String desc = ResourcePackUtil.stripMinecraftColors(profile.method_14459().getString().toLowerCase());
            for (String keyword : keywords) {
                String kw = keyword.toLowerCase();
                int score = ResourcePackUtil.getMatchScore(id, name, desc, kw);
                if (score <= bestScore) continue;
                bestScore = score;
                bestMatch = profile;
            }
        }
        return bestMatch;
    }

    private static int getMatchScore(String id, String name, String desc, String keyword) {
        if (id.contains(keyword)) {
            return 3;
        }
        if (name.contains(keyword)) {
            return 2;
        }
        if (desc.contains(keyword)) {
            return 1;
        }
        return -1;
    }

    private static Set<String> getAllKnownPackIds() {
        HashSet<String> allKnown = new HashSet<String>();
        class_310 client = class_310.method_1551();
        if (client == null) {
            return allKnown;
        }
        class_3283 packManager = client.method_1520();
        HashSet<String> allKeywords = new HashSet<String>(PACK_KEYWORDS.values());
        for (String[] keywords : MULTI_PACK_KEYWORDS.values()) {
            allKeywords.addAll(Arrays.asList(keywords));
        }
        for (String keyword : allKeywords) {
            for (class_3288 profile : packManager.method_14441()) {
                String name = ResourcePackUtil.stripMinecraftColors(profile.method_14457().getString().toLowerCase());
                String id = ResourcePackUtil.stripMinecraftColors(profile.method_14463().toLowerCase());
                String desc = ResourcePackUtil.stripMinecraftColors(profile.method_14459().getString().toLowerCase());
                if (!name.contains(keyword) && !id.contains(keyword) && !desc.contains(keyword)) continue;
                allKnown.add(profile.method_14463());
            }
        }
        PackCore.LOGGER.debug("All known managed pack IDs: {}", allKnown);
        return allKnown;
    }

    private static Set<String> findAvailablePackIds(Set<String> packKeys) {
        HashSet<String> found = new HashSet<String>();
        class_310 client = class_310.method_1551();
        if (client == null) {
            return found;
        }
        class_3283 packManager = client.method_1520();
        Collection allProfiles = packManager.method_14441();
        for (String key : packKeys) {
            Object[] keywords = ResourcePackUtil.getKeywordsForPack(key);
            if (keywords == null) continue;
            PackCore.LOGGER.info("Looking for pack '{}' with keywords: {}", (Object)key, (Object)Arrays.toString(keywords));
            boolean foundMatch = false;
            for (class_3288 profile : allProfiles) {
                String id = ResourcePackUtil.stripMinecraftColors(profile.method_14463().toLowerCase());
                for (Object keyword : keywords) {
                    if (!id.contains((CharSequence)keyword)) continue;
                    found.add(profile.method_14463());
                    PackCore.LOGGER.info("MATCHED '{}' -> '{}' via keyword '{}' in filename", new Object[]{key, profile.method_14463(), keyword});
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) continue;
                break;
            }
            if (foundMatch) continue;
            PackCore.LOGGER.warn("No match found for key '{}' with keywords: {}", (Object)key, (Object)Arrays.toString(keywords));
        }
        return found;
    }

    private static String stripMinecraftColors(String text) {
        return text.replaceAll("\u00a7[0-9a-fk-or]", "");
    }
}

