package com.github.kd_gaming1.packcore.command.packcore;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.ui.help.guide.GuideListScreen;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class GuideCommand {

    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return ClientCommandManager.literal("guide").executes(GuideCommand::execute);
    }

    private static int execute(CommandContext<FabricClientCommandSource> context) {
        class_310 client = context.getSource().getClient();

        if (client == null) {
            context.getSource().sendError(class_2561.method_43470("Unable to access Minecraft client"));
            return 0;
        }

        /*
            After executing a command, the current screen will be closed (the chat hud).
            And if you open a new screen in a command, that new screen will be closed
            instantly along with the chat hud. Slightly delaying the opening of the
            screen fixes this issue.
         */
        client.method_63588(() -> {
            try {
                client.method_1507(new GuideListScreen());
            } catch (Exception e) {
                PackCore.LOGGER.error("Failed to open guide: {}", e.getMessage());
            }
        });

        return 1;
    }
}
