package com.github.kd_gaming1.packcore.notification;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.ui.toast.PackCoreToast;
import java.nio.file.Path;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ExportNotifications {
    public static void notifyExportComplete(String configName, Path exportPath) {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;

        // If player is in-game, send chat message
        if (player != null && client.field_1687 != null) {
            sendChatNotification(player, configName, exportPath);
        } else {
            // If not in-game, show toast
            showToastNotification(configName, exportPath);
        }
    }

    private static void sendChatNotification(class_746 player, String configName, Path exportPath) {
        try {
            String folderPath = exportPath.getParent().toUri().toString();
            class_2558 clickEvent = new class_2558.class_10607(exportPath.getParent());

            class_2561 message = class_2561.method_43470("[PackCore] ").method_27695(class_124.field_1065, class_124.field_1067)
                    .method_10852(class_2561.method_43470("Export completed! ").method_27692(class_124.field_1060))
                    .method_10852(class_2561.method_43470("\"" + configName + "\"").method_27692(class_124.field_1054))
                    .method_10852(class_2561.method_43470(" [Click to open folder]").method_27695(class_124.field_1075, class_124.field_1073)
                            .method_27694(style -> style.method_10958(clickEvent)));

            player.method_7353(message, false);
        } catch (Exception e) {
            PackCore.LOGGER.warn("[Export] Failed to send chat notification", e);
            // Fallback to toast
            showToastNotification(configName, exportPath);
        }
    }

    private static void showToastNotification(String configName, Path exportPath) {
        PackCoreToast.showExportComplete(configName, String.valueOf(exportPath));
    }
}