/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.command.scamshield;

import com.github.kd_gaming1.packcore.PackCore;
import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.scamshield.ScamShieldScreenIntegration;
import com.github.kd_gaming1.packcore.scamshield.ScamWarningMessageBuilder;
import com.github.kd_gaming1.packcore.scamshield.detector.ConfidenceLevel;
import com.github.kd_gaming1.packcore.scamshield.detector.DetectionResult;
import com.github.kd_gaming1.packcore.scamshield.detector.ScamCategory;
import com.github.kd_gaming1.packcore.ui.screen.scamshield.ScamWarningScreen;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ScamShieldPreviewCommands {
    public static LiteralArgumentBuilder<FabricClientCommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"preview").then(ScamShieldPreviewCommands.registerLowPreview())).then(ScamShieldPreviewCommands.registerMediumPreview())).then(ScamShieldPreviewCommands.registerHighPreview())).then(ClientCommandManager.literal((String)"screen").executes(ScamShieldPreviewCommands::previewWarningScreen));
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> registerLowPreview() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"low").then(ClientCommandManager.literal((String)"phishing").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.LOW, ScamCategory.PHISHING)))).then(ClientCommandManager.literal((String)"giveaway").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.LOW, ScamCategory.FAKE_REWARD)))).then(ClientCommandManager.literal((String)"coop").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.LOW, ScamCategory.ACCOUNT_THEFT)))).then(ClientCommandManager.literal((String)"generic").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.LOW, ScamCategory.CUSTOM)));
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> registerMediumPreview() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"medium").then(ClientCommandManager.literal((String)"phishing").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.MEDIUM, ScamCategory.PHISHING)))).then(ClientCommandManager.literal((String)"giveaway").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.MEDIUM, ScamCategory.FAKE_REWARD)))).then(ClientCommandManager.literal((String)"coop").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.MEDIUM, ScamCategory.ACCOUNT_THEFT)))).then(ClientCommandManager.literal((String)"trade").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.MEDIUM, ScamCategory.TRADE_MANIPULATION)))).then(ClientCommandManager.literal((String)"generic").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.MEDIUM, ScamCategory.CUSTOM)));
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> registerHighPreview() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"high").then(ClientCommandManager.literal((String)"phishing").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.HIGH, ScamCategory.PHISHING)))).then(ClientCommandManager.literal((String)"giveaway").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.HIGH, ScamCategory.FAKE_REWARD)))).then(ClientCommandManager.literal((String)"coop").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.HIGH, ScamCategory.ACCOUNT_THEFT)))).then(ClientCommandManager.literal((String)"trade").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.HIGH, ScamCategory.TRADE_MANIPULATION)))).then(ClientCommandManager.literal((String)"generic").executes(ctx -> ScamShieldPreviewCommands.previewWarning((CommandContext<FabricClientCommandSource>)ctx, ConfidenceLevel.HIGH, ScamCategory.CUSTOM)));
    }

    private static int previewWarning(CommandContext<FabricClientCommandSource> context, ConfidenceLevel level, ScamCategory category) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            source.sendError((class_2561)class_2561.method_43470((String)"\u00a7c[ScamShield] Must be in-game to preview warnings"));
            return 0;
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7e[Preview Mode] " + level.getDisplayName() + " Confidence - " + category.getDisplayName())));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)""));
        DetectionResult.Builder builder = new DetectionResult.Builder("Example scam message for preview", "PreviewScammer", PackCoreConfig.scamShieldTriggerThreshold);
        builder.addScamTypeContribution(category.getScamTypeId(), level.getMinScore());
        DetectionResult mockResult = builder.build();
        class_2561 warningMessage = ScamWarningMessageBuilder.buildWarningMessage(mockResult);
        client.field_1724.method_7353(warningMessage, false);
        source.sendFeedback((class_2561)class_2561.method_43470((String)""));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77This is a preview. Real detections will look like this."));
        return 1;
    }

    private static int previewWarningScreen(CommandContext<FabricClientCommandSource> context) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            source.sendError((class_2561)class_2561.method_43470((String)"\u00a7c[ScamShield] Must be in-game to preview screen"));
            return 0;
        }
        source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7e[ScamShield] \u00a77Opening warning screen preview..."));
        DetectionResult.Builder builder = new DetectionResult.Builder("join my discord to verify your account and get free rewards!", "PreviewScammer", PackCoreConfig.scamShieldTriggerThreshold);
        builder.addScamTypeContribution("discord_verify_scam", 150);
        builder.addScamTypeContribution("credential_fishing", 100);
        DetectionResult mockResult = builder.build();
        try {
            ScamWarningScreen.ScamWarning warning = ScamShieldScreenIntegration.convertToWarning(mockResult);
            ScamWarningScreen warningScreen = new ScamWarningScreen(warning, () -> source.sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7a[ScamShield] Preview screen dismissed")));
            client.method_63588(() -> client.method_1507((class_437)warningScreen));
        }
        catch (Exception e) {
            source.sendError((class_2561)class_2561.method_43470((String)("\u00a7c[ScamShield] Failed to open preview screen: " + e.getMessage())));
            PackCore.LOGGER.error("[ScamShield] Preview screen error", (Throwable)e);
            return 0;
        }
        return 1;
    }
}

