/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.config.backup;

import com.github.kd_gaming1.packcore.util.io.file.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBackupOps {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalBackupOps.class);
    private static final DateTimeFormatter BACKUP_TIMESTAMP = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");

    public static Path createBackup(Path gameDir) {
        try {
            Path backupDir = gameDir.resolve("packcore/backups");
            Files.createDirectories(backupDir, new FileAttribute[0]);
            String timestamp = LocalDateTime.now().format(BACKUP_TIMESTAMP);
            Path backupPath = backupDir.resolve("config_backup_" + timestamp);
            Files.createDirectories(backupPath, new FileAttribute[0]);
            LOGGER.info("Creating backup at: {}", (Object)backupPath);
            LocalBackupOps.backupIfExists(gameDir.resolve("config"), backupPath.resolve("config"));
            LocalBackupOps.backupIfExists(gameDir.resolve("options.txt"), backupPath.resolve("options.txt"));
            LocalBackupOps.backupIfExists(gameDir.resolve("servers.dat"), backupPath.resolve("servers.dat"));
            Path currentMetadata = gameDir.resolve("packcore_metadata.json");
            if (Files.exists(currentMetadata, new LinkOption[0])) {
                Files.copy(currentMetadata, backupPath.resolve("packcore_metadata.json"), StandardCopyOption.REPLACE_EXISTING);
            }
            LOGGER.info("Backup created successfully at: {}", (Object)backupPath);
            return backupPath;
        }
        catch (IOException e) {
            LOGGER.error("Failed to create backup", (Throwable)e);
            return null;
        }
    }

    private static void backupIfExists(Path source, Path target) {
        try {
            if (Files.exists(source, new LinkOption[0])) {
                if (Files.isDirectory(source, new LinkOption[0])) {
                    FileUtils.copyDirectory(source, target);
                } else {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                }
                LOGGER.debug("Backed up: {}", (Object)source);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not backup: {} - {}", (Object)source, (Object)e.getMessage());
        }
    }

    public static void cleanOldBackups(Path gameDir, int keepCount) {
        Path backupDir = gameDir.resolve("packcore/backups");
        if (!Files.exists(backupDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> backups = Files.list(backupDir);){
            backups.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).sorted(Comparator.comparing(path -> {
                try {
                    return Files.getLastModifiedTime((Path)path, new LinkOption[0]);
                }
                catch (IOException e) {
                    return FileTime.fromMillis(0L);
                }
            }).reversed()).skip(keepCount).forEach(backup -> {
                LOGGER.info("Removing old backup: {}", (Object)backup.getFileName());
                FileUtils.deleteDirectory(backup);
            });
        }
        catch (IOException e) {
            LOGGER.warn("Failed to clean old backups", (Throwable)e);
        }
    }
}

