/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.config.backup;

import com.github.kd_gaming1.packcore.config.apply.FileDescriptionRegistry;
import com.github.kd_gaming1.packcore.config.apply.SelectiveConfigApplyService;
import com.github.kd_gaming1.packcore.config.backup.BackupManager;
import com.github.kd_gaming1.packcore.util.GsonUtils;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectiveBackupRestoreService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectiveBackupRestoreService.class);
    private static final Gson GSON = GsonUtils.GSON;
    private static final String PENDING_SELECTIVE_RESTORE_FILE = "packcore_pending_selective_restore.json";

    public static CompletableFuture<List<SelectiveConfigApplyService.SelectableFile>> scanBackupFiles(BackupManager.BackupInfo backup) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<SelectiveConfigApplyService.SelectableFile> files = new ArrayList<SelectiveConfigApplyService.SelectableFile>();
            Path gameDir = FabricLoader.getInstance().getGameDir();
            Path backupsDir = gameDir.resolve("packcore/backups");
            Path backupZip = backupsDir.resolve(backup.backupId() + ".zip");
            if (!Files.exists(backupZip, new LinkOption[0])) {
                LOGGER.error("Backup file not found: {}", (Object)backupZip);
                return files;
            }
            try (ZipFile zipFile = new ZipFile(backupZip.toFile());){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (entryName.equals("backup_metadata.json")) continue;
                    SelectiveConfigApplyService.SelectableFile.FileType type = SelectiveBackupRestoreService.determineFileType(entryName);
                    Optional<FileDescriptionRegistry.FileDescription> description = FileDescriptionRegistry.getDescription(entryName);
                    String displayName = description.map(FileDescriptionRegistry.FileDescription::displayName).orElseGet(() -> SelectiveBackupRestoreService.getDisplayName(entryName));
                    String desc = description.map(FileDescriptionRegistry.FileDescription::description).orElseGet(() -> SelectiveBackupRestoreService.getFileDescription(entryName, type));
                    files.add(new SelectiveConfigApplyService.SelectableFile(entryName, displayName, type, entry.getSize(), desc, entry.isDirectory()));
                }
                files.sort(Comparator.comparing(f -> f.type().ordinal()).thenComparing(f -> f.displayName()));
            }
            catch (IOException e) {
                LOGGER.error("Failed to scan backup files", (Throwable)e);
            }
            return files;
        });
    }

    public static CompletableFuture<Boolean> scheduleSelectiveRestore(BackupManager.BackupInfo backup, Set<String> selectedPaths) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path gameDir = FabricLoader.getInstance().getGameDir();
                Path pendingFile = gameDir.resolve(PENDING_SELECTIVE_RESTORE_FILE);
                PendingSelectiveRestore pending = new PendingSelectiveRestore(backup.backupId(), backup.getDisplayName(), selectedPaths);
                String json = GSON.toJson((Object)pending);
                Files.writeString(pendingFile, (CharSequence)json, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                LOGGER.info("[Selective Backup Restore] Scheduled {} files for restoration from: {}", (Object)selectedPaths.size(), (Object)backup.getDisplayName());
                class_310.method_1551().method_1592();
                return true;
            }
            catch (IOException e) {
                LOGGER.error("[Selective Backup Restore] Failed to schedule selective restore", (Throwable)e);
                return false;
            }
        });
    }

    public static boolean checkAndApplyPendingSelectiveRestore(Path gameDir) {
        Path pendingFile = gameDir.resolve(PENDING_SELECTIVE_RESTORE_FILE);
        if (!Files.exists(pendingFile, new LinkOption[0])) {
            return false;
        }
        try {
            String json = Files.readString(pendingFile, StandardCharsets.UTF_8);
            PendingSelectiveRestore pending = (PendingSelectiveRestore)GSON.fromJson(json, PendingSelectiveRestore.class);
            if (pending == null || pending.backupId == null || pending.selectedPaths == null) {
                LOGGER.warn("[Selective Backup Restore] Invalid pending selective restore file");
                Files.deleteIfExists(pendingFile);
                return false;
            }
            LOGGER.info("[Selective Backup Restore] Found pending selective restore: {} ({} files)", (Object)pending.backupName, (Object)pending.selectedPaths.size());
            Path backupsDir = gameDir.resolve("packcore/backups");
            Path backupZip = backupsDir.resolve(pending.backupId + ".zip");
            if (!Files.exists(backupZip, new LinkOption[0])) {
                LOGGER.error("[Selective Backup Restore] Backup file not found: {}", (Object)backupZip);
                Files.deleteIfExists(pendingFile);
                return false;
            }
            LOGGER.info("[Selective Backup Restore] Creating safety backup before restore.. .");
            BackupManager.createBackupAsync(gameDir, BackupManager.BackupType.AUTO, "Safety backup before selective restore", "Auto backup created before restoring files from: " + pending.backupId, msg -> {}).join();
            boolean success = SelectiveBackupRestoreService.restoreSelectedFilesSync(backupZip, pending.selectedPaths, gameDir, msg -> LOGGER.info("[Selective Backup Restore] {}", msg));
            if (success) {
                LOGGER.info("[Selective Backup Restore] Successfully restored {} selected files", (Object)pending.selectedPaths.size());
            } else {
                LOGGER.error("[Selective Backup Restore] Failed to restore selected files");
            }
            Files.deleteIfExists(pendingFile);
            return success;
        }
        catch (Exception e) {
            LOGGER.error("[Selective Backup Restore] Error processing pending selective restore", (Throwable)e);
            try {
                Files.deleteIfExists(pendingFile);
            }
            catch (IOException ex) {
                LOGGER.warn("[Selective Backup Restore] Failed to clean up pending file", (Throwable)ex);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean restoreSelectedFilesSync(Path backupZip, Set<String> selectedPaths, Path gameDir, Consumer<String> progressCallback) {
        boolean bl;
        progressCallback.accept("Extracting selected files...");
        Path tempDir = Files.createTempDirectory("packcore_selective_restore", new FileAttribute[0]);
        try {
            SelectiveBackupRestoreService.extractSelectedFiles(backupZip, selectedPaths, tempDir, progressCallback);
            progressCallback.accept("Restoring files...");
            SelectiveBackupRestoreService.copyFilesToGameDir(tempDir, gameDir, progressCallback);
            LOGGER.info("[Selective Backup Restore] Successfully restored {} selected files", (Object)selectedPaths.size());
            progressCallback.accept("Restore complete!");
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                SelectiveBackupRestoreService.deleteDirectory(tempDir);
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("[Selective Backup Restore] Failed to restore selected files", (Throwable)e);
                progressCallback.accept("Error: " + e.getMessage());
                return false;
            }
        }
        SelectiveBackupRestoreService.deleteDirectory(tempDir);
        return bl;
    }

    private static void extractSelectedFiles(Path backupZip, Set<String> selectedPaths, Path tempDir, Consumer<String> progressCallback) throws IOException {
        try (ZipFile zipFile = new ZipFile(backupZip.toFile());){
            int processed = 0;
            int total = selectedPaths.size();
            for (String selectedPath : selectedPaths) {
                ZipEntry entry = zipFile.getEntry(selectedPath);
                if (entry == null) {
                    LOGGER.warn("Entry not found in backup: {}", (Object)selectedPath);
                    continue;
                }
                Path targetPath = tempDir.resolve(selectedPath);
                if (entry.isDirectory()) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                    SelectiveBackupRestoreService.extractDirectory(zipFile, selectedPath, tempDir);
                } else {
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    try (InputStream is = zipFile.getInputStream(entry);){
                        Files.copy(is, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                int percentage = ++processed * 100 / total;
                progressCallback.accept(String.format("Extracting: %d%%", percentage));
            }
        }
    }

    private static void extractDirectory(ZipFile zipFile, String dirPath, Path tempDir) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(dirPath) || entry.isDirectory()) continue;
            Path targetPath = tempDir.resolve(entryName);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            InputStream is = zipFile.getInputStream(entry);
            try {
                Files.copy(is, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private static void copyFilesToGameDir(Path tempDir, Path gameDir, Consumer<String> progressCallback) throws IOException {
        ArrayList filesToCopy = new ArrayList();
        Files.walk(tempDir, new FileVisitOption[0]).forEach(filesToCopy::add);
        int total = filesToCopy.size();
        int processed = 0;
        for (Path sourcePath : filesToCopy) {
            if (Files.isRegularFile(sourcePath, new LinkOption[0])) {
                Path relativePath = tempDir.relativize(sourcePath);
                Path targetPath = gameDir.resolve(relativePath);
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.debug("Restored: {}", (Object)relativePath);
            }
            if (++processed % 10 != 0) continue;
            int percentage = processed * 100 / total;
            progressCallback.accept(String.format("Restoring files: %d%%", percentage));
        }
    }

    private static void deleteDirectory(Path directory) {
        try {
            Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    LOGGER.debug("Could not delete: {}", path);
                }
            });
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete temp directory: {}", (Object)directory);
        }
    }

    private static SelectiveConfigApplyService.SelectableFile.FileType determineFileType(String path) {
        if ((path = path.toLowerCase()).equals("options.txt")) {
            return SelectiveConfigApplyService.SelectableFile.FileType.GAME_OPTIONS;
        }
        if (path.equals("servers.dat")) {
            return SelectiveConfigApplyService.SelectableFile.FileType.SERVER_LIST;
        }
        if (path.startsWith("config/")) {
            return SelectiveConfigApplyService.SelectableFile.FileType.MOD_CONFIG;
        }
        if (path.startsWith("resourcepacks/")) {
            return SelectiveConfigApplyService.SelectableFile.FileType.RESOURCE_PACK;
        }
        return SelectiveConfigApplyService.SelectableFile.FileType.OTHER;
    }

    private static String getDisplayName(String path) {
        int lastSlash;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((lastSlash = path.lastIndexOf(47)) >= 0) {
            return path.substring(lastSlash + 1);
        }
        return path;
    }

    private static String getFileDescription(String path, SelectiveConfigApplyService.SelectableFile.FileType type) {
        String fileName;
        int dotIndex;
        if (path.startsWith("config/") && (dotIndex = (fileName = path.substring("config/".length())).indexOf(46)) > 0) {
            Object modName = fileName.substring(0, dotIndex);
            modName = ((String)modName).substring(0, 1).toUpperCase() + ((String)modName).substring(1);
            return "Configuration for " + (String)modName;
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case SelectiveConfigApplyService.SelectableFile.FileType.MOD_CONFIG -> "Mod configuration file";
            case SelectiveConfigApplyService.SelectableFile.FileType.GAME_OPTIONS -> "Minecraft game settings";
            case SelectiveConfigApplyService.SelectableFile.FileType.KEYBINDINGS -> "Control bindings";
            case SelectiveConfigApplyService.SelectableFile.FileType.RESOURCE_PACK -> "Resource pack";
            case SelectiveConfigApplyService.SelectableFile.FileType.SERVER_LIST -> "Multiplayer server list";
            case SelectiveConfigApplyService.SelectableFile.FileType.OTHER -> "Configuration file";
        };
    }

    private static class PendingSelectiveRestore {
        String backupId;
        String backupName;
        Set<String> selectedPaths;

        PendingSelectiveRestore(String backupId, String backupName, Set<String> selectedPaths) {
            this.backupId = backupId;
            this.backupName = backupName;
            this.selectedPaths = selectedPaths;
        }
    }
}

