/*
 * Decompiled with CFR 0.152.
 */
package com.github.kd_gaming1.packcore.prelaunch;

import com.github.kd_gaming1.packcore.config.PackCoreConfig;
import com.github.kd_gaming1.packcore.config.apply.ConfigApplyService;
import com.github.kd_gaming1.packcore.config.apply.ConfigAutoApplier;
import com.github.kd_gaming1.packcore.config.apply.SelectiveConfigApplyService;
import com.github.kd_gaming1.packcore.config.backup.SelectiveBackupRestoreService;
import com.github.kd_gaming1.packcore.config.update.ConfigUpdateService;
import com.github.kd_gaming1.packcore.util.io.file.FileLayoutInitializer;
import eu.midnightdust.lib.config.MidnightConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreLaunchWizardInitializer
implements PreLaunchEntrypoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreLaunchWizardInitializer.class);

    public void onPreLaunch() {
        boolean selectiveRestoreApplied;
        boolean selectiveConfigApplied;
        LOGGER.info("PackCore pre-launch initializer started");
        MidnightConfig.init((String)"packcore", PackCoreConfig.class);
        Path runDir = FabricLoader.getInstance().getGameDir();
        FileLayoutInitializer.initializeFileStructure();
        boolean configApplied = ConfigApplyService.checkAndApplyPendingConfig(runDir);
        if (configApplied) {
            LOGGER.info("Applied pending config during pre-launch");
            PackCoreConfig.defaultConfigSuccessfullyApplied = true;
            PackCoreConfig.write((String)"packcore");
        }
        if (selectiveConfigApplied = SelectiveConfigApplyService.checkAndApplyPendingSelectiveConfig(runDir)) {
            LOGGER.info("Applied pending selective config during pre-launch");
        }
        if (selectiveRestoreApplied = SelectiveBackupRestoreService.checkAndApplyPendingSelectiveRestore(runDir)) {
            LOGGER.info("Applied pending selective backup restore during pre-launch");
        }
        if (this.isUpgradeFromOldVersion(runDir)) {
            LOGGER.info("Upgrade from old pre 2.0 version detected");
            PackCoreConfig.isFirstStartup = false;
            PackCoreConfig.write((String)"packcore");
        } else if (this.shouldApplyConfigAutomatically()) {
            LOGGER.info("First launch detected - applying config automatically.. .");
            boolean success = ConfigAutoApplier.applyBestMatchingConfig(runDir);
            if (success) {
                LOGGER.info("Config applied successfully on first launch");
                PackCoreConfig.defaultConfigSuccessfullyApplied = true;
                PackCoreConfig.isFirstStartup = false;
                PackCoreConfig.write((String)"packcore");
                LOGGER.info("Skipping update configs - full config already applied");
                return;
            }
        }
        if (PackCoreConfig.defaultConfigSuccessfullyApplied) {
            LOGGER.info("Checking for config updates...");
            ConfigUpdateService.checkAndApplyUpdates(runDir);
        }
        LOGGER.info("PackCore pre-launch initialization complete");
    }

    private boolean shouldApplyConfigAutomatically() {
        return PackCoreConfig.isFirstStartup && !PackCoreConfig.defaultConfigSuccessfullyApplied;
    }

    private boolean isUpgradeFromOldVersion(Path gameDir) {
        boolean exists;
        Path oldFolder = gameDir.resolve("SkyBlock Enhanced");
        boolean bl = exists = Files.exists(oldFolder, new LinkOption[0]) && Files.isDirectory(oldFolder, new LinkOption[0]);
        if (exists) {
            LOGGER.info("Detected 'SkyBlock Enhanced' folder - this is an upgrade from old version");
        }
        return exists;
    }
}

